/*
 * Knob.h
 *
 *  Created on: 2008/08/06
 *      Author: syn
 */

#ifndef KNOB_H_
#define KNOB_H_

#include "Controller.h"

class KnobListener;

class Knob :public Controller{
public:
	Knob(const int min, const int max, const int val, KnobListener* listener);
	virtual ~Knob();

public:
	virtual void render();
	virtual void handleMouseButtonDown(const int x, const int y);
	virtual void handleMouseButtonUp(const int x, const int y);
	virtual void handleMouseMotion(const int btn, const int x, const int y);

protected:
	int mMin;
	int mMax;
	int mVal;
	bool mMousePressed;
	int mControllBaseY;
	int mControllBaseVal;
	KnobListener* mListener;
};

class KnobListener{
public:
	virtual ~KnobListener(){
	}

public:
	virtual void knobValueChanged(Knob* self, const int val) = 0;
};


#endif /* KNOB_H_ */
