/*
 * SynthController.h
 *
 *  Created on: 2008/08/02
 *      Author: syn
 */

#ifndef SYNTHCONTROLLER_H_
#define SYNTHCONTROLLER_H_

#include <list>
#include <SDL/SDL.h>
#include <lo/lo.h>
#include "thread.h"

class Controller;
class FTBufferFont;
union SDL_Event;

class SynthController:public Thread{
protected:
	SynthController();
public:
	virtual ~SynthController();

public:
	static SynthController* getInstance(){
		if(mInstance == 0){
			mInstance = new SynthController();
		}
		return mInstance;
	}
	void* run();
	void render();
	void addController(Controller* c);
	FTBufferFont* getFont();
	lo_address getSynthAddress();
	static void callback_Timer(void* p);

protected:
	bool initialize();
	void initializeGL();
	void handleMouseButtonDown(const int x, const int y);
	void handleMouseButtonUp(const int x, const int y);
	void handleMouseMotion(const int btn, const int x, const int y);
	void handleUserEvent(SDL_Event* evt);

protected:
	static SynthController* mInstance;
	SDL_Surface* mScreen;
	std::list<Controller*> mControllerSet;
	bool mTimerTaskIsFinished;
	FTBufferFont* mFont;
	lo_address mSynthAddress;
};

#endif /* SYNTHCONTROLLER_H_ */
