/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kayo.action;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import jp.co.kayo.action.Action;
import jp.co.kayo.io.ReplayBuffer;

public class Chat
extends Action {
    int m_flags;
    int m_mode;
    String m_message;

    public Chat(int actionid) {
        super(actionid);
    }

    public void parse(ReplayBuffer buf) {
        this.setId(buf.get());
        short n = buf.getShort();
        this.m_flags = buf.get();
        this.m_mode = buf.getInt();
        CharsetDecoder cd = Charset.forName("UTF-8").newDecoder();
        cd.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        byte[] ba = buf.readToken();
        char[] ca = new char[(int)(cd.maxCharsPerByte() * (float)ba.length)];
        ByteBuffer bb = ByteBuffer.wrap(ba, 0, ba.length);
        CharBuffer cb = CharBuffer.wrap(ca);
        CoderResult cr = cd.decode(bb, cb, true);
        this.m_message = cr.isMalformed() || cr.isUnmappable() ? "unsupport charset" : new String(bb.array());
    }

    public int getType() {
        return 101;
    }

    public String getTo() {
        switch (this.m_mode) {
            case 0: {
                return "all";
            }
            case 1: {
                return "allies";
            }
            case 2: {
                return "observers/referees";
            }
            case 3: {
                return "player[" + this.m_mode + "]";
            }
        }
        return "unknow";
    }

    public boolean availableAPM() {
        return false;
    }

    public String getMessage() {
        return this.m_message;
    }

    public String toXML() {
        String msg = this.m_message;
        msg = msg.replaceAll(">", "&gt;");
        msg = msg.replaceAll("<", "&lt;");
        SimpleDateFormat df = new SimpleDateFormat("mm:ss");
        StringBuffer xml = new StringBuffer();
        xml.append("<Message>").append("<PlayerID>").append(this.getId()).append("</PlayerID>").append("<Time msec='").append(this.getTime()).append("' >").append(df.format(new Date(this.getTime()))).append("</Time>").append("<To>").append(this.getTo()).append("</To>").append("<Content>").append(msg).append("</Content>").append("</Message>");
        return xml.toString();
    }
}

