/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kayo.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jp.co.kayo.gui.W3GFileFilter;
import jp.co.kayo.io.W3GReader;
import jp.co.kayo.io.XMLUtil;

public class W3G2XML
extends JFrame {
    private JPanel jContentPane = null;
    private JTextField m_txtFrom = null;
    private JButton m_btnFrom = null;
    private String m_folder = null;
    private JButton m_btnDone = null;
    private JCheckBox m_withXSL = null;
    private String m_xsl = "http://homepage2.nifty.com/richdego/sakusaku/jws/w3g.xsl";

    public W3G2XML() {
        this.initialize();
    }

    private void initialize() {
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.setSize(319, 122);
        this.setContentPane(this.getJContentPane());
        this.setTitle("W3G2XML");
        Dimension me = this.getSize();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        double w = dim.getWidth();
        double h = dim.getHeight();
        this.setLocation((int)(w - (double)me.width) / 2, (int)(h - (double)me.height) / 2);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            JLabel label1 = new JLabel();
            label1.setBounds(17, 5, 94, 15);
            label1.setText("w3g file:");
            this.jContentPane.add((Component)label1, null);
            this.jContentPane.add((Component)this.getTxtFrom(), null);
            this.jContentPane.add((Component)this.getBtnFrom(), null);
            JLabel label3 = new JLabel();
            label3.setBounds(41, 49, 94, 15);
            label3.setText("with xsl");
            this.jContentPane.add((Component)label3, null);
            this.jContentPane.add((Component)this.getBtnDone(), null);
            this.jContentPane.add((Component)this.getChkwithXSL(), null);
        }
        return this.jContentPane;
    }

    private String makeXMLFile(String filename) {
        int i;
        if (filename != null && (i = filename.lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            String xmlname = String.valueOf(filename.substring(0, i)) + ".xml";
            return xmlname;
        }
        return null;
    }

    private void convert(String fname) {
        String msg = "fail.";
        int status = 1;
        try {
            W3GReader reader = new W3GReader(fname);
            if (this.getChkwithXSL().isSelected()) {
                XMLUtil.saveXml(reader.getXML(), this.makeXMLFile(fname), this.m_xsl);
            } else {
                XMLUtil.saveXml(reader.getXML(), this.makeXMLFile(fname), null);
            }
            msg = "complete.";
        }
        catch (Exception e) {
            e.printStackTrace();
            status = 0;
        }
        JOptionPane.showMessageDialog(this, msg, "message", status);
    }

    private JTextField getTxtFrom() {
        if (this.m_txtFrom == null) {
            this.m_txtFrom = new JTextField();
            this.m_txtFrom.setBounds(16, 20, 238, 21);
        }
        return this.m_txtFrom;
    }

    private JButton getBtnFrom() {
        if (this.m_btnFrom == null) {
            this.m_btnFrom = new JButton();
            this.m_btnFrom.setBounds(258, 21, 27, 18);
            this.m_btnFrom.setText("...");
            this.m_btnFrom.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser();
                    if (W3G2XML.this.m_folder != null) {
                        chooser.setCurrentDirectory(new File(W3G2XML.this.m_folder));
                    }
                    W3GFileFilter filter = new W3GFileFilter();
                    chooser.setFileFilter(filter);
                    int returnVal = chooser.showOpenDialog(W3G2XML.this);
                    if (returnVal == 0) {
                        W3G2XML.this.getTxtFrom().setText(chooser.getSelectedFile().getAbsolutePath());
                        W3G2XML.this.m_folder = chooser.getSelectedFile().getPath();
                    }
                }
            });
        }
        return this.m_btnFrom;
    }

    private JButton getBtnDone() {
        if (this.m_btnDone == null) {
            this.m_btnDone = new JButton();
            this.m_btnDone.setBounds(207, 63, 85, 24);
            this.m_btnDone.setText("Transform");
            this.getRootPane().setDefaultButton(this.m_btnDone);
            this.m_btnDone.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    W3G2XML.this.convert(W3G2XML.this.getTxtFrom().getText());
                }
            });
        }
        return this.m_btnDone;
    }

    private JCheckBox getChkwithXSL() {
        if (this.m_withXSL == null) {
            this.m_withXSL = new JCheckBox();
            this.m_withXSL.setBounds(18, 47, 21, 21);
            this.m_withXSL.setText("with xsl");
        }
        return this.m_withXSL;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        W3G2XML frame = new W3G2XML();
        frame.show();
    }
}

