/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kayo.io;

import jp.co.kayo.io.PlayerRecord;
import jp.co.kayo.io.ReplayBuffer;
import jp.co.kayo.io.ReplayRecord;

public class GameStartRecord {
    private int m_selectmode;
    private int m_startspotcount;
    private long m_randomseed;

    public GameStartRecord(ReplayRecord data, ReplayBuffer replay) {
        byte recordID = replay.get();
        if (recordID == 25) {
            replay.skip(2);
            int nr = replay.get();
            int i = 0;
            while (i < nr) {
                byte playerid = replay.get();
                replay.skip();
                byte slotstatus = replay.get();
                byte computerplayerflag = replay.get();
                byte teamnumber = replay.get();
                byte color = replay.get();
                byte playerraceflags = replay.get();
                byte computerAIstrength = replay.get();
                byte playerhandicapinpercent = replay.get();
                PlayerRecord player = (PlayerRecord)data.getPlayermap().get(new Integer(playerid));
                if (player != null) {
                    player.setRace(playerraceflags & 0x3F);
                    player.setColor(color);
                    player.setHandicap(playerhandicapinpercent);
                    player.setSlotstatus(slotstatus);
                    player.setComputerPlayerFlag(computerplayerflag);
                    player.setTeam(teamnumber);
                }
                ++i;
            }
        }
        this.m_randomseed = replay.getInt();
        this.m_selectmode = replay.get();
        this.m_startspotcount = replay.get();
    }

    public long getRandomseed() {
        return this.m_randomseed;
    }

    public int getSelectmode() {
        return this.m_selectmode;
    }

    public int getStartspotcount() {
        return this.m_startspotcount;
    }
}

