/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.hsqldb.Trace;
import org.hsqldb.lib.HsqlByteArrayInputStream;
import org.hsqldb.lib.Storage;
import org.hsqldb.persist.ScaledRAFileInJar;

class ScaledRAFile
implements Storage {
    static final int DATA_FILE_RAF = 0;
    static final int DATA_FILE_NIO = 1;
    static final int DATA_FILE_JAR = 2;
    static final long MAX_NIO_LENGTH = 0x10000000L;
    final RandomAccessFile file;
    private final boolean readOnly;
    final String fileName;
    boolean isNio;
    boolean bufferDirty = true;
    byte[] buffer = new byte[4096];
    HsqlByteArrayInputStream ba = new HsqlByteArrayInputStream(this.buffer);
    long bufferOffset;
    long seekPosition;
    long realPosition;
    static int cacheHit;

    static Storage newScaledRAFile(String string, boolean bl, int n, String string2, String string3) throws FileNotFoundException, IOException {
        if (string2 != null) {
            try {
                Class<?> clazz = Class.forName(string2);
                Constructor<?> constructor = clazz.getConstructor(String.class, Boolean.class, Object.class);
                return (Storage)constructor.newInstance(string, new Boolean(bl), string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IOException();
            }
            catch (InstantiationException instantiationException) {
                throw new IOException();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException();
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IOException();
            }
        }
        if (n == 2) {
            return new ScaledRAFileInJar(string);
        }
        if (n == 0) {
            return new ScaledRAFile(string, bl);
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, bl ? "r" : "rw");
        if (randomAccessFile.length() > 0x10000000L) {
            return new ScaledRAFile(string, randomAccessFile, bl);
        }
        randomAccessFile.close();
        try {
            Class.forName("java.nio.MappedByteBuffer");
            Class<?> clazz = Class.forName("org.hsqldb.persist.NIOScaledRAFile");
            Constructor<?> constructor = clazz.getConstructor(String.class, Boolean.TYPE);
            return (ScaledRAFile)constructor.newInstance(string, new Boolean(bl));
        }
        catch (Exception exception) {
            return new ScaledRAFile(string, bl);
        }
    }

    ScaledRAFile(String string, RandomAccessFile randomAccessFile, boolean bl) throws FileNotFoundException, IOException {
        this.readOnly = bl;
        this.fileName = string;
        this.file = randomAccessFile;
    }

    ScaledRAFile(String string, boolean bl) throws FileNotFoundException, IOException {
        this.file = new RandomAccessFile(string, bl ? "r" : "rw");
        this.readOnly = bl;
        this.fileName = string;
    }

    public long length() throws IOException {
        return this.file.length();
    }

    public void seek(long l) throws IOException {
        if (this.file.length() < l) {
            this.file.seek(this.file.length());
            for (long i = this.file.length(); i < l; ++i) {
                this.file.write(0);
            }
        }
        this.seekPosition = l;
    }

    public long getFilePointer() throws IOException {
        return this.seekPosition;
    }

    private void readIntoBuffer() throws IOException {
        long l = this.seekPosition;
        this.bufferDirty = false;
        long l2 = l % (long)this.buffer.length;
        long l3 = this.file.length();
        long l4 = l3 - (l - l2);
        if (l4 <= 0L) {
            throw new IOException("read beyond end of file");
        }
        if (l4 > (long)this.buffer.length) {
            l4 = this.buffer.length;
        }
        this.file.seek(l - l2);
        this.file.readFully(this.buffer, 0, (int)l4);
        this.bufferOffset = l - l2;
        this.realPosition = this.bufferOffset + l4;
    }

    public int read() throws IOException {
        long l = this.file.length();
        if (this.seekPosition >= l) {
            return -1;
        }
        if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
            this.readIntoBuffer();
        } else {
            ++cacheHit;
        }
        this.ba.reset();
        this.ba.skip(this.seekPosition - this.bufferOffset);
        int n = this.ba.read();
        ++this.seekPosition;
        return n;
    }

    public long readLong() throws IOException {
        this.file.seek(this.seekPosition);
        this.realPosition = this.seekPosition;
        long l = this.file.readLong();
        this.realPosition += 8L;
        this.seekPosition = this.realPosition;
        return l;
    }

    public int readInt() throws IOException {
        if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
            this.readIntoBuffer();
        } else {
            ++cacheHit;
        }
        this.ba.reset();
        this.ba.skip(this.seekPosition - this.bufferOffset);
        int n = this.ba.readInt();
        this.seekPosition += 4L;
        return n;
    }

    public void read(byte[] byArray, int n, int n2) throws IOException {
        if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
            this.readIntoBuffer();
        } else {
            ++cacheHit;
        }
        this.ba.reset();
        this.ba.skip(this.seekPosition - this.bufferOffset);
        int n3 = this.ba.read(byArray, n, n2);
        this.seekPosition += (long)n3;
        if (n3 < n2) {
            if (this.seekPosition != this.realPosition) {
                this.file.seek(this.seekPosition);
            }
            this.file.readFully(byArray, n + n3, n2 - n3);
            this.seekPosition += (long)(n2 - n3);
            this.realPosition = this.seekPosition;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.realPosition != this.seekPosition) {
            this.file.seek(this.seekPosition);
        }
        if (this.seekPosition >= this.bufferOffset && this.seekPosition < this.bufferOffset + (long)this.buffer.length) {
            this.bufferDirty = true;
        }
        this.file.write(byArray, n, n2);
        this.seekPosition += (long)n2;
        this.realPosition = this.seekPosition;
    }

    public void writeInt(int n) throws IOException {
        if (this.realPosition != this.seekPosition) {
            this.file.seek(this.seekPosition);
        }
        if (this.seekPosition >= this.bufferOffset && this.seekPosition < this.bufferOffset + (long)this.buffer.length) {
            this.bufferDirty = true;
        }
        this.file.writeInt(n);
        this.seekPosition += 4L;
        this.realPosition = this.seekPosition;
    }

    public void writeLong(long l) throws IOException {
        if (this.realPosition != this.seekPosition) {
            this.file.seek(this.seekPosition);
        }
        if (this.seekPosition >= this.bufferOffset && this.seekPosition < this.bufferOffset + (long)this.buffer.length) {
            this.bufferDirty = true;
        }
        this.file.writeLong(l);
        this.seekPosition += 8L;
        this.realPosition = this.seekPosition;
    }

    public void close() throws IOException {
        Trace.printSystemOut("cache hit " + cacheHit);
        this.file.close();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean wasNio() {
        return false;
    }
}

