/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.help;

import com.jclark.xsl.sax.Destination;
import com.jclark.xsl.sax.OutputMethodHandler;
import com.jclark.xsl.sax.OutputMethodHandlerImpl;
import com.jclark.xsl.sax.XSLProcessor;
import com.jclark.xsl.sax.XSLProcessorImpl;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbRunRecoveryException;
import com.sleepycat.db.Dbc;
import com.sleepycat.db.Dbt;
import com.sun.star.help.HelpDatabases;
import com.sun.star.help.HelpOutputStream;
import com.sun.star.help.HelpProvider;
import com.sun.star.help.HelpURLStreamHandlerFactory;
import com.sun.star.help.StringDbt;
import com.sun.xmlsearch.util.PrefixTranslator;
import com.sun.xmlsearch.xml.indexer.XmlIndexBuilder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class HelpIndexer {
    private HelpURLStreamHandlerFactory _urlHandler = null;
    private String _language = null;
    private String _module = null;
    private String _system = null;
    Hashtable _hashDocInfo = new Hashtable();
    Hashtable _hashHelptext = new Hashtable();
    Keywords _keywords = new Keywords();
    ParseStuff _stuff = null;

    public HelpIndexer(HelpURLStreamHandlerFactory helpURLStreamHandlerFactory, String string, String string2, String string3) {
        this._urlHandler = helpURLStreamHandlerFactory;
        this._system = string3;
        this._language = string;
        this._module = string2;
    }

    private void schnitzel() {
        String string = HelpDatabases.getInstallDirectory();
        Db db = null;
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            db = new Db(null, 0);
            db.set_error_stream((OutputStream)System.err);
            db.set_errpfx("indexing");
            String string2 = string + this._language + File.separator + this._module + ".idx";
            File file = new File(string2);
            if (file.exists() && file.isFile()) {
                file.delete();
            }
            if (!file.exists()) {
                file.mkdir();
            }
            file = null;
            XmlIndexBuilder xmlIndexBuilder = new XmlIndexBuilder(string2);
            String[] stringArray = new String[]{"vnd.sun.star.help://", "#HLP#"};
            PrefixTranslator prefixTranslator = PrefixTranslator.makePrefixTranslator((String[])stringArray);
            xmlIndexBuilder.setPrefixTranslator(prefixTranslator);
            xmlIndexBuilder.clearIndex();
            xmlIndexBuilder.setTransformLocation(string + "..\\StyleSheets\\Indexing\\");
            xmlIndexBuilder.init("index");
            String string3 = string + this._language + File.separator + this._module + ".db";
            db.open(null, string3, null, 1, Db.DB_RDONLY, 420);
            Dbc dbc = db.cursor(null, 0);
            StringDbt stringDbt = new StringDbt();
            StringDbt stringDbt2 = new StringDbt();
            boolean bl = true;
            stringDbt.set_flags(Db.DB_DBT_MALLOC);
            stringDbt2.set_flags(Db.DB_DBT_MALLOC);
            while (-30990 != dbc.get((Dbt)stringDbt, (Dbt)stringDbt2, Db.DB_NEXT)) {
                try {
                    object4 = stringDbt.getString();
                    String string4 = stringDbt2.getFile();
                    object3 = stringDbt2.getHash();
                    object2 = (DocInfo)this._hashDocInfo.get(string4);
                    if (object2 == null) {
                        object2 = new DocInfo();
                        this._hashDocInfo.put(string4, object2);
                    }
                    if (!((String)object3).equals("")) {
                        ((DocInfo)object2).append((String)object4, (String)object3);
                    } else {
                        object = "vnd.sun.star.help://" + this._module + "/" + (String)object4 + "?Language=" + this._language;
                        ((DocInfo)object2).setURL((String)object);
                        ((DocInfo)object2).setId((String)object4);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!bl) continue;
                stringDbt.set_flags(Db.DB_DBT_REALLOC);
                stringDbt2.set_flags(Db.DB_DBT_REALLOC);
                bl = false;
            }
            dbc.close();
            db.close(0);
            System.out.println("Indexing...");
            object4 = this._hashDocInfo.elements();
            int n = 0;
            while (object4.hasMoreElements() && n < 100000000) {
                try {
                    int n2;
                    Object[] objectArray;
                    Object object5;
                    InputStreamReader inputStreamReader;
                    object3 = (DocInfo)object4.nextElement();
                    object2 = ((DocInfo)object3).getURL();
                    if (object2 == null) {
                        System.out.println("<----------------------------------->");
                        System.out.println("big error: found helptext without URL");
                        System.out.println("<----------------------------------->");
                        continue;
                    }
                    ++n;
                    HelpURLStreamHandlerFactory.setMode(null);
                    object = this.getSourceDocument((String)object2);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                    try {
                        inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, "UTF8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        inputStreamReader = new InputStreamReader(byteArrayInputStream);
                    }
                    InputSource inputSource = new InputSource(inputStreamReader);
                    inputSource.setEncoding("UTF8");
                    Document document = null;
                    try {
                        object5 = DocumentBuilderFactory.newInstance();
                        ((DocumentBuilderFactory)object5).setValidating(false);
                        objectArray = ((DocumentBuilderFactory)object5).newDocumentBuilder();
                        document = objectArray.parse(inputSource);
                    }
                    catch (Exception exception) {
                        if (document == null) {
                            System.err.println("Nullpointer");
                        }
                        System.err.println(exception.getMessage());
                    }
                    object5 = ((DocInfo)object3).getId();
                    if (object5 == null) {
                        System.out.println("Found tag without valid id");
                    } else {
                        this.addKeywords(document, ((DocInfo)object3).getId());
                    }
                    objectArray = ((DocInfo)object3).getAppendices().toArray();
                    for (n2 = 0; n2 < objectArray.length; ++n2) {
                        TagInfo tagInfo = (TagInfo)objectArray[n2];
                        Node node = this.extractHelptext(document, tagInfo.get_tag());
                        if (node == null) continue;
                        String string5 = this.dump(node);
                        this._hashHelptext.put(tagInfo.get_id(), string5);
                    }
                    HelpURLStreamHandlerFactory.setMode(object);
                    n2 = ((String)object2).indexOf(63);
                    if (n2 != -1) {
                        object2 = ((String)object2).substring(0, n2);
                    }
                    System.out.println((String)object2);
                    xmlIndexBuilder.indexDocument(new URL((String)object2), "");
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            }
            try {
                this.dumpHelptext();
                this._keywords.dump();
                xmlIndexBuilder.close();
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
        catch (DbRunRecoveryException dbRunRecoveryException) {
            System.out.println("Not able to create cursor: " + dbRunRecoveryException.getMessage());
            System.exit(1);
        }
        catch (DbException dbException) {
            System.out.println("Error initializing database");
            System.exit(1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("HelpAccess: " + fileNotFoundException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            System.out.println("any other exception" + exception.getMessage());
        }
    }

    private Node extractHelptext(Node node, String string) {
        Node node2;
        boolean bl = false;
        NodeIterator nodeIterator = new NodeIterator(node);
        while ((node2 = nodeIterator.next()) != null) {
            if (!bl && node2.getNodeName().equals("help:help-id") && ((Element)node2).getAttribute("value").equals(string)) {
                bl = true;
            }
            if (!bl || !node2.getNodeName().equals("help:help-text")) continue;
            return node2;
        }
        return null;
    }

    void dumpHelptext() {
        Enumeration enumeration = this._hashHelptext.keys();
        int n = 0;
        String[] stringArray = new String[this._hashHelptext.size()];
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        try {
            Db db = new Db(null, 0);
            String string = HelpDatabases.getInstallDirectory() + this._language + File.separator + this._module + ".ht";
            db.open(null, string, null, 1, Db.DB_CREATE, 420);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = (String)this._hashHelptext.get(stringArray[i]);
                StringDbt stringDbt = new StringDbt(stringArray[i]);
                StringDbt stringDbt2 = new StringDbt(string2);
                db.put(null, (Dbt)stringDbt, (Dbt)stringDbt2, 0);
            }
            db.close(0);
        }
        catch (Exception exception) {
            System.out.println("error writing keydata");
        }
    }

    private void addKeywords(Node node, String string) {
        Node node2;
        NodeIterator nodeIterator = new NodeIterator(node);
        while ((node2 = nodeIterator.next()) != null) {
            Element element;
            String string2;
            if (!node2.getNodeName().equals("help:key-word") || (string2 = (element = (Element)node2).getAttribute("embedded")) == null || !string2.equals("false")) continue;
            String string3 = element.getAttribute("value");
            String string4 = element.getAttribute("tag");
            if (string3.equals("") || string.equals("")) continue;
            this._keywords.insert(string3, string + "#" + string4);
        }
    }

    private String dump(Node node) {
        String string = new String();
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                string = string + this.dump(nodeList.item(i));
            }
        }
        if (node.getNodeType() != 1 && node.getNodeType() == 3) {
            return ((Text)node).toString();
        }
        return string;
    }

    byte[] getSourceDocument(String string) {
        if (this._stuff == null) {
            String string2 = HelpDatabases.getInstallDirectory() + "..\\StyleSheets\\Indexing\\ResEmb.xsl";
            this._stuff = new ParseStuff(string2);
            this._stuff.setParameter("Language", this._language);
            this._stuff.setParameter("Database", this._module);
        }
        return this._stuff.parse(string);
    }

    public static void main(String[] stringArray) throws Exception {
        System.setProperty("XMLSEARCH", HelpDatabases.getInstallDirectory());
        if (stringArray.length != 6) {
            System.out.println("Usage example: main -language de -module swriter -system WIN");
            System.exit(1);
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < 5; i += 2) {
            if (stringArray[i].trim().equals("-language")) {
                string = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].trim().equals("-module")) {
                string2 = stringArray[i + 1];
                continue;
            }
            if (!stringArray[i].trim().equals("-system")) continue;
            string3 = stringArray[i + 1];
        }
        if (string == null || string2 == null || string3 == null) {
            System.out.println("Usage example: main -language de -module swriter -system WIN");
            System.exit(1);
        } else {
            System.out.println(" Configuring for \"system\" = " + string3);
            System.out.println("                 \"module\" = " + string2);
            System.out.println("               \"language\" = " + string);
        }
        try {
            String string4 = HelpDatabases.getURLMode();
            HelpURLStreamHandlerFactory helpURLStreamHandlerFactory = new HelpURLStreamHandlerFactory(string4);
            URL.setURLStreamHandlerFactory(helpURLStreamHandlerFactory);
            HelpIndexer helpIndexer = new HelpIndexer(helpURLStreamHandlerFactory, string, string2, string3);
            helpIndexer.schnitzel();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static final class ParseStuff {
        private final XSLProcessor _processor = new XSLProcessorImpl();
        private final OutputMethodHandlerImpl _output;

        private ParseStuff() {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            try {
                this._processor.setParser(sAXParserFactory.newSAXParser().getParser());
            }
            catch (Exception exception) {
                System.err.println("<!-- NO HELP AVAILABLE: no parser found -->");
                System.exit(1);
            }
            this._output = new OutputMethodHandlerImpl(this._processor);
            this._processor.setOutputMethodHandler((OutputMethodHandler)this._output);
        }

        public ParseStuff(URL uRL) {
            this();
            try {
                this._processor.loadStylesheet(new InputSource(uRL.toExternalForm()));
            }
            catch (SAXException sAXException) {
                System.err.println("<!-- Syntactic error in stylesheet -->");
                System.err.println(sAXException.getMessage());
                System.exit(1);
            }
            catch (IOException iOException) {
                System.err.println("<!-- Style sheet not found -->");
                System.err.println(iOException.getMessage());
                System.exit(1);
            }
        }

        public ParseStuff(String string) {
            this();
            try {
                this._processor.loadStylesheet(new InputSource(new FileInputStream(string)));
            }
            catch (SAXException sAXException) {
                System.err.println("<!-- Syntactic error in stylesheet -->");
                System.exit(1);
            }
            catch (IOException iOException) {
                System.err.println("<!-- Style sheet not found: -->");
                System.err.println(iOException.getMessage());
                System.exit(1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] parse(String string) {
            InputSource inputSource = new InputSource(string);
            inputSource.setEncoding("UTF-8");
            HelpOutputStream helpOutputStream = new HelpOutputStream();
            try {
                HelpProvider.ProviderDestination providerDestination = new HelpProvider.ProviderDestination(helpOutputStream, "UTF-8");
                ParseStuff parseStuff = this;
                synchronized (parseStuff) {
                    this._output.setDestination((Destination)providerDestination);
                    this._processor.parse(inputSource);
                    helpOutputStream.flush();
                }
            }
            catch (SAXParseException sAXParseException) {
                sAXParseException.printStackTrace();
                System.err.println("url: " + string);
                System.err.println(sAXParseException.getMessage());
                System.err.println("Line: " + sAXParseException.getLineNumber() + " Column: " + sAXParseException.getColumnNumber() + " public ID: " + sAXParseException.getPublicId() + " System ID: " + sAXParseException.getSystemId());
                System.exit(1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("url: " + string);
                System.err.println(exception.getMessage());
                System.exit(1);
            }
            return helpOutputStream.getBigBuffer();
        }

        public void setParameter(String string, Object object) {
            this._processor.setParameter(string, object);
        }
    }

    public final class Keywords {
        private Hashtable _hash = new Hashtable();

        public void insert(String string, String string2) {
            Data data = (Data)this._hash.get(string);
            if (data == null) {
                data = new Data();
                this._hash.put(string, data);
            }
            data.append(string2);
        }

        void dump() {
            Enumeration enumeration = this._hash.keys();
            int n = 0;
            String[] stringArray = new String[this._hash.size()];
            while (enumeration.hasMoreElements()) {
                stringArray[n++] = (String)enumeration.nextElement();
            }
            try {
                Db db = new Db(null, 0);
                String string = HelpDatabases.getInstallDirectory() + HelpIndexer.this._language + File.separator + HelpIndexer.this._module + ".key";
                db.open(null, string, null, 1, Db.DB_CREATE, 420);
                for (int i = 0; i < stringArray.length; ++i) {
                    Data data = (Data)this._hash.get(stringArray[i]);
                    StringDbt stringDbt = new StringDbt(stringArray[i]);
                    StringDbt stringDbt2 = new StringDbt(data.getString());
                    db.put(null, (Dbt)stringDbt, (Dbt)stringDbt2, 0);
                }
                db.close(0);
            }
            catch (Exception exception) {
                System.out.println("error writing keydata");
            }
        }

        class Data {
            int pos = 0;
            String[] _idList = new String[5];

            Data() {
            }

            void append(String string) {
                if (this.pos == this._idList.length) {
                    String[] stringArray = this._idList;
                    this._idList = new String[this.pos + 5];
                    for (int i = 0; i < stringArray.length; ++i) {
                        this._idList[i] = stringArray[i];
                    }
                    stringArray = null;
                }
                this._idList[this.pos++] = string;
            }

            int getLength() {
                return this.pos;
            }

            String getString() {
                String string = new String();
                for (int i = 0; i < this.pos; ++i) {
                    string = string + this._idList[i] + ";";
                }
                return string;
            }
        }
    }

    public final class NodeIterator {
        private Stack stack = new Stack();

        public NodeIterator(Node node) {
            this.stack.push(new StackElement(node));
        }

        void change() {
            ((StackElement)this.stack.peek())._isDone = true;
            NodeList nodeList = ((StackElement)this.stack.peek())._node.getChildNodes();
            for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                this.stack.push(new StackElement(nodeList.item(i)));
            }
        }

        public Node next() {
            if (this.stack.empty()) {
                return null;
            }
            while (!((StackElement)this.stack.peek())._isDone) {
                this.change();
            }
            return ((StackElement)this.stack.pop())._node;
        }

        private final class StackElement {
            public boolean _isDone = false;
            public Node _node;

            StackElement(Node node) {
                this._node = node;
            }
        }
    }

    private final class DocInfo {
        private String _url = null;
        private String _id = null;
        private ArrayList _helptags = new ArrayList();

        private DocInfo() {
        }

        public void append(String string, String string2) {
            this._helptags.add(new TagInfo(string, string2));
        }

        public String getURL() {
            return this._url;
        }

        public void setURL(String string) {
            this._url = string;
        }

        public void setId(String string) {
            this._id = string;
        }

        public String getId() {
            return this._id;
        }

        public ArrayList getAppendices() {
            return this._helptags;
        }
    }

    private final class TagInfo {
        String _tag;
        String _id;

        public TagInfo(String string, String string2) {
            this._tag = string2;
            this._id = string;
        }

        public String get_tag() {
            return this._tag;
        }

        public String get_id() {
            return this._id;
        }
    }
}

