/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.filter.config.tools.utils;

import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLHelper {
    public static final String XMLTYPE_INTEGER = "xs:int";
    public static final String XMLTYPE_BOOLEAN = "xs:boolean";
    public static final String XMLTYPE_STRING = "xs:string";
    public static final String XMLTYPE_STRINGLIST = "oor:string-list";
    public static final String XMLATTRIB_OOR_NAME = "oor:name";
    public static final String XMLATTRIB_OOR_TYPE = "oor:type";
    public static final String XMLATTRIB_OOR_SEPARATOR = "oor:separator";
    public static final String XMLATTRIB_OOR_LOCALIZED = "oor:localized";
    public static final String XMLATTRIB_OOR_OP = "oor:op";
    public static final String XMLATTRIB_OP_REPLACE = "replace";
    public static final String XMLATTRIB_XML_LANG = "xml:lang";
    public static final String XMLTAG_VALUE = "value";
    public static final String XMLTAG_PROP = "prop";
    public static final String XMLTAG_NODE = "node";
    private static final String[] DELIMS = new String[]{" ", ",", ";", ".", ":", "-", "_", "#", "'", "+", "*", "~", "=", "?"};
    private static final int DEFAULT_SEPARATOR = 0;

    public static HashMap convertNodeToPropSet(Node node) throws Exception {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Vector vector = XMLHelper.extractChildNodesByTagName(node, XMLTAG_PROP);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)enumeration.nextElement();
            String string = XMLHelper.extractNodeAttribByName(node2, XMLATTRIB_OOR_NAME);
            if (string == null) {
                throw new IOException("unsupported format: could not extract child node name");
            }
            String string2 = XMLHelper.extractNodeAttribByName(node2, XMLATTRIB_OOR_TYPE);
            if (string2 == null && (string2 = XMLHelper.getTypeForTag(string)) == null) {
                throw new IOException("unsupported format: could not extract child node type");
            }
            Vector vector2 = XMLHelper.extractChildNodesByTagName(node2, XMLTAG_VALUE);
            Enumeration enumeration2 = vector2.elements();
            int n = 0;
            Cloneable cloneable = null;
            while (enumeration2.hasMoreElements()) {
                Object object;
                String string3;
                Node node3 = (Node)enumeration2.nextElement();
                String string4 = XMLHelper.extractNodeAttribByName(node3, XMLATTRIB_XML_LANG);
                boolean bl = string4 != null;
                ++n;
                if (string2.equals(XMLTYPE_INTEGER)) {
                    if (!bl && n > 1) {
                        throw new IOException("unsupported format: more then one value for non localized but atomic type detected");
                    }
                    string3 = ((CharacterData)node3.getFirstChild()).getData();
                    cloneable = new Integer(string3);
                } else if (string2.equals(XMLTYPE_BOOLEAN)) {
                    if (!bl && n > 1) {
                        throw new IOException("unsupported format: more then one value for non localized but atomic type detected");
                    }
                    string3 = ((CharacterData)node3.getFirstChild()).getData();
                    cloneable = new Boolean(string3);
                } else if (string2.equals(XMLTYPE_STRING)) {
                    if (!bl && n > 1) {
                        throw new IOException("unsupported format: more then one value for non localized but atomic type detected");
                    }
                    string3 = ((CharacterData)node3.getFirstChild()).getData();
                    object = null;
                    if (bl) {
                        if (cloneable == null) {
                            cloneable = new HashMap();
                        }
                        object = cloneable;
                        ((HashMap)object).put(string4, string3);
                    } else {
                        cloneable = string3;
                    }
                } else if (string2.equals(XMLTYPE_STRINGLIST)) {
                    if (!bl && n > 1) {
                        throw new IOException("unsupported format: more then one value for non localized but atomic type detected");
                    }
                    string3 = XMLHelper.extractNodeAttribByName(node2, XMLATTRIB_OOR_SEPARATOR);
                    if (string3 == null) {
                        string3 = " ";
                    }
                    object = ((CharacterData)node3.getFirstChild()).getData();
                    object = ((String)object).replace('\t', ' ');
                    object = ((String)object).replace('\n', ' ');
                    StringTokenizer stringTokenizer = new StringTokenizer((String)object, string3);
                    Vector<String> vector3 = new Vector<String>();
                    while (stringTokenizer.hasMoreTokens()) {
                        String string5 = stringTokenizer.nextToken();
                        string5.trim();
                        if (string5.length() < 1) continue;
                        vector3.add(string5);
                    }
                    cloneable = vector3;
                }
                hashMap.put(string, (Integer)((Object)cloneable));
            }
        }
        return hashMap;
    }

    private static String getTypeForTag(String string) {
        String string2 = null;
        if (string.equals("Data") || string.equals("Name") || string.equals("UIName") || string.equals("MediaType") || string.equals("ClipboardFormat") || string.equals("PreferredFilter") || string.equals("DetectService") || string.equals("FrameLoader") || string.equals("ContentHandler") || string.equals("DocumentService") || string.equals("FilterService") || string.equals("TemplateName") || string.equals("Type") || string.equals("UIComponent")) {
            string2 = XMLTYPE_STRING;
        } else if (string.equals("Preferred") || string.equals("Installed")) {
            string2 = XMLTYPE_BOOLEAN;
        } else if (string.equals("UIOrder") || string.equals("DocumentIconID") || string.equals("FileFormatVersion")) {
            string2 = XMLTYPE_INTEGER;
        } else if (string.equals("URLPattern") || string.equals("Extensions") || string.equals("UserData") || string.equals("Flags") || string.equals("Types")) {
            string2 = XMLTYPE_STRINGLIST;
        }
        if (string2 == null) {
            System.err.println("getTypeForTag(" + string + ") = " + string2);
        }
        return string2;
    }

    public static String convertPropSetToXML(HashMap hashMap, int n) throws Exception {
        StringBuffer stringBuffer = new StringBuffer(256);
        for (String string : hashMap.keySet()) {
            Serializable serializable;
            Object v = hashMap.get(string);
            string = XMLHelper.encodeHTMLSigns(string);
            if (v instanceof Integer || v instanceof Boolean || v instanceof String) {
                stringBuffer.append(XMLHelper.convertSimpleObjectToXML(string, v, n));
                continue;
            }
            if (v instanceof Vector) {
                serializable = (Vector)v;
                stringBuffer.append(XMLHelper.convertListToXML(string, (Vector)serializable, n));
                continue;
            }
            if (v instanceof HashMap) {
                serializable = (HashMap)v;
                stringBuffer.append(XMLHelper.convertLocalizedValueToXML(string, (HashMap)serializable, n));
                continue;
            }
            serializable = new StringBuffer(256);
            ((StringBuffer)serializable).append("unsupported object type detected.");
            ((StringBuffer)serializable).append("\ttype ?  : \"" + string + "\" = " + v);
            ((StringBuffer)serializable).append("\tprop set: \"" + hashMap);
            throw new Exception(((StringBuffer)serializable).toString());
        }
        return stringBuffer.toString();
    }

    public static String encodeHTMLSigns(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer(1000);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (c == '&') {
                stringBuffer2.append("&amp;");
                continue;
            }
            stringBuffer2.append(c);
        }
        String string2 = stringBuffer2.toString();
        if (!string2.equals(string)) {
            System.out.println("encode \"" + string + "\" => \"" + string2 + "\"");
        }
        return string2;
    }

    private static String convertSimpleObjectToXML(String string, Object object, int n) throws Exception {
        StringBuffer stringBuffer = new StringBuffer(256);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\t");
        }
        if (object instanceof Integer) {
            stringBuffer.append("<prop oor:name=\"" + string + "\">");
            stringBuffer.append("<value>" + object.toString() + "</value>");
            stringBuffer.append("</prop>\n");
        } else if (object instanceof Boolean) {
            stringBuffer.append("<prop oor:name=\"" + string + "\">");
            stringBuffer.append("<value>" + object.toString() + "</value>");
            stringBuffer.append("</prop>\n");
        } else if (object instanceof String) {
            stringBuffer.append("<prop oor:name=\"" + string + "\"");
            String string2 = (String)object;
            string2 = XMLHelper.encodeHTMLSigns(string2);
            if (string2.length() < 1) {
                stringBuffer.append("/>\n");
            } else {
                stringBuffer.append("><value>" + string2 + "</value>");
                stringBuffer.append("</prop>\n");
            }
        } else {
            System.err.println("name  = " + string);
            System.err.println("value = " + object);
            throw new Exception("not an atomic type.");
        }
        return stringBuffer.toString();
    }

    private static String convertListToXML(String string, Vector vector, int n) throws Exception {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(256);
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append("\t");
        }
        n2 = vector.size();
        if (n2 < 1) {
            stringBuffer.append("<prop oor:name=\"" + string + "\"/>\n");
            return stringBuffer.toString();
        }
        int n3 = 0;
        StringBuffer stringBuffer2 = new StringBuffer(256);
        block1: for (int i = 0; i < n2; ++i) {
            Object e = vector.get(i);
            if (!(e instanceof String)) {
                throw new Exception("Current implementation supports string-list only!");
            }
            String string2 = (String)e;
            string2 = XMLHelper.encodeHTMLSigns(string2);
            stringBuffer2.append(string2);
            if (i < n2 - 1) {
                stringBuffer2.append("\n");
            }
            while (true) {
                if (n3 >= DELIMS.length) {
                    throw new Exception("No valid separator found for a string list item.");
                }
                if (string2.length() < 1 && DELIMS[n3].equals(" ")) {
                    ++n3;
                    continue;
                }
                if (string2.indexOf(DELIMS[n3]) == -1) continue block1;
                ++n3;
            }
        }
        System.out.println("TODO: must be adapted to java 1.3 :-(");
        System.exit(-1);
        String string3 = null;
        stringBuffer.append("<prop oor:name=\"" + string + "\">");
        if (n3 == 0) {
            stringBuffer.append("<value>");
        } else {
            stringBuffer.append("<value oor:separator=\"" + DELIMS[n3] + "\">");
        }
        stringBuffer.append(string3);
        stringBuffer.append("</value>");
        stringBuffer.append("</prop>\n");
        return stringBuffer.toString();
    }

    private static String convertLocalizedValueToXML(String string, HashMap hashMap, int n) throws Exception {
        StringBuffer stringBuffer = new StringBuffer(256);
        int n2 = hashMap.size();
        if (n2 < 1) {
            throw new Exception("Cant detect type of localized values. Because the given list is empty.");
        }
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\t");
        }
        ++n;
        stringBuffer.append("<prop oor:name=\"" + string + "\">\n");
        for (String string2 : hashMap.keySet()) {
            Object v = hashMap.get(string2);
            String string3 = v.toString();
            String string4 = XMLHelper.encodeHTMLSigns(string3);
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("\t");
            }
            stringBuffer.append("<value xml:lang=\"" + string2 + "\">" + string4 + "</value>\n");
        }
        --n;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\t");
        }
        stringBuffer.append("</prop>\n");
        return stringBuffer.toString();
    }

    public static String extractNodeAttribByName(Node node, String string) throws Exception {
        if (node.getNodeType() != 1) {
            return null;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (!attr.getName().equals(string)) continue;
            String string2 = attr.getValue();
            return string2;
        }
        return null;
    }

    public static Vector extractChildNodesByTagName(Node node, String string) {
        Vector vector = XMLHelper.extractChildNodesByType(node, (short)1);
        Vector<Node> vector2 = new Vector<Node>(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)enumeration.nextElement();
            if (!node2.getNodeName().equals(string)) continue;
            vector2.add(node2);
        }
        vector2.trimToSize();
        return vector2;
    }

    public static Vector extractChildNodesByType(Node node, short s) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        Vector<Node> vector = new Vector<Node>(n);
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != s) continue;
            vector.add(node2);
        }
        vector.trimToSize();
        return vector;
    }

    public static String generateHeader(String string, String string2, String string3, String string4, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(256);
        if (bl) {
            stringBuffer.append("<?xml version=\"");
            stringBuffer.append(string);
            stringBuffer.append("\" encoding=\"");
            stringBuffer.append(string2);
            stringBuffer.append("\"?>\n");
            stringBuffer.append("<oor:component-data oor:package=\"");
            stringBuffer.append(string3);
            stringBuffer.append("\" oor:name=\"");
            stringBuffer.append(string4);
            stringBuffer.append("\" xmlns:install=\"http://openoffice.org/2004/installation\"");
            stringBuffer.append(" xmlns:oor=\"http://openoffice.org/2001/registry\"");
            stringBuffer.append(" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"");
            stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n");
        } else {
            stringBuffer.append("<?xml version=\"");
            stringBuffer.append(string);
            stringBuffer.append("\" encoding=\"");
            stringBuffer.append(string2);
            stringBuffer.append("\"?>\n<!DOCTYPE oor:component-data SYSTEM \"../../../../component-update.dtd\">\n");
            stringBuffer.append("<oor:component-data xmlns:oor=\"http://openoffice.org/2001/registry\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" oor:package=\"");
            stringBuffer.append(string3);
            stringBuffer.append("\" oor:name=\"");
            stringBuffer.append(string4);
            stringBuffer.append("\">\n");
        }
        return stringBuffer.toString();
    }

    public static String generateFooter() {
        return "</oor:component-data>\n";
    }
}

