/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Workbook;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula.FormulaCompiler;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula.FormulaParser;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula.FormulaParsingException;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula.Token;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula.TokenDecoder;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula.TokenEncoder;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula.UnsupportedFunctionException;

public class FormulaHelper {
    private static FormulaParser parser = new FormulaParser();
    private static FormulaCompiler compiler = new FormulaCompiler();
    private static TokenEncoder encoder = new TokenEncoder();
    private static TokenDecoder decoder = new TokenDecoder();
    private boolean rangeType = false;
    private boolean expressionType = false;

    public void setWorkbook(Workbook workbook) {
        encoder.setWorkbook(workbook);
        decoder.setWorkbook(workbook);
        parser.setWorkbook(workbook);
    }

    public byte[] convertCalcToPXL(String string) throws UnsupportedFunctionException, FormulaParsingException {
        Vector vector = parser.parse(string);
        Vector vector2 = compiler.infix2RPN(vector);
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                Token token = (Token)enumeration.nextElement();
                byteArrayOutputStream.write(encoder.getByte(token));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String convertPXLToCalc(byte[] byArray) {
        Vector vector = decoder.getTokenVector(byArray);
        Vector vector2 = compiler.RPN2Infix(vector);
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Token token = (Token)enumeration.nextElement();
            stringBuffer.append(token.toString());
            if (token.isOperand()) continue;
            this.expressionType = true;
        }
        if (!this.expressionType) {
            this.rangeType = true;
        }
        return "=" + stringBuffer.toString();
    }

    public boolean isRangeType() {
        return this.rangeType;
    }

    public boolean isExpressionType() {
        return this.expressionType;
    }
}

