/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.InvocationTargetException;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.io.SafeException;

public class NbObjectInputStream
extends ObjectInputStream {
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public NbObjectInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        try {
            this.enableResolveObject(true);
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.toString());
        }
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        ClassLoader classLoader = NbObjectInputStream.getNBClassLoader();
        try {
            return Class.forName(objectStreamClass.getName(), false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string = "Offending classloader: " + classLoader;
            ErrorManager.getDefault().annotate(classNotFoundException, 1, string, null, null, null);
            throw classNotFoundException;
        }
    }

    private static ClassLoader getNBClassLoader() {
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = NbObjectInputStream.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
        return classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        String string;
        ObjectStreamClass objectStreamClass = super.readClassDescriptor();
        String string2 = objectStreamClass.getName();
        if (string2 == (string = Utilities.translate(string2))) {
            return objectStreamClass;
        }
        ClassLoader classLoader = NbObjectInputStream.getNBClassLoader();
        Class<?> clazz = Class.forName(string, false, classLoader);
        ObjectStreamClass objectStreamClass2 = ObjectStreamClass.lookup(clazz);
        return objectStreamClass2;
    }

    public static Object readSafely(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        byte[] byArray = new byte[n];
        objectInput.readFully(byArray, 0, n);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            NbObjectInputStream nbObjectInputStream = new NbObjectInputStream(byteArrayInputStream);
            Object object = nbObjectInputStream.readObject();
            byteArrayInputStream.close();
            return object;
        }
        catch (Exception exception) {
            throw new SafeException(exception);
        }
        catch (LinkageError linkageError) {
            throw new SafeException(new InvocationTargetException(linkageError));
        }
    }

    public static void skipSafely(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        objectInput.skip(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

