/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.netbeans.nbbuild.Issue;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

final class IssuezillaXMLHandler
extends HandlerBase {
    private static final String DTD_VERSION = "$Revision: 1.5 $";
    private static final String DTD_VERSION_NAME = "dtd_version";
    private static final String ISSUE_STATUS = "issue_status";
    private static final String RESOLUTION = "resolution";
    private static final String PRIORITY = "priority";
    private static final String ISSUE = "issue";
    private static final String ISSUEZILLA = "issuezilla";
    private static final String LONG_DESC = "long_desc";
    private static final String WHO = "who";
    private static final String ISSUE_WHEN = "issue_when";
    private static final String THETEXT = "thetext";
    private static final HashSet tagsInIssue = new HashSet();
    private static final List tagsInLongDesc;
    private List bugs;
    private Map bug;
    private Vector openedTags;
    private StringBuffer buffer;
    private StringBuffer longDescBuffer;
    private List longDescriptionList;
    private Issue.Description longDesc;
    private SimpleDateFormat dateFormat;
    private SimpleDateFormat dateFormat2;

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        this.bugs = new ArrayList();
        this.openedTags = new Vector();
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        this.openedTags.addElement(string);
        if (string.equals(ISSUEZILLA)) {
            this.checkDTDVersion(attributeList);
        } else if (string.equals(ISSUE)) {
            this.bug = new HashMap();
            this.bugs.add(this.bug);
            this.longDescriptionList = new ArrayList();
            this.bug.put("long_desc_list", this.longDescriptionList);
            this.bug.put("cc", new ArrayList());
            this.bug.put("dependson", new ArrayList());
            this.bug.put("blocks", new ArrayList());
            this.bug.put("creation_ts", new Date(0L));
            this.dealIssueAttributes(attributeList);
        } else if (tagsInIssue.contains(string)) {
            this.buffer = new StringBuffer();
        } else if (tagsInLongDesc.contains(string)) {
            this.longDescBuffer = new StringBuffer();
        } else if (string.equals(LONG_DESC)) {
            this.longDesc = new Issue.Description();
            this.longDescriptionList.add(this.longDesc);
        }
    }

    public void endElement(String string) throws SAXException {
        if (!this.currentTag().equals(string)) {
            throw new SAXException("An error while parsing the XML file near the closing " + string + " tag");
        }
        this.openedTags.remove(this.openedTags.size() - 1);
        if (!string.equals(ISSUEZILLA)) {
            if (tagsInIssue.contains(string)) {
                Object v = this.bug.get(string);
                if (v instanceof List) {
                    ((List)v).add(this.buffer.toString());
                } else if (v instanceof Date) {
                    this.bug.put(string, this.toDate(this.buffer.toString()));
                } else {
                    this.bug.put(string, this.buffer.toString());
                }
                this.buffer = null;
            } else if (!string.equalsIgnoreCase(LONG_DESC) && tagsInLongDesc.contains(string)) {
                String string2 = this.longDescBuffer.toString();
                if (string.equals(ISSUE_WHEN)) {
                    this.longDesc.setIssueWhen(this.toDate(string2));
                } else {
                    this.longDesc.setAtribute(string, string2);
                }
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (!string.equals("")) {
            if (tagsInLongDesc.contains(this.currentTag())) {
                this.longDescBuffer.append(string);
            } else if (this.buffer != null) {
                this.buffer.append(string);
            }
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    private String currentTag() {
        if (this.openedTags.size() == 0) {
            return null;
        }
        return (String)this.openedTags.lastElement();
    }

    public List getBugList() {
        return this.bugs;
    }

    private void dealIssueAttributes(AttributeList attributeList) throws SAXException {
        String string = attributeList.getValue(PRIORITY);
        String string2 = attributeList.getValue(ISSUE_STATUS);
        String string3 = attributeList.getValue(RESOLUTION);
        if (string == null) {
            string = "P0";
        }
        this.bug.put(PRIORITY, string);
        this.bug.put(ISSUE_STATUS, string2);
        if (string3 != null) {
            this.bug.put(RESOLUTION, string3);
        }
    }

    private void checkDTDVersion(AttributeList attributeList) throws SAXException {
        String string = attributeList.getValue(DTD_VERSION_NAME);
        if (string == null || !string.equals(DTD_VERSION)) {
            // empty if block
        }
    }

    public Date toDate(String string) {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("yyyy-mm-dd hh:mm:ss");
        }
        if (this.dateFormat2 == null) {
            this.dateFormat2 = new SimpleDateFormat("yyyy-mm-dd hh:mm");
        }
        try {
            return this.dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            try {
                return this.dateFormat2.parse(string);
            }
            catch (ParseException parseException2) {
                parseException2.printStackTrace();
                return null;
            }
        }
    }

    static {
        tagsInIssue.add("issue_id");
        tagsInIssue.add("component");
        tagsInIssue.add("version");
        tagsInIssue.add("rep_platform");
        tagsInIssue.add("assigned_to");
        tagsInIssue.add("delta_ts");
        tagsInIssue.add("subcomponent");
        tagsInIssue.add("reporter");
        tagsInIssue.add("target_milestone");
        tagsInIssue.add("issue_type");
        tagsInIssue.add("creation_ts");
        tagsInIssue.add("qa_contact");
        tagsInIssue.add("status_whiteboard");
        tagsInIssue.add("op_sys");
        tagsInIssue.add("short_desc");
        tagsInIssue.add("blocks");
        tagsInIssue.add("cc");
        tagsInIssue.add("dependson");
        tagsInIssue.add("votes");
        tagsInIssue.add("keywords");
        tagsInLongDesc = new ArrayList();
        tagsInLongDesc.add(WHO);
        tagsInLongDesc.add(ISSUE_WHEN);
        tagsInLongDesc.add(THETEXT);
    }
}

