/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.qe;

import com.sun.xmlsearch.db.BtreeDict;
import com.sun.xmlsearch.db.BtreeDictParameters;
import com.sun.xmlsearch.db.Schema;
import com.sun.xmlsearch.qe.QueryHit;
import com.sun.xmlsearch.util.ByteArrayDecompressor;
import com.sun.xmlsearch.util.ConceptList;
import com.sun.xmlsearch.util.IndexAccessor;
import com.sun.xmlsearch.util.IntegerArray;
import com.sun.xmlsearch.util.NonnegativeIntegerGenerator;
import com.sun.xmlsearch.util.StreamDecompressor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

class SearchEnvironment
extends IndexAccessor {
    private IntegerArray _concepts;
    private IntegerArray _offsets;
    private byte[] _allLists;
    private IntegerArray _concepts3;
    private IntegerArray _offsets3;
    private byte[] _allChildren;
    private IntegerArray _documents;
    private IntegerArray _offsets2;
    private IntegerArray _titles;
    private byte[] _positions = new byte[this._positionsCacheSize];
    private int _currentBatchOffset = 0;
    private int _maxDocNumberInCache = -1;
    private int _positionsCacheSize = 0x200000;
    private RandomAccessFile _positionsFile = null;
    private boolean _allInCache = false;
    private ByteArrayDecompressor _compr;
    private BtreeDict _tmap;
    private static boolean debugFlag = false;

    public SearchEnvironment(String string) throws Exception {
        super(string);
        this.readFromDB();
        this._compr = new ByteArrayDecompressor(null, 0);
    }

    private void readMicroindexes(int n) throws IOException {
        this._currentBatchOffset = this._offsets2.at(n);
        int n2 = this._currentBatchOffset + this._positionsCacheSize;
        int n3 = 0;
        int n4 = n;
        int n5 = 0;
        do {
            if (++n4 == this._offsets2.cardinality()) {
                n5 = (int)this._positionsFile.length();
                continue;
            }
            if (this._offsets2.at(n4) <= n2) continue;
            n5 = this._offsets2.at(n4);
        } while (n5 == 0);
        if (n5 > n2) {
            n3 = this._offsets2.at(n4 - 1);
            this._maxDocNumberInCache = n4 - 2;
        } else {
            n3 = n5;
            this._maxDocNumberInCache = n4 - 1;
        }
        if (this._maxDocNumberInCache < n) {
            this._positionsCacheSize = n5 - this._currentBatchOffset;
            System.out.println("expanding cache to " + this._positionsCacheSize);
            this._positions = new byte[this._positionsCacheSize];
            this.readMicroindexes(n);
            return;
        }
        this._positionsFile.seek(this._currentBatchOffset);
        this._positionsFile.read(this._positions, 0, n3 - this._currentBatchOffset);
    }

    public void reset() {
        this._maxDocNumberInCache = this._allInCache ? this._offsets2.cardinality() - 1 : -1;
    }

    public byte[] getPositions(int n) throws IOException {
        if (n > this._maxDocNumberInCache) {
            this.readMicroindexes(n);
        }
        return this._positions;
    }

    public int getDocumentIndex(int n) {
        return this._offsets2.at(n) - this._currentBatchOffset;
    }

    public void close() throws IOException {
        this._positionsFile.close();
    }

    public int fetch(String string) throws Exception {
        return this._tmap.fetch(string);
    }

    public String fetch(int n) throws Exception {
        return this._tmap.fetch(n);
    }

    public String hitToString(QueryHit queryHit) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(queryHit.getScore());
        stringBuffer.append(" ");
        stringBuffer.append(this.fetch(this._documents.at(queryHit.getDocument())));
        stringBuffer.append(" [");
        stringBuffer.append(queryHit.getBegin());
        stringBuffer.append(", ");
        stringBuffer.append(queryHit.getEnd());
        stringBuffer.append("], {");
        int[] nArray = queryHit.getArray();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] > 0) {
                stringBuffer.append(this.fetch(nArray[i]));
            } else {
                stringBuffer.append("--");
            }
            if (i >= nArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public boolean occursInText(int n) {
        return this._concepts.binarySearch(n) >= 0;
    }

    public NonnegativeIntegerGenerator getDocumentIterator(int n) {
        int n2 = this._concepts.binarySearch(n);
        if (n2 >= 0) {
            return new ConceptList(this._allLists, this._offsets.at(n2));
        }
        return null;
    }

    public NonnegativeIntegerGenerator getChildIterator(int n) {
        int n2 = this._concepts3.binarySearch(n);
        if (n2 >= 0) {
            return new ConceptList(this._allChildren, this._offsets3.at(n2));
        }
        return null;
    }

    public void getChildren(int n, IntegerArray integerArray) throws Exception {
        int n2 = this._concepts3.binarySearch(n);
        if (n2 >= 0) {
            int n3 = this._offsets3.at(n2);
            this._compr.initReading(this._allChildren, n3 + 1);
            this._compr.ascDecode(this._allChildren[n3], integerArray);
        }
    }

    public int getConceptLength(int n) throws Exception {
        return this._tmap.fetch(n).length();
    }

    private void readChildrenData() throws Exception {
        try {
            InputStream inputStream = this.getInputStream("CHILDREN.TAB");
            int n = inputStream.read();
            this._concepts3 = new IntegerArray(4096);
            StreamDecompressor streamDecompressor = new StreamDecompressor(inputStream);
            streamDecompressor.ascDecode(n, this._concepts3);
            int n2 = inputStream.read();
            this._offsets3 = new IntegerArray(this._concepts3.cardinality() + 1);
            this._offsets3.add(0);
            StreamDecompressor streamDecompressor2 = new StreamDecompressor(inputStream);
            streamDecompressor2.ascDecode(n2, this._offsets3);
            inputStream.close();
            this._allChildren = this.readByteArray("CHILDREN");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this._concepts3 = new IntegerArray(1);
        }
        catch (IOException iOException) {
            this._concepts3 = new IntegerArray(1);
        }
    }

    private void readFromDB() throws Exception {
        Schema schema = new Schema(this, false);
        BtreeDictParameters btreeDictParameters = new BtreeDictParameters(schema, "DICTIONARY");
        btreeDictParameters.readState();
        this._tmap = new BtreeDict(btreeDictParameters);
        this.readChildrenData();
        InputStream inputStream = this.getInputStream("DOCS.TAB");
        int n = inputStream.read();
        this._concepts = new IntegerArray(4096);
        StreamDecompressor streamDecompressor = new StreamDecompressor(inputStream);
        streamDecompressor.ascDecode(n, this._concepts);
        int n2 = inputStream.read();
        this._offsets = new IntegerArray(this._concepts.cardinality() + 1);
        this._offsets.add(0);
        StreamDecompressor streamDecompressor2 = new StreamDecompressor(inputStream);
        streamDecompressor2.ascDecode(n2, this._offsets);
        inputStream.close();
        this._allLists = this.readByteArray("DOCS");
        inputStream = this.getInputStream("OFFSETS");
        n = inputStream.read();
        this._documents = new IntegerArray(4096);
        streamDecompressor = new StreamDecompressor(inputStream);
        streamDecompressor.ascDecode(n, this._documents);
        n2 = inputStream.read();
        this._offsets2 = new IntegerArray(this._documents.cardinality() + 1);
        streamDecompressor2 = new StreamDecompressor(inputStream);
        streamDecompressor2.ascDecode(n2, this._offsets2);
        int n3 = inputStream.read();
        this._titles = new IntegerArray(this._documents.cardinality());
        StreamDecompressor streamDecompressor3 = new StreamDecompressor(inputStream);
        streamDecompressor3.decode(n3, this._titles);
        inputStream.close();
        this._positionsFile = this.getRAF("POSITIONS", false);
        if (this._positionsFile.length() <= (long)this._positionsCacheSize) {
            this._allInCache = true;
            this.reset();
            this._positionsFile.read(this._positions);
            System.out.println("POS fits in cache");
        }
    }

    private static void debug(String string) {
        if (debugFlag) {
            System.out.println("SearchEnvironment: " + string);
        }
    }
}

