/*
 * Decompiled with CFR 0.152.
 */
package helper;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import lib.TestParameters;

public class CfgParser {
    protected boolean debug = false;
    protected String iniFile = "";

    public CfgParser(String string) {
        if (string != null) {
            this.iniFile = string;
        }
    }

    public void getIniParameters(TestParameters testParameters) {
        String string;
        Object object;
        Object object2;
        this.debug = testParameters.DebugIsActive;
        Properties properties = null;
        if (this.iniFile.equals("")) {
            properties = this.getProperties(this.getDefaultFileName(true));
            if (properties == null) {
                properties = this.getProperties(this.getDefaultFileName(false));
            }
        } else {
            properties = this.getProperties(this.iniFile);
        }
        if (properties != null) {
            object2 = properties.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                string = properties.getProperty((String)object);
                if (string instanceof String) {
                    string = string.trim();
                }
                testParameters.put(((String)object).trim(), string);
                if (!((String)object).equals("TestDocumentPath")) continue;
                System.setProperty("DOCPTH", string);
                testParameters.put("DOCPTH", string);
            }
        }
        if ((object2 = (String)testParameters.get("OperatingSystem")) != null) {
            object = testParameters.keys();
            while (object.hasMoreElements()) {
                string = (String)object.nextElement();
                Object object3 = testParameters.get(string);
                if (!string.startsWith((String)object2)) continue;
                String string2 = string.substring(((String)object2).length() + 1);
                testParameters.remove(string);
                testParameters.put(string2, object3);
            }
        }
    }

    protected Properties getProperties(String string) {
        Properties properties = new Properties();
        if (this.debug) {
            System.out.println("Looking for " + string);
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            System.out.println("Parsing properties from " + string);
            fileInputStream.close();
        }
        catch (Exception exception) {
            try {
                URL uRL = this.getClass().getResource("/" + string);
                if (uRL != null) {
                    System.out.println("Parsing properties from " + string);
                    URLConnection uRLConnection = uRL.openConnection();
                    InputStream inputStream = uRLConnection.getInputStream();
                    properties.load(inputStream);
                }
            }
            catch (Exception exception2) {
                return null;
            }
        }
        return properties;
    }

    protected String getDefaultFileName(boolean bl) {
        String string = System.getProperty("file.separator");
        String string2 = "";
        string2 = bl ? System.getProperty("user.home") : System.getProperty("user.dir");
        if (string.equals("/")) {
            return string2 + string + ".runner.props";
        }
        return string2 + string + "runner.props";
    }
}

