/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class DynamicClassLoader {
    public static Class forName(String string) throws ClassNotFoundException {
        return Class.forName(string);
    }

    public Object getInstance(String string) throws IllegalArgumentException {
        try {
            Class clazz = DynamicClassLoader.forName(string);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Couldn't find " + string + " " + classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Couldn't access " + string + " " + illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Couldn't instantiate " + string + " " + instantiationException);
        }
    }

    public Object getInstance(String string, Object[] objectArray) throws IllegalArgumentException {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        return this.getInstance(string, classArray, objectArray);
    }

    public Object getInstance(String string, Class[] classArray, Object[] objectArray) throws IllegalArgumentException {
        try {
            Class clazz = DynamicClassLoader.forName(string);
            Constructor constructor = clazz.getConstructor(classArray);
            System.out.println("ctor: " + constructor.getName() + "  " + constructor.getModifiers());
            return constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Couldn't find " + string + " " + classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Couldn't access " + string + " " + illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("Couldn't find constructor for " + string + " " + noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            throw new IllegalArgumentException("Couldn't invoke " + string + " " + invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Couldn't instantiate " + string + " " + instantiationException);
        }
    }
}

