/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.FileHelper;
import convwatch.GlobalLogWriter;
import convwatch.OSHelper;
import convwatch.StatusHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import util.utils;

public class HTMLOutputter {
    FileWriter m_aOut;
    String m_sFilename;
    String m_sNamePrefix;
    String ls;
    static final String TEST_TABLETITLE = "Test";
    static final String VISUAL_STATUS_TABLETITLE = "Visual status";
    static final String VISUAL_STATUS_MESSAGE_TABLETITLE = "Message";
    static final String FIRSTGFX_TABLETITLE = "Original print file as jpeg";
    static final String SECONDGFX_TABLETITLE = "New print file as jpeg";
    static final String DIFFER_TABLETITLE = "Difference file";
    static final String STATUS_TABLETITLE = "Status";
    static final String PIXELDIFF_TABLETITLE = "Pixel difference in %";
    static final String PIXELDIFF_BM_TABLETITLE = "P.diff. in % after remove border";
    static final String DIFFER_BM_TABLETITLE = "Diff file (RB)";
    static final String OK_TABLETITLE = "OK?";

    HTMLOutputter() {
    }

    public static HTMLOutputter create(String string, String string2, String string3, String string4) {
        FileHelper.makeDirectories("", string);
        HTMLOutputter hTMLOutputter = new HTMLOutputter();
        String string5 = System.getProperty("file.separator");
        String string6 = string + string5 + string2;
        try {
            File file = new File(string6);
            hTMLOutputter.m_aOut = new FileWriter(file.toString());
            hTMLOutputter.ls = System.getProperty("line.separator");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            GlobalLogWriter.get().println("ERROR: Can't create HTML Outputter");
            return null;
        }
        hTMLOutputter.m_sFilename = string6;
        hTMLOutputter.m_sNamePrefix = string3;
        return hTMLOutputter;
    }

    public String getFilename() {
        return this.m_sFilename;
    }

    public void header(String string) {
        try {
            this.m_aOut.write("<html>" + this.ls);
            this.m_aOut.write("<head>" + this.ls);
            this.m_aOut.write("<title>" + string + "</title>" + this.ls);
            this.m_aOut.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"http://mahler.germany.sun.com/qadev/css/xmloff.css\" media=\"screen\" />" + this.ls);
            this.m_aOut.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"http://mahler.germany.sun.com/qadev/css/style.css\" media=\"screen\" />" + this.ls);
            this.m_aOut.write("</head>" + this.ls);
            this.m_aOut.write("<body bgcolor=white>" + this.ls);
            this.m_aOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void indexSection(String string) {
        try {
            this.m_aOut.write("<h2>Results for " + string + "</h2>" + this.ls);
            this.m_aOut.write("<p>Legend:<br>");
            this.m_aOut.write(this.stronghtml(FIRSTGFX_TABLETITLE) + " contains the output printed via 'ghostscript' as a jpeg picture.<br>");
            this.m_aOut.write("<table class=\"infotable\">" + this.ls);
            this.m_aOut.write("<TR>");
            this.m_aOut.write(this.tableHeaderCell(TEST_TABLETITLE));
            this.m_aOut.write(this.tableHeaderCell(TEST_TABLETITLE));
            this.m_aOut.write(this.tableHeaderCell(VISUAL_STATUS_TABLETITLE));
            this.m_aOut.write(this.tableHeaderCell(VISUAL_STATUS_MESSAGE_TABLETITLE));
            this.m_aOut.write("</TR>" + this.ls);
            this.m_aOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    String getHREF(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!OSHelper.isWindows()) {
            stringBuffer.append("<A HREF=\"");
            stringBuffer.append(string);
            stringBuffer.append("\">");
            stringBuffer.append(string2);
            stringBuffer.append("</A>");
        } else {
            stringBuffer.append(string2);
            stringBuffer.append("<A HREF=\"");
            stringBuffer.append(string);
            stringBuffer.append("\">");
            stringBuffer.append("(first)");
            stringBuffer.append("</A>");
            int n = 0;
            n = string.indexOf("X:");
            if (n == -1) {
                n = string.indexOf("x:");
            }
            if (n >= 0) {
                StringBuffer stringBuffer2 = new StringBuffer(string.substring(0, n));
                stringBuffer2.append("/tausch");
                stringBuffer2.append(string.substring(n + 2));
                String string3 = stringBuffer2.toString();
                string3 = utils.replaceAll13(string3, "\\", "/");
                stringBuffer.append("<A HREF=\"");
                stringBuffer.append(string3);
                stringBuffer.append("\">");
                stringBuffer.append("(second)");
                stringBuffer.append("</A>");
            }
        }
        return stringBuffer.toString();
    }

    String tableDataCell(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<TD>");
        stringBuffer.append(string);
        stringBuffer.append("</TD>");
        return stringBuffer.toString();
    }

    String tableHeaderCell(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<TH>");
        stringBuffer.append(string);
        stringBuffer.append("</TH>");
        return stringBuffer.toString();
    }

    public void indexLine(String string, String string2, String string3, String string4, String string5, String string6) {
        try {
            this.m_aOut.write("<TR>");
            this.m_aOut.write(this.tableDataCell(this.getHREF(string, string2)));
            if (string3.length() > 0) {
                this.m_aOut.write(this.tableDataCell(this.getHREF(string3, string4)));
            } else {
                this.m_aOut.write(this.tableDataCell(""));
            }
            this.m_aOut.write(this.tableDataCell(string5));
            this.m_aOut.write(this.tableDataCell(string6));
            this.m_aOut.write("</TR>" + this.ls);
            this.m_aOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        try {
            this.m_aOut.write("</TABLE>" + this.ls);
            this.m_aOut.write("</BODY></HTML>" + this.ls);
            this.m_aOut.flush();
            this.m_aOut.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    String stronghtml(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<STRONG>");
        stringBuffer.append(string);
        stringBuffer.append("</STRONG>");
        return stringBuffer.toString();
    }

    public void checkSection(String string) {
        try {
            this.m_aOut.write("<H2>Results for the document " + string + "</H2>" + this.ls);
            this.m_aOut.write("<p>Legend:<br>");
            this.m_aOut.write(this.stronghtml(FIRSTGFX_TABLETITLE) + " contains the output printed via 'ghostscript' as a jpeg picture.<br>");
            this.m_aOut.write(this.stronghtml(SECONDGFX_TABLETITLE) + " contains the same document opened within OpenOffice.org also printed via ghostscript as jpeg.<br>");
            this.m_aOut.write(this.stronghtml(DIFFER_TABLETITLE) + " is build via composite from original and new picture. The result should be a whole black picture, if there are no differences.<br>At the moment " + this.stronghtml(STATUS_TABLETITLE) + " is only ok, if the difference file contains only one color (black).</p>");
            this.m_aOut.write(this.stronghtml(DIFFER_BM_TABLETITLE) + " is build via composite from original and new picture after the border of both pictures are removed, so differences based on center problems may solved here");
            this.m_aOut.write("</p>");
            this.m_aOut.write("<p>Some words about the percentage value<br>");
            this.m_aOut.write("If a character is on the original page (a) and on the new page this character is moved to an other position only (b) , this means the difference is 100%.<br>");
            this.m_aOut.write("If character (b) is also bigger than character (a) the percentage is grow over the 100% mark.<br>");
            this.m_aOut.write("This tool count only the pixels which are differ to it's background color. It makes no sense to count all pixels, or the difference percentage will most the time in a very low percentage range.");
            this.m_aOut.write("</p>");
            this.m_aOut.write("<table class=\"infotable\">" + this.ls);
            this.m_aOut.write("<TR>" + this.ls);
            this.m_aOut.write(this.tableHeaderCell(FIRSTGFX_TABLETITLE));
            this.m_aOut.write(this.tableHeaderCell(SECONDGFX_TABLETITLE));
            this.m_aOut.write(this.tableHeaderCell(DIFFER_TABLETITLE));
            this.m_aOut.write(this.tableHeaderCell(PIXELDIFF_TABLETITLE));
            this.m_aOut.write(this.tableHeaderCell(DIFFER_BM_TABLETITLE));
            this.m_aOut.write(this.tableHeaderCell(PIXELDIFF_BM_TABLETITLE));
            this.m_aOut.write(this.tableHeaderCell(OK_TABLETITLE));
            this.m_aOut.write("</TR>" + this.ls);
            this.m_aOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void checkLine(StatusHelper statusHelper, boolean bl) {
        try {
            this.m_aOut.write("<TR>" + this.ls);
            String string = this.getHREF(FileHelper.getBasename(statusHelper.m_sOldGfx), FileHelper.getBasename(statusHelper.m_sOldGfx));
            this.m_aOut.write(this.tableDataCell(string));
            string = this.getHREF(FileHelper.getBasename(statusHelper.m_sNewGfx), FileHelper.getBasename(statusHelper.m_sNewGfx));
            this.m_aOut.write(this.tableDataCell(string));
            string = this.getHREF(FileHelper.getBasename(statusHelper.m_sDiffGfx), FileHelper.getBasename(statusHelper.m_sDiffGfx));
            this.m_aOut.write(this.tableDataCell(string));
            String string2 = String.valueOf(statusHelper.nPercent) + "%";
            if (statusHelper.nPercent > 0 && statusHelper.nPercent < 5) {
                string2 = string2 + " (less 5% is ok)";
            }
            this.m_aOut.write(this.tableDataCell(string2));
            if (statusHelper.m_sDiff_BM_Gfx == null) {
                string = "No diffs, therefore no moves";
                this.m_aOut.write(this.tableDataCell(string));
                this.m_aOut.write(this.tableDataCell(""));
            } else {
                string = this.getHREF(FileHelper.getBasename(statusHelper.m_sDiff_BM_Gfx), FileHelper.getBasename(statusHelper.m_sDiff_BM_Gfx));
                this.m_aOut.write(this.tableDataCell(string));
                String string3 = String.valueOf(statusHelper.nPercent2) + "%";
                if (statusHelper.nPercent2 > 0 && statusHelper.nPercent2 < 5) {
                    string3 = string3 + " (less 5% is ok)";
                }
                this.m_aOut.write(this.tableDataCell(string3));
            }
            if (bl) {
                this.m_aOut.write(this.tableDataCell("YES"));
            } else {
                this.m_aOut.write(this.tableDataCell("NO"));
            }
            this.m_aOut.write("</TR>" + this.ls);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void checkDiffDiffSection(String string) {
        try {
            this.m_aOut.write("<H2>Results for the document " + string + "</H2>" + this.ls);
            this.m_aOut.write("<p>Legend:<br>");
            this.m_aOut.write("</p>");
            this.m_aOut.write("<table class=\"infotable\">" + this.ls);
            this.m_aOut.write("<TR>" + this.ls);
            this.m_aOut.write(this.tableHeaderCell("Source to actual difference"));
            this.m_aOut.write(this.tableHeaderCell("Actual difference"));
            this.m_aOut.write(this.tableHeaderCell(DIFFER_TABLETITLE));
            this.m_aOut.write(this.tableHeaderCell(PIXELDIFF_TABLETITLE));
            this.m_aOut.write(this.tableHeaderCell(OK_TABLETITLE));
            this.m_aOut.write("</TR>" + this.ls);
            this.m_aOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void checkDiffDiffLine(StatusHelper statusHelper, boolean bl) {
        try {
            this.m_aOut.write("<TR>" + this.ls);
            String string = FileHelper.getBasename(this.m_sFilename);
            String string2 = string.substring(this.m_sNamePrefix.length());
            String string3 = this.getHREF(string2, string2);
            this.m_aOut.write(this.tableDataCell(string3));
            string3 = this.getHREF(FileHelper.getBasename(statusHelper.m_sNewGfx), FileHelper.getBasename(statusHelper.m_sNewGfx));
            this.m_aOut.write(this.tableDataCell(string3));
            string3 = this.getHREF(FileHelper.getBasename(statusHelper.m_sDiffGfx), FileHelper.getBasename(statusHelper.m_sDiffGfx));
            this.m_aOut.write(this.tableDataCell(string3));
            String string4 = String.valueOf(statusHelper.nPercent) + "%";
            this.m_aOut.write(this.tableDataCell(string4));
            if (bl) {
                this.m_aOut.write(this.tableDataCell("YES"));
            } else {
                this.m_aOut.write(this.tableDataCell("NO"));
            }
            this.m_aOut.write("</TR>" + this.ls);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

