/*
 * Decompiled with CFR 0.152.
 */
package ifc.frame;

import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XSynchronousFrameLoader;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.SOfficeFactory;

public class _XSynchronousFrameLoader
extends MultiMethodTest {
    public XSynchronousFrameLoader oObj = null;
    private String url = null;
    private XFrame frame = null;
    private XComponent frameSup = null;
    private PropertyValue[] descr = null;

    public void before() {
        URL[] uRLArray;
        this.url = (String)this.tEnv.getObjRelation("FrameLoader.URL");
        this.frame = (XFrame)this.tEnv.getObjRelation("FrameLoader.Frame");
        if (this.url == null) {
            throw new StatusException(Status.failed("Some relations not found"));
        }
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)this.tParam.getMSF());
        XURLTransformer xURLTransformer = null;
        if (this.frame == null) {
            try {
                this.log.println("creating a textdocument");
                this.frameSup = sOfficeFactory.createTextDoc(null);
                uRLArray = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.frame.Desktop");
                XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)uRLArray);
                this.frame = xDesktop.getCurrentFrame();
                Object object = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.util.URLTransformer");
                xURLTransformer = (XURLTransformer)UnoRuntime.queryInterface(XURLTransformer.class, object);
            }
            catch (Exception exception) {
                exception.printStackTrace(this.log);
                throw new StatusException("Couldn't create a document.", exception);
            }
        }
        uRLArray = new URL[]{new URL()};
        uRLArray[0].Complete = this.url;
        boolean bl = xURLTransformer.parseStrict(uRLArray);
        this.log.println("Parsing URL '" + this.url + "': " + bl);
        this.descr = new PropertyValue[1];
        this.descr[0] = new PropertyValue();
        this.descr[0].Name = "URL";
        this.descr[0].Value = uRLArray[0];
    }

    public void _load() {
        boolean bl = this.oObj.load(this.descr, this.frame);
        this.tRes.tested("load()", bl);
    }

    public void _cancel() {
        this.requiredMethod("load()");
        final boolean[] blArray = new boolean[1];
        new Thread(){

            public void run() {
                blArray[0] = _XSynchronousFrameLoader.this.oObj.load(_XSynchronousFrameLoader.this.descr, _XSynchronousFrameLoader.this.frame);
            }
        }.start();
        this.oObj.cancel();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.tRes.tested("cancel()", !blArray[0]);
    }

    protected void after() {
        if (this.frameSup != null) {
            this.frameSup.dispose();
        }
    }
}

