/*
 * Decompiled with CFR 0.152.
 */
package ifc.io;

import com.sun.star.beans.Property;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.io.IOException;
import com.sun.star.io.XObjectInputStream;
import com.sun.star.io.XObjectOutputStream;
import com.sun.star.io.XPersistObject;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import lib.MultiMethodTest;
import lib.Status;
import util.ValueComparer;

public class _XObjectInputStream
extends MultiMethodTest {
    public XObjectInputStream oObj = null;
    private Object objRead = null;
    private Object objWrite = null;

    public void _readObject() {
        XInterface xInterface;
        this.objWrite = this.tEnv.getObjRelation("PersistObject");
        if (this.objWrite == null) {
            this.log.println("PersistObject not found in relations");
            this.tRes.tested("readObject()", false);
            return;
        }
        try {
            xInterface = (XObjectOutputStream)this.tEnv.getObjRelation("StreamWriter");
            xInterface.writeObject((XPersistObject)this.objWrite);
        }
        catch (IOException iOException) {
            this.log.println("Couldn't write object to stream");
            iOException.printStackTrace(this.log);
            this.tRes.tested("readObject()", Status.skipped(false));
            return;
        }
        try {
            this.objRead = this.oObj.readObject();
        }
        catch (IOException iOException) {
            this.log.println("Couldn't read object from stream");
            iOException.printStackTrace(this.log);
            this.tRes.tested("readObject()", false);
            return;
        }
        if (this.objRead == null) {
            this.log.println("No object was read.");
            this.tRes.tested("readObject()", false);
            return;
        }
        xInterface = null;
        XPropertySet xPropertySet = null;
        xInterface = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, this.objRead);
        xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, this.objWrite);
        if (xInterface == null) {
            this.log.println("Object read doesn't implement XPropertySet");
            this.tRes.tested("readObject()", false);
            return;
        }
        if (xPropertySet == null) {
            this.log.println("Object written doesn't implement XPropertySet");
            this.tRes.tested("readObject()", false);
            return;
        }
        this.tRes.tested("readObject()", this.compareProperties((XPropertySet)xInterface, xPropertySet));
    }

    protected boolean compareProperties(XPropertySet xPropertySet, XPropertySet xPropertySet2) {
        Property[] propertyArray;
        Property[] propertyArray2 = xPropertySet.getPropertySetInfo().getProperties();
        if (propertyArray2.length != (propertyArray = xPropertySet2.getPropertySetInfo().getProperties()).length) {
            this.log.println("Number of properties differs");
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < propertyArray2.length; ++i) {
            String string = propertyArray2[i].Name;
            this.log.print("Comparing property '" + string + "' ...");
            boolean bl2 = false;
            try {
                bl2 = ValueComparer.equalValue(xPropertySet.getPropertyValue(string), xPropertySet2.getPropertyValue(string));
            }
            catch (UnknownPropertyException unknownPropertyException) {
                this.log.println("Not found !");
            }
            catch (WrappedTargetException wrappedTargetException) {
                this.log.println(wrappedTargetException);
            }
            if (bl2) {
                this.log.println("OK.");
            } else {
                this.log.println("Different !");
            }
            bl &= bl2;
        }
        return bl;
    }

    public void after() {
        this.disposeEnvironment();
    }
}

