/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.container.XIndexAccess;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.sheet.GoalResult;
import com.sun.star.sheet.XGoalSeek;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellAddress;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.StatusException;

public class _XGoalSeek
extends MultiMethodTest {
    public XGoalSeek oObj = null;
    XSpreadsheet xSheet = null;
    CellAddress aFormula = null;
    CellAddress aValue = null;

    public void before() {
        Exception exception = null;
        try {
            XSpreadsheetDocument xSpreadsheetDocument = (XSpreadsheetDocument)UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)this.oObj);
            XSpreadsheets xSpreadsheets = xSpreadsheetDocument.getSheets();
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSpreadsheets);
            this.xSheet = (XSpreadsheet)UnoRuntime.queryInterface(XSpreadsheet.class, xIndexAccess.getByIndex(1));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exception = indexOutOfBoundsException;
        }
        catch (WrappedTargetException wrappedTargetException) {
            exception = wrappedTargetException;
        }
        catch (NullPointerException nullPointerException) {
            exception = nullPointerException;
        }
        if (exception != null) {
            throw new StatusException("Could not get a sheet.", exception);
        }
        try {
            this.xSheet.getCellByPosition(3, 4).setValue(9.0);
            this.xSheet.getCellByPosition(3, 5).setFormula("= SQRT(D5)");
            this.aValue = new CellAddress(1, 3, 4);
            this.aFormula = new CellAddress(1, 3, 5);
        }
        catch (Exception exception2) {
            throw new StatusException("Could not get set formulas on the sheet.", exception2);
        }
    }

    public void _seekGoal() {
        boolean bl = true;
        double d = 0.01;
        GoalResult goalResult = this.oObj.seekGoal(this.aFormula, this.aValue, "4");
        this.log.println("Goal Result: " + goalResult.Result + "   Divergence: " + goalResult.Divergence);
        bl &= goalResult.Divergence < d;
        bl &= goalResult.Result > 16.0 - d || goalResult.Result < 16.0 + d;
        goalResult = this.oObj.seekGoal(this.aFormula, this.aValue, "-4");
        this.log.println("Goal Result: " + goalResult.Result + "   Divergence: " + goalResult.Divergence);
        bl &= goalResult.Divergence > 1.0 / d;
        bl &= goalResult.Result < d || goalResult.Result > -d;
        try {
            this.xSheet.getCellByPosition(3, 4).setValue(0.8);
            this.xSheet.getCellByPosition(3, 5).setFormula("= (D5 ^ 2 - 1) / (D5 - 1)");
        }
        catch (Exception exception) {
            // empty catch block
        }
        goalResult = this.oObj.seekGoal(this.aFormula, this.aValue, "2");
        this.log.println("Goal Result: " + goalResult.Result + "   Divergence: " + goalResult.Divergence);
        bl &= goalResult.Divergence < d;
        this.tRes.tested("seekGoal()", bl &= goalResult.Result > 16.0 - d || goalResult.Result < 16.0 + d);
    }
}

