/*
 * Decompiled with CFR 0.152.
 */
package mod._bridgefac.uno;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.utils;

public class BridgeFactory
extends TestCase {
    protected static final int basePort = 50003;
    private int curPort;
    private static String sOfficeHost = null;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        String string = (String)testParameters.get("CNCSTR");
        int n = string.indexOf("host=") + 5;
        sOfficeHost = string.substring(n, string.indexOf(",", n));
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
    }

    protected synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XInterface xInterface = null;
        try {
            xInterface = (XInterface)((XMultiServiceFactory)testParameters.getMSF()).createInstance("com.sun.star.bridge.BridgeFactory");
        }
        catch (Exception exception) {
            throw new StatusException("Can't create object environment", exception);
        }
        if (xInterface == null) {
            throw new StatusException("Can't create service", new NullPointerException());
        }
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        this.curPort = utils.getNextFreePort(50003);
        printWriter.println("Choose Port nr: " + this.curPort);
        testEnvironment.addObjRelation("CNNCTSTR", "socket,host=" + sOfficeHost + ",port=" + this.curPort);
        testEnvironment.addObjRelation("Connector.Port", new Integer(this.curPort));
        return testEnvironment;
    }

    public synchronized void disposeTestEnvironment(TestEnvironment testEnvironment, TestParameters testParameters) {
        this.curPort = (Integer)testEnvironment.getObjRelation("Connector.Port");
    }
}

