/*
 * Decompiled with CFR 0.152.
 */
package mod._sd;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XWindow;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleSlideView
extends TestCase {
    XModel aModel = null;
    XComponent xImpressDoc = null;

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XAccessibleContext xAccessibleContext = null;
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        XDrawPagesSupplier xDrawPagesSupplier = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this.aModel);
        XDrawPages xDrawPages = xDrawPagesSupplier.getDrawPages();
        xDrawPages.insertNewByIndex(0);
        this.shortWait();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)testParameters.getMSF(), this.aModel);
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.printAccessibleTree(printWriter, xAccessible, testParameters.getBool("DebugIsActive"));
        AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)13);
        xAccessibleContext = AccessibilityTools.SearchedContext;
        System.out.println("ImplementationName " + utils.getImplName(xAccessibleContext));
        TestEnvironment testEnvironment = new TestEnvironment(xAccessibleContext);
        printWriter.println("Implementationname: " + utils.getImplName(xAccessibleContext));
        final XDrawPages xDrawPages2 = xDrawPages;
        testEnvironment.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            public void fireEvent() {
                xDrawPages2.insertNewByIndex(2);
            }
        });
        return testEnvironment;
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("disposing impress document");
        DesktopTools.closeDoc(this.xImpressDoc);
    }

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a impress document");
            this.xImpressDoc = sOfficeFactory.createImpressDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
        this.shortWait();
        this.aModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.xImpressDoc);
        try {
            String string = "slot:27011";
            XDispatchProvider xDispatchProvider = (XDispatchProvider)UnoRuntime.queryInterface(XDispatchProvider.class, (Object)this.aModel.getCurrentController());
            XURLTransformer xURLTransformer = (XURLTransformer)UnoRuntime.queryInterface(XURLTransformer.class, ((XMultiServiceFactory)testParameters.getMSF()).createInstance("com.sun.star.util.URLTransformer"));
            URL[] uRLArray = new URL[]{new URL()};
            uRLArray[0].Complete = string;
            xURLTransformer.parseStrict(uRLArray);
            URL uRL = uRLArray[0];
            XDispatch xDispatch = xDispatchProvider.queryDispatch(uRL, "", 0);
            if (xDispatch != null) {
                xDispatch.dispatch(uRL, null);
            }
        }
        catch (Exception exception) {
            printWriter.println("Couldn't change mode");
        }
        this.shortWait();
    }

    private void shortWait() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("While waiting :" + interruptedException);
        }
    }
}

