/*
 * Decompiled with CFR 0.152.
 */
package mod._svx;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.Size;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.drawing.XShape;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.DrawTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleOLEShape
extends TestCase {
    XComponent xDrawDoc;
    XModel aModel;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a drawdoc");
            this.xDrawDoc = sOfficeFactory.createDrawDoc(null);
            this.aModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.xDrawDoc);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xDrawDoc ");
        DesktopTools.closeDoc(this.xDrawDoc);
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XAccessibleContext xAccessibleContext = null;
        printWriter.println("creating a test environment");
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        final XShape xShape = sOfficeFactory.createShape(this.xDrawDoc, 5000, 5000, 1500, 1000, "OLE2");
        DrawTools.getShapes(DrawTools.getDrawPage(this.xDrawDoc, 0)).add(xShape);
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xShape);
        printWriter.println("Inserting a Chart");
        try {
            xPropertySet.setPropertyValue("CLSID", "12DCAE26-281F-416F-a234-c3086127382e");
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(printWriter);
            throw new StatusException("Couldn't change property", wrappedTargetException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Couldn't change property", illegalArgumentException);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace(printWriter);
            throw new StatusException("Couldn't change property", propertyVetoException);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            unknownPropertyException.printStackTrace(printWriter);
            throw new StatusException("Couldn't change property", unknownPropertyException);
        }
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)testParameters.getMSF(), this.aModel);
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.printAccessibleTree(printWriter, xAccessible, testParameters.getBool("DebugIsActive"));
        xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)52, "OLEShape");
        TestEnvironment testEnvironment = new TestEnvironment(xAccessibleContext);
        testEnvironment.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            public void fireEvent() {
                try {
                    Size size = xShape.getSize();
                    size.Width += 100;
                    xShape.setSize(size);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
        printWriter.println("Implementation Name: " + utils.getImplName(xAccessibleContext));
        return testEnvironment;
    }
}

