/*
 * Decompiled with CFR 0.152.
 */
package mod._svx;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.document.XExporter;
import com.sun.star.drawing.XShape;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.URL;
import ifc.document._XFilter;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.DrawTools;
import util.SOfficeFactory;
import util.XMLTools;
import util.utils;

public class GraphicExporter
extends TestCase {
    XComponent xDrawDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("creating a drawdoc");
        this.xDrawDoc = DrawTools.createDrawDoc((XMultiServiceFactory)testParameters.getMSF());
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xDrawDoc ");
        DesktopTools.closeDoc(this.xDrawDoc);
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XSimpleFileAccess xSimpleFileAccess;
        Object object;
        Object object2;
        XInterface xInterface = null;
        XShape xShape = null;
        Object object3 = null;
        printWriter.println("creating a test environment");
        try {
            object3 = ((XMultiServiceFactory)testParameters.getMSF()).createInstance("com.sun.star.drawing.GraphicExportFilter");
        }
        catch (Exception exception) {
            printWriter.println("Couldn't create instance");
            exception.printStackTrace(printWriter);
        }
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        xShape = sOfficeFactory.createShape(this.xDrawDoc, 5000, 5000, 1500, 1000, "GraphicObject");
        DrawTools.getShapes(DrawTools.getDrawPage(this.xDrawDoc, 0)).add(xShape);
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xShape);
        XComponent xComponent = null;
        try {
            xPropertySet.setPropertyValue("GraphicURL", utils.getFullTestURL("space-metal.jpg"));
            xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xShape);
            object2 = (XExporter)UnoRuntime.queryInterface(XExporter.class, (Object)((XInterface)object3));
            object2.setSourceDocument(xComponent);
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(printWriter);
            throw new StatusException("Error while preparing component", wrappedTargetException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Error while preparing component", illegalArgumentException);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace(printWriter);
            throw new StatusException("Error while preparing component", propertyVetoException);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            unknownPropertyException.printStackTrace(printWriter);
            throw new StatusException("Error while preparing component", unknownPropertyException);
        }
        object2 = new URL();
        ((URL)object2).Complete = utils.getOfficeTemp((XMultiServiceFactory)testParameters.getMSF()) + "picture.jpg";
        try {
            object = ((XMultiServiceFactory)testParameters.getMSF()).createInstance("com.sun.star.ucb.SimpleFileAccess");
            xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, object);
            if (xSimpleFileAccess.exists(((URL)object2).Complete)) {
                xSimpleFileAccess.kill(((URL)object2).Complete);
            }
        }
        catch (Exception exception) {
            printWriter.println("Error accessing file system :");
            exception.printStackTrace(printWriter);
            throw new StatusException("Error accessing file system.", exception);
        }
        xInterface = (XInterface)object3;
        printWriter.println("ImplName " + utils.getImplName(xInterface));
        object = new TestEnvironment(xInterface);
        ((TestEnvironment)object).addObjRelation("MediaDescriptor", XMLTools.createMediaDescriptor(new String[]{"FilterName", "URL", "MediaType"}, new Object[]{"JPG", object2, "image/jpeg"}));
        ((TestEnvironment)object).addObjRelation("SourceDocument", xComponent);
        printWriter.println("adding ObjRelation for XFilter");
        printWriter.println("This Component doesn't really support the cancel method");
        printWriter.println("See #101725");
        ((TestEnvironment)object).addObjRelation("NoFilter.cancel()", new Boolean(true));
        final String string = (String)testParameters.get("soapi.test.hidewindows");
        ((TestEnvironment)object).addObjRelation("XFilter.Checker", new _XFilter.FilterChecker((URL)object2){
            final /* synthetic */ URL val$aURL;
            {
                this.val$aURL = uRL;
            }

            public boolean checkFilter() {
                try {
                    if (string != null && string.equals("true")) {
                        return true;
                    }
                    return xSimpleFileAccess.exists(this.val$aURL.Complete);
                }
                catch (Exception exception) {
                    return false;
                }
            }
        });
        return object;
    }
}

