/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XAutoTextContainer;
import com.sun.star.text.XAutoTextEntry;
import com.sun.star.text.XAutoTextGroup;
import com.sun.star.text.XText;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DefaultDsc;
import util.DesktopTools;
import util.InstCreator;
import util.SOfficeFactory;

public class SwXAutoTextEntry
extends TestCase {
    XTextDocument xTextDoc;
    XAutoTextGroup oGroup;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory(xMultiServiceFactory);
        try {
            printWriter.println("creating a textdocument");
            this.xTextDoc = sOfficeFactory.createTextDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        try {
            if (this.oGroup.hasByName("NewEntryName")) {
                printWriter.println("Removing 'NewEntryName' element");
                this.oGroup.removeByName("NewEntryName");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            printWriter.println("Cannot remove TextEntry from group...");
            noSuchElementException.printStackTrace(printWriter);
        }
        printWriter.println("disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    protected synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XAutoTextContainer xAutoTextContainer;
        String[] stringArray;
        XInterface xInterface;
        XAutoTextEntry xAutoTextEntry = null;
        XInterface xInterface2 = null;
        boolean bl = false;
        boolean bl2 = false;
        printWriter.println("creating a test environment");
        try {
            xInterface = (XMultiServiceFactory)testParameters.getMSF();
            stringArray = xInterface.createInstance("com.sun.star.text.AutoTextContainer");
            xAutoTextContainer = (XAutoTextContainer)UnoRuntime.queryInterface(XAutoTextContainer.class, (Object)stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create AutoTextContainer", exception);
        }
        xInterface = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xAutoTextContainer);
        stringArray = xInterface.getElementNames();
        for (int i = 0; i < stringArray.length; ++i) {
            printWriter.println("ContainerNames[ " + i + "]: " + stringArray[i]);
        }
        try {
            xInterface2 = (XInterface)AnyConverter.toObject((Type)new Type(XInterface.class), (Object)xInterface.getByName("mytexts"));
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't get AutoTextGroup", exception);
        }
        this.oGroup = (XAutoTextGroup)UnoRuntime.queryInterface(XAutoTextGroup.class, (Object)xInterface2);
        String[] stringArray2 = this.oGroup.getElementNames();
        for (int i = 0; i < stringArray2.length; ++i) {
            printWriter.println("AutoTextEntryNames[" + i + "]: " + stringArray2[i]);
        }
        XText xText = this.xTextDoc.getText();
        xText.insertString(xText.getStart(), "New AutoText", true);
        XTextRange xTextRange = xText;
        try {
            if (this.oGroup.hasByName("NewEntryName")) {
                this.oGroup.removeByName("NewEntryName");
                printWriter.println("Element 'NewEntryName' exists, removing...");
            }
            printWriter.println("Adding new element 'NewEntryName' to group...");
            this.oGroup.insertNewByName("NewEntryName", "NewEntryTitle", xTextRange);
            xAutoTextEntry = (XAutoTextEntry)AnyConverter.toObject((Type)new Type(XAutoTextEntry.class), (Object)this.oGroup.getByName("NewEntryName"));
        }
        catch (ElementExistException elementExistException) {
            elementExistException.printStackTrace(printWriter);
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace(printWriter);
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(printWriter);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
        }
        xInterface2 = xAutoTextEntry;
        printWriter.println("Trying to use XText as TextRange in the method applyTo");
        xAutoTextEntry.applyTo(xTextRange);
        xTextRange = xText.createTextCursor();
        printWriter.println("Trying to use XTextCursor as TextRange in the method applyTo");
        xAutoTextEntry.applyTo(xTextRange);
        printWriter.println("creating a new environment for AutoTextEntry object");
        TestEnvironment testEnvironment = new TestEnvironment(xInterface2);
        DefaultDsc defaultDsc = new DefaultDsc("com.sun.star.text.XTextContent", "com.sun.star.text.TextField.DateTime");
        printWriter.println("    adding InstCreator object");
        testEnvironment.addObjRelation("XTEXTINFO", new InstCreator(this.xTextDoc, defaultDsc));
        printWriter.println("adding TextDocument as mod relation to environment");
        testEnvironment.addObjRelation("TEXTDOC", this.xTextDoc);
        return testEnvironment;
    }
}

