/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXDocumentIndex
extends TestCase {
    XTextDocument xTextDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a textdocument");
            this.xTextDoc = sOfficeFactory.createTextDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XTextContent xTextContent = null;
        XTextContent xTextContent2 = null;
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        printWriter.println("creating a test environment");
        try {
            xTextContent = SOfficeFactory.createIndex(this.xTextDoc, "com.sun.star.text.DocumentIndex");
            xTextContent2 = SOfficeFactory.createIndex(this.xTextDoc, "com.sun.star.text.DocumentIndex");
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create the Index", exception);
        }
        XText xText = this.xTextDoc.getText();
        XTextCursor xTextCursor = xText.createTextCursor();
        printWriter.println("inserting the Index into text document");
        try {
            xText.insertTextContent(xTextCursor, xTextContent, false);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't insert the Index", exception);
        }
        TestEnvironment testEnvironment = new TestEnvironment(xTextContent);
        testEnvironment.addObjRelation("CONTENT", (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xTextContent2));
        testEnvironment.addObjRelation("TextDoc", this.xTextDoc);
        return testEnvironment;
    }
}

