/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.UnoRuntime;
import ifc.util._XSortable;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.ValueComparer;

public class SwXTextTable
extends TestCase {
    SOfficeFactory SOF;
    XTextDocument xTextDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        this.SOF = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a textdocument");
            this.xTextDoc = this.SOF.createTextDoc(null);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    protected synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XTextTable xTextTable = null;
        TestEnvironment testEnvironment = null;
        XTextTable xTextTable2 = null;
        try {
            xTextTable = SOfficeFactory.createTextTable(this.xTextDoc);
            xTextTable2 = SOfficeFactory.createTextTable(this.xTextDoc);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create testobj : " + exception.getMessage(), exception);
        }
        int n = 6;
        int n2 = 2;
        xTextTable.initialize(n, n2);
        printWriter.println("Creating instance...");
        testEnvironment = new TestEnvironment(xTextTable);
        if (SOfficeFactory.getTableCollection(this.xTextDoc).getCount() == 0) {
            try {
                SOfficeFactory.insertTextContent(this.xTextDoc, xTextTable);
            }
            catch (com.sun.star.uno.Exception exception) {
                exception.printStackTrace(printWriter);
                throw new StatusException("Couldn't create TextTable : " + exception.getMessage(), exception);
            }
        }
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextTable);
        try {
            xPropertySet.setPropertyValue("ChartRowAsLabel", new Boolean(true));
            xPropertySet.setPropertyValue("ChartColumnAsLabel", new Boolean(true));
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
        }
        testEnvironment.addObjRelation("NROW", new Integer(n));
        testEnvironment.addObjRelation("NCOL", new Integer(n2));
        Object[][] objectArrayArray = new Object[6][];
        Object[] objectArray = new Object[]{new Double(1.5), new Double(2.5)};
        objectArrayArray[0] = objectArray;
        objectArrayArray[1] = objectArray;
        objectArrayArray[2] = objectArray;
        objectArrayArray[3] = objectArray;
        objectArrayArray[4] = objectArray;
        objectArrayArray[5] = objectArray;
        testEnvironment.addObjRelation("NewData", objectArrayArray);
        final PrintWriter printWriter2 = printWriter;
        final XTextTable xTextTable3 = xTextTable;
        testEnvironment.addObjRelation("SORTCHECKER", new _XSortable.XSortChecker(){
            PrintWriter out;
            {
                this.out = printWriter2;
            }

            public void setPrintWriter(PrintWriter printWriter) {
                this.out = printWriter;
            }

            public void prepareToSort() {
                xTextTable3.getCellByName("A1").setValue(4.0);
                XTextRange xTextRange = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)xTextTable3.getCellByName("A2"));
                xTextRange.setString("b");
                xTextTable3.getCellByName("A3").setValue(3.0);
                xTextRange = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)xTextTable3.getCellByName("A4"));
                xTextRange.setString("a");
                xTextTable3.getCellByName("A5").setValue(23.0);
                xTextRange = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)xTextTable3.getCellByName("A6"));
                xTextRange.setString("ab");
            }

            public boolean checkSort(boolean bl, boolean bl2) {
                String[] stringArray;
                this.out.println("Sort checking...");
                boolean bl3 = false;
                String[] stringArray2 = new String[6];
                for (int i = 0; i < 6; ++i) {
                    stringArray = xTextTable3.getCellByName("A" + (i + 1));
                    XTextRange xTextRange = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)stringArray);
                    stringArray2[i] = xTextRange.getString();
                }
                if (bl) {
                    if (bl2) {
                        String[] stringArray3 = new String[]{"3", "4", "23"};
                        stringArray = new String[]{stringArray2[3], stringArray2[4], stringArray2[5]};
                        bl3 = ValueComparer.equalValue(stringArray, stringArray3);
                        if (!bl3) {
                            this.out.println("Expected: 3, 4, 23");
                            this.out.println("Getting: " + stringArray2[3] + ", " + stringArray2[4] + ", " + stringArray2[5]);
                        }
                    } else {
                        String[] stringArray4 = new String[]{"23", "4", "3"};
                        stringArray = new String[]{stringArray2[0], stringArray2[1], stringArray2[2]};
                        bl3 = ValueComparer.equalValue(stringArray, stringArray4);
                        if (!bl3) {
                            this.out.println("Expected: 23, 4, 3");
                            this.out.println("Getting: " + stringArray2[1] + ", " + stringArray2[2] + ", " + stringArray2[3]);
                        }
                    }
                } else if (bl2) {
                    String[] stringArray5 = new String[]{"23", "3", "4", "a", "ab", "b"};
                    bl3 = ValueComparer.equalValue(stringArray2, stringArray5);
                    if (!bl3) {
                        this.out.println("Expected: 23, 3, 4, a, ab, b");
                        this.out.println("Getting: " + stringArray2[0] + ", " + stringArray2[1] + ", " + stringArray2[2] + ", " + stringArray2[3] + ", " + stringArray2[4] + ", " + stringArray2[5]);
                    }
                } else {
                    String[] stringArray6 = new String[]{"b", "ab", "a", "4", "3", "23"};
                    bl3 = ValueComparer.equalValue(stringArray2, stringArray6);
                    if (!bl3) {
                        this.out.println("Expected: b, ab, a, 4, 3, 23");
                        this.out.println("Getting: " + stringArray2[0] + ", " + stringArray2[1] + ", " + stringArray2[2] + ", " + stringArray2[3] + ", " + stringArray2[4] + ", " + stringArray2[5]);
                    }
                }
                if (bl3) {
                    this.out.println("Sorted correctly");
                } else {
                    this.out.println("Sorted uncorrectly");
                }
                return bl3;
            }
        });
        testEnvironment.addObjRelation("CONTENT", (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xTextTable2));
        testEnvironment.addObjRelation("RANGE", this.xTextDoc.getText().createTextCursor());
        return testEnvironment;
    }
}

