/*
 * Decompiled with CFR 0.152.
 */
package mod._xmloff.Draw;

import com.sun.star.container.XNamed;
import com.sun.star.document.XExporter;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Any;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.xml.sax.XDocumentHandler;
import ifc.document._XFilter;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;
import util.XMLTools;

public class XMLExporter
extends TestCase {
    XComponent xDrawDoc = null;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a drawdocument");
            this.xDrawDoc = sOfficeFactory.createDrawDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xDrawDoc ");
        this.xDrawDoc.dispose();
    }

    protected synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        Object object;
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        XInterface xInterface = null;
        FilterChecker filterChecker = new FilterChecker(printWriter);
        Any any = new Any(new Type(XDocumentHandler.class), (Object)filterChecker);
        filterChecker.addTag(new XMLTools.Tag("office:document"));
        filterChecker.addTag(new XMLTools.Tag("office:body"));
        filterChecker.addTagEnclosed(new XMLTools.Tag("draw:page"), new XMLTools.Tag("office:body"));
        filterChecker.addTag(new XMLTools.Tag("draw:page", "draw:name", "NewSlide1"));
        filterChecker.addTag(new XMLTools.Tag("draw:page", "draw:name", "NewSlide2"));
        try {
            xInterface = (XInterface)xMultiServiceFactory.createInstanceWithArguments("com.sun.star.comp.Draw.XMLExporter", new Object[]{any});
            object = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this.xDrawDoc);
            XDrawPages xDrawPages = object.getDrawPages();
            xDrawPages.insertNewByIndex(1);
            XDrawPage xDrawPage = (XDrawPage)UnoRuntime.queryInterface(XDrawPage.class, xDrawPages.getByIndex(0));
            XNamed xNamed = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)xDrawPage);
            xNamed.setName("NewSlide1");
            XDrawPage xDrawPage2 = (XDrawPage)UnoRuntime.queryInterface(XDrawPage.class, xDrawPages.getByIndex(1));
            XNamed xNamed2 = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)xDrawPage2);
            xNamed2.setName("NewSlide2");
            XExporter xExporter = (XExporter)UnoRuntime.queryInterface(XExporter.class, (Object)xInterface);
            xExporter.setSourceDocument(this.xDrawDoc);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Can't create component.", exception);
        }
        printWriter.println("creating a new environment");
        object = new TestEnvironment(xInterface);
        ((TestEnvironment)object).addObjRelation("MediaDescriptor", XMLTools.createMediaDescriptor(new String[]{"FilterName"}, new Object[]{"sdraw: StarOffice XML (Draw)"}));
        ((TestEnvironment)object).addObjRelation("SourceDocument", this.xDrawDoc);
        ((TestEnvironment)object).addObjRelation("XFilter.Checker", filterChecker);
        return object;
    }

    protected class FilterChecker
    extends XMLTools.XMLChecker
    implements _XFilter.FilterChecker {
        public FilterChecker(PrintWriter printWriter) {
            super(printWriter, true);
        }

        public boolean checkFilter() {
            return this.check();
        }
    }
}

