/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb;

import com.sleepycat.bdb.DataEnvironment;
import com.sleepycat.bdb.DataThang;
import com.sleepycat.bdb.util.RuntimeExceptionWrapper;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbTxn;
import com.sleepycat.db.Dbc;
import java.util.ArrayList;
import java.util.List;

public class DataDb {
    public static final int ENOMEM = 12;
    public static final int EINVAL = 22;
    public static final int FLAGS_POS_MASK = 255;
    public static final int FLAGS_MOD_MASK = -256;
    DataEnvironment env;
    Db db;
    int type;
    boolean ordered;
    private ThreadLocal cdbContext;
    private String file;
    private String database;
    boolean recNumAccess;
    boolean keysRenumbered;
    boolean dupsAllowed;
    boolean dupsOrdered;
    boolean transactional;
    boolean dirtyReadAllowed;

    public DataDb(Db db) {
        try {
            this.env = DataEnvironment.getEnvironment(db.getDbEnv());
            this.file = db.getFileName();
            this.database = db.getDatabaseName();
            this.db = db;
            this.type = db.getDbType();
            this.ordered = this.type == 1 || this.type == 4 || this.type == 3;
            this.recNumAccess = this.type != 2 && (this.type != 1 || (db.getFlags() & Db.DB_RECNUM) != 0);
            this.keysRenumbered = this.type == 3 && (db.getFlags() & Db.DB_RENUMBER) != 0;
            this.dupsOrdered = (db.getFlags() & Db.DB_DUPSORT) != 0;
            this.dupsAllowed = this.dupsOrdered || (db.getFlags() & Db.DB_DUP) != 0;
            this.dirtyReadAllowed = (db.getOpenFlags() & Db.DB_DIRTY_READ) != 0;
            boolean bl = this.transactional = this.env.isTxnMode() && db.isTransactional();
            if (this.env.isCdbMode()) {
                this.cdbContext = new ThreadLocal();
                this.cdbContext.set(new CdbThreadContext(this));
            }
        }
        catch (DbException e) {
            throw new RuntimeExceptionWrapper(e);
        }
    }

    public void close() throws DbException {
        this.db.close(0);
    }

    public final DataEnvironment getEnv() {
        return this.env;
    }

    public final Db getDb() {
        return this.db;
    }

    public final boolean isOrdered() {
        return this.ordered;
    }

    public final boolean areDuplicatesAllowed() {
        return this.dupsAllowed;
    }

    public final boolean areDuplicatesOrdered() {
        return this.dupsOrdered;
    }

    public final boolean areKeysRenumbered() {
        return this.keysRenumbered;
    }

    public final boolean hasRecNumAccess() {
        return this.recNumAccess;
    }

    public final boolean isTransactional() {
        return this.transactional;
    }

    public final boolean isDirtyReadAllowed() {
        return this.dirtyReadAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get(DataThang key, DataThang data, int flags) throws DbException {
        int pos = flags & 0xFF;
        if (this.cdbContext != null) {
            Dbc cursor = this.openCursor(flags == Db.DB_CONSUME || flags == Db.DB_CONSUME_WAIT);
            try {
                if (pos == 0) {
                    flags |= Db.DB_SET;
                }
                int n = this.get(cursor, key, data, flags);
                return n;
            }
            finally {
                this.closeCursor(cursor);
            }
        }
        if (this.isRecnoKeyNonPositive(pos, key)) {
            return -30990;
        }
        return this.db.get(this.currentTxn(), key, data, flags);
    }

    public int get(Dbc cursor, DataThang key, DataThang val, int flags) throws DbException {
        int pos = flags & 0xFF;
        if (this.isRecnoKeyNonPositive(pos, key)) {
            return -30990;
        }
        int err = cursor.get(key, val, flags);
        return err;
    }

    private boolean isRecnoKeyNonPositive(int pos, DataThang key) {
        return !(pos != Db.DB_SET_RECNO && (this.type != 3 && this.type != 4 || pos != Db.DB_SET && pos != Db.DB_SET_RANGE && pos != Db.DB_GET_BOTH) || key.get_recno_key_data() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int put(DataThang key, DataThang data, int flags) throws DbException {
        DbTxn txn;
        CdbThreadContext context;
        if (this.cdbContext != null && (this.type == 2 || this.type == 1)) {
            Dbc cursor = this.openCursor(true);
            try {
                int err;
                int pos = flags & 0xFF;
                if (pos == Db.DB_NODUPDATA && !this.areDuplicatesOrdered()) {
                    if (this.areDuplicatesAllowed()) {
                        err = this.get(cursor, key, data, Db.DB_GET_BOTH);
                        if (err == 0) {
                            int n = -30996;
                            return n;
                        }
                        pos = 0;
                    } else {
                        pos = Db.DB_NOOVERWRITE;
                    }
                    flags = pos | flags & 0xFFFFFF00;
                }
                err = this.put(cursor, key, data, flags);
                return err;
            }
            finally {
                this.closeCursor(cursor);
            }
        }
        if (this.cdbContext != null && ((context = (CdbThreadContext)this.cdbContext.get()).writeCursors.size() > 0 || context.readCursors.size() > 0)) {
            throw new IllegalStateException("cannot put() with CDB write cursor open");
        }
        int pos = flags & 0xFF;
        if (pos == Db.DB_NODUPDATA && !this.areDuplicatesOrdered()) {
            if (this.areDuplicatesAllowed()) {
                int err = this.get(key, data, Db.DB_GET_BOTH);
                if (err == 0) {
                    return -30996;
                }
                pos = 0;
            } else {
                pos = Db.DB_NOOVERWRITE;
            }
            flags = pos | flags & 0xFFFFFF00;
        }
        if ((txn = this.currentTxn()) != null || !this.transactional) {
            flags &= ~Db.DB_AUTO_COMMIT;
        }
        int err = this.db.put(txn, key, data, flags);
        return err;
    }

    public int put(Dbc cursor, DataThang key, DataThang data, int flags) throws DbException {
        int err;
        if (flags == Db.DB_CURRENT && this.areDuplicatesOrdered()) {
            DataThang temp = new DataThang();
            cursor.get(key, temp, flags);
            if (data.equals(temp)) {
                return 0;
            }
            throw new IllegalArgumentException("Current data differs from put data with sorted duplicates");
        }
        if (flags == Db.DB_NOOVERWRITE) {
            err = cursor.get(key, DataThang.getDiscardDataThang(), Db.DB_SET | this.env.getWriteLockFlag());
            if (err == 0) {
                return -30996;
            }
            if (err != -30990) {
                return err;
            }
            flags = 0;
        }
        if (flags == 0) {
            flags = this.areDuplicatesOrdered() ? Db.DB_NODUPDATA : Db.DB_KEYLAST;
        }
        err = cursor.put(key, data, flags);
        return err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(DataThang key, int flags) throws DbException {
        Dbc cursor = this.openCursor(true);
        try {
            int err = cursor.get(key, DataThang.getDiscardDataThang(), Db.DB_SET | this.env.getWriteLockFlag());
            if (err == 0) {
                int n = cursor.delete(0);
                return n;
            }
            int n = err;
            return n;
        }
        finally {
            this.closeCursor(cursor);
        }
    }

    public Dbc openCursor(boolean writeCursor) throws DbException {
        if (this.cdbContext != null) {
            Dbc cursor;
            int flags;
            List cursors;
            CdbThreadContext context = (CdbThreadContext)this.cdbContext.get();
            if (writeCursor) {
                cursors = context.writeCursors;
                flags = Db.DB_WRITECURSOR;
                if (context.readCursors.size() > 0) {
                    throw new IllegalStateException("cannot open CDB write cursor when read cursor is open");
                }
            } else {
                cursors = context.readCursors;
                flags = 0;
            }
            if (cursors.size() > 0) {
                Dbc other = (Dbc)cursors.get(0);
                cursor = other.dup(0);
            } else {
                cursor = this.db.cursor(null, flags);
            }
            cursors.add(cursor);
            return cursor;
        }
        return this.db.cursor(this.currentTxn(), 0);
    }

    public Dbc dupCursor(Dbc cursor, boolean writeCursor, int flags) throws DbException {
        if (this.cdbContext != null) {
            List cursors;
            CdbThreadContext context = (CdbThreadContext)this.cdbContext.get();
            List list = cursors = writeCursor ? context.writeCursors : context.readCursors;
            if (!cursors.contains(cursor)) {
                throw new IllegalStateException("cursor to dup not tracked");
            }
            Dbc newCursor = cursor.dup(flags);
            cursors.add(newCursor);
            return newCursor;
        }
        return cursor.dup(flags);
    }

    public void closeCursor(Dbc cursor) throws DbException {
        CdbThreadContext context;
        if (cursor == null) {
            return;
        }
        if (this.cdbContext != null && !(context = (CdbThreadContext)this.cdbContext.get()).readCursors.remove(cursor) && !context.writeCursors.remove(cursor)) {
            throw new IllegalStateException("closing CDB cursor that was not known to be open");
        }
        cursor.close();
    }

    private final DbTxn currentTxn() {
        return this.transactional ? this.env.getTxn() : null;
    }

    public String toString() {
        String val = this.file;
        if (this.database != null) {
            this.file = this.file + ' ' + this.database;
        }
        return DataDb.toString(this, val);
    }

    static String toString(Object o, String val) {
        int i;
        String cls = null;
        if (o != null && (i = (cls = o.getClass().getName()).lastIndexOf(46)) >= 0) {
            cls = cls.substring(i + 1);
        }
        return "[" + cls + ' ' + val + ']';
    }

    private static final class CdbThreadContext {
        private DataDb db;
        private List writeCursors = new ArrayList();
        private List readCursors = new ArrayList();

        CdbThreadContext(DataDb db) {
            this.db = db;
        }
    }
}

