/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.bind.tuple;

import com.sleepycat.bdb.bind.DataBuffer;
import com.sleepycat.bdb.bind.DataFormat;
import com.sleepycat.bdb.bind.EntityBinding;
import com.sleepycat.bdb.bind.tuple.TupleFormat;
import com.sleepycat.bdb.bind.tuple.TupleInput;
import com.sleepycat.bdb.bind.tuple.TupleOutput;
import java.io.IOException;

public abstract class TupleTupleBinding
implements EntityBinding {
    protected TupleFormat keyFormat;
    protected TupleFormat valueFormat;

    public TupleTupleBinding(TupleFormat keyFormat, TupleFormat valueFormat) {
        this.keyFormat = keyFormat;
        this.valueFormat = valueFormat;
    }

    public Object dataToObject(DataBuffer key, DataBuffer value) throws IOException {
        return this.dataToObject(this.keyFormat.dataToInput(key), this.valueFormat.dataToInput(value));
    }

    public void objectToKey(Object object, DataBuffer key) throws IOException {
        TupleOutput output = this.keyFormat.newOutput();
        this.objectToKey(object, output);
        this.keyFormat.outputToData(output, key);
    }

    public void objectToValue(Object object, DataBuffer value) throws IOException {
        TupleOutput output = this.valueFormat.newOutput();
        this.objectToValue(object, output);
        this.valueFormat.outputToData(output, value);
    }

    public DataFormat getKeyFormat() {
        return this.keyFormat;
    }

    public DataFormat getValueFormat() {
        return this.valueFormat;
    }

    public abstract Object dataToObject(TupleInput var1, TupleInput var2) throws IOException;

    public abstract void objectToKey(Object var1, TupleOutput var2) throws IOException;

    public abstract void objectToValue(Object var1, TupleOutput var2) throws IOException;
}

