/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.collection;

import com.sleepycat.bdb.DataCursor;
import com.sleepycat.bdb.DataView;
import com.sleepycat.bdb.collection.StoredContainer;
import com.sleepycat.bdb.collection.StoredIterator;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class StoredCollection
extends StoredContainer
implements Collection {
    StoredCollection(DataView view) {
        super(view);
    }

    final boolean add(Object key, Object value) {
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            int err = this.view.put(key, value, Db.DB_NODUPDATA, null);
            this.commitAutoCommit(doAutoCommit);
            return err == 0;
        }
        catch (Exception e) {
            throw this.handleException(e, doAutoCommit);
        }
    }

    public Iterator iterator() {
        return this.iterator(this.isWriteAllowed());
    }

    public StoredIterator iterator(boolean writeAllowed) {
        try {
            return new StoredIterator(this, writeAllowed && this.isWriteAllowed(), null);
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        ArrayList list = new ArrayList();
        Iterator i = this.iterator();
        try {
            while (i.hasNext()) {
                list.add(i.next());
            }
        }
        finally {
            StoredIterator.close(i);
        }
        return list.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] a) {
        int j = 0;
        Iterator i = this.iterator();
        try {
            while (j < a.length && i.hasNext()) {
                a[j++] = i.next();
            }
            if (j < a.length) {
                a[j] = null;
            } else if (i.hasNext()) {
                ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(a));
                while (i.hasNext()) {
                    list.add(i.next());
                }
                a = list.toArray(a);
            }
        }
        finally {
            StoredIterator.close(i);
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection coll) {
        Iterator i = coll.iterator();
        try {
            while (i.hasNext()) {
                if (this.contains(i.next())) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            StoredIterator.close(i);
        }
        return true;
    }

    public boolean addAll(Collection coll) {
        Iterator i = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            i = coll.iterator();
            boolean changed = false;
            while (i.hasNext()) {
                if (!this.add(i.next())) continue;
                changed = true;
            }
            StoredIterator.close(i);
            this.commitAutoCommit(doAutoCommit);
            return changed;
        }
        catch (Exception e) {
            StoredIterator.close(i);
            throw this.handleException(e, doAutoCommit);
        }
    }

    public boolean removeAll(Collection coll) {
        return this.removeAll(coll, true);
    }

    public boolean retainAll(Collection coll) {
        return this.removeAll(coll, false);
    }

    private boolean removeAll(Collection coll, boolean ifExistsInColl) {
        Iterator i = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            boolean changed = false;
            i = this.iterator();
            while (i.hasNext()) {
                if (ifExistsInColl != coll.contains(i.next())) continue;
                i.remove();
                changed = true;
            }
            StoredIterator.close(i);
            this.commitAutoCommit(doAutoCommit);
            return changed;
        }
        catch (Exception e) {
            StoredIterator.close(i);
            throw this.handleException(e, doAutoCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object other) {
        if (other instanceof Collection) {
            Collection otherColl = StoredCollection.copyCollection(other);
            Iterator i = this.iterator();
            try {
                while (i.hasNext()) {
                    if (otherColl.remove(i.next())) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = otherColl.isEmpty();
                return bl;
            }
            finally {
                StoredIterator.close(i);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List toList() {
        ArrayList list = new ArrayList();
        Iterator i = this.iterator();
        try {
            while (i.hasNext()) {
                list.add(i.next());
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            StoredIterator.close(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        Iterator i = this.iterator();
        try {
            while (i.hasNext()) {
                if (buf.length() > 1) {
                    buf.append(',');
                }
                buf.append(i.next().toString());
            }
            buf.append(']');
            String string = buf.toString();
            return string;
        }
        finally {
            StoredIterator.close(i);
        }
    }

    public StoredIterator join(StoredContainer[] indices, Object[] indexKeys) {
        return this.join(indices, indexKeys, false);
    }

    public StoredIterator join(StoredContainer[] indices, Object[] indexKeys, boolean presorted) {
        try {
            DataView[] indexViews = new DataView[indices.length];
            for (int i = 0; i < indices.length; ++i) {
                indexViews[i] = indices[i].view;
            }
            DataCursor cursor = this.view.join(indexViews, indexKeys, presorted);
            return new StoredIterator(this, false, cursor);
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    final Object getFirstOrLast(boolean doGetFirst) {
        Object object;
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this.view, false);
            int err = cursor.get(null, null, doGetFirst ? Db.DB_FIRST : Db.DB_LAST, false);
            object = err == 0 ? this.makeIteratorData(null, cursor) : null;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeCursor(cursor);
                throw throwable;
            }
        }
        this.closeCursor(cursor);
        return object;
    }

    abstract Object makeIteratorData(StoredIterator var1, DataCursor var2) throws DbException, IOException;

    abstract boolean hasValues();

    boolean iterateDuplicates() {
        return true;
    }

    void checkIterAddAllowed() throws UnsupportedOperationException {
        if (!this.areDuplicatesAllowed()) {
            throw new UnsupportedOperationException("duplicates required");
        }
    }

    int getIndexOffset() {
        return 0;
    }

    private static Collection copyCollection(Object other) {
        if (other instanceof StoredCollection) {
            return ((StoredCollection)other).toList();
        }
        return new ArrayList((Collection)other);
    }
}

