// --------------------------------------------------------------------
// wm3d - A Flash Molecular Viewer
//
// Copyright (c) 2011-2013, tamanegi (tamanegi@users.sourceforge.jp)
// All rights reserved.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

/**
  container for default values for each <SCENE>
**/
class WMDefaults {
  /**
    Global default value for ATOM elements

    - radius: 4.0
    - color0: 0x00FF00
    - alpha: 1.0
    - quality: 3
    - ambient: 0.35
    - diffuse: 0.6
    - specular: 0.3
    - gloss: 30
    - shader "Phong"
  **/
  static public var gl_Atom:WMBase =
           new WMBase( 4.0, 0x00FF00, 0x00FF00, 1.0, 0.0, 3, 0.35, 0.6,
                       0.3, 30, "Phong" );
  /**
    Global default for BOND element

    - radius: 3.0
    - color0: 0x00FF00
    - color1: 0x00FF00
    - alpha: 1.0
    - offset: 0
    - quality: 2
    - ambient: 0.4
    - diffuse: 0.5
    - specular: 0.2
    - gloss: 30
    - shader: "Phong"
  **/
  static public var gl_Bond:WMBase =
           new WMBase( 3.0, 0x00FF00, 0x00FF00, 1.0, 0.0, 2, 0.4, 0.5,
                       0.2, 30, "Phong" );
  /**
    Whether spherical object is used intead for top and bottom faces.
    Default is true, VMD licorice like object is used.
  **/
  static public var gl_BondRound:Bool = true;
  /**
    Whether bottom and top faces are excluded. Default is false.
  **/
  static public var gl_BondExclude:Bool = false;
  /**
    Whether dashed line is used or not. Note that this value is integer.
    Default is 0. A bond will be drawn in (this value+1) of dashes.
  **/
  static public var gl_BondDashed:Int = 0;
  /**
    Global default for COILs.

    - radius: 3.0
    - color0: 0x00FF00
    - color1: 0x00FF00
    - alpha: 1.0
    - quality: 0
    - ambient: 0.3
    - diffuse: 0.6
    - specular: 0.3
    - gloss: 30
    - shader: "Phong"
  **/
  static public var gl_Coil:WMBase =
          new WMBase( 3.0, 0x00FF00, 0x00FF00, 1.0, 0.0, 0, 0.3, 0.6,
                      0.3, 30, "Phong" );
  /**
    Global default for RIBBONs

    - radius(width): 8.0
    - color0: 0xFF0000
    - color1: 0xFF0000
    - alpha: 1.0
    - ambient: 0.3
    - diffuse: 0.6
    - specular: 0.3
    - gloss: 30
    - shader: "Phong"
  **/
  static public var gl_Ribbon:WMBase =
          new WMBase( 8.0, 0xFF0000, 0xFF0000, 1.0, 0.0, 0, 0.3, 0.6,
                      0.3, 30, "Phong" );
  /**
    Global default for ribbon thickness. Default is 0.0.
  **/
  static public var gl_RibbonThickness:Float = 0.0;
  /**
    Global default for whether smooth ribbon is used. Default is false.
    Note that smooth ribbon is designed for beta-strand. You might not use
    for other purposes.
  **/
  static public var gl_RibbonSmoothing:Bool = false;
  /**
    Global default of LABELs

    - width(radius; window width): 130.0
    - color0(font color): 0xFFFFFF
    - alpha: 1.0
  **/
  static public var gl_Label:WMBase =
         new WMBase( 130.0, 0xFFFFFF, 0xFFFFFF, 1.0, 0.0, 0, 0.0, 0.0,
                     0.0, 30, "2DUV" );
  /**
    Global default for LABEL font. Default is "Arial"
  **/
  static public var gl_LabelFont:String = "Arial";
  /**
    Global default for LABEL font size. Default is 32.0.
  **/
  static public var gl_LabelSize:Float = 32.0;
  /**
    Global default for SHAPEs

    - color0: 0x00FF00
    - alpha: 1.0
    - ambient: 0.4
    - diffuse: 0.5
    - specular: 0.2
    - gloss: 30
    - shader: "Phong"
  **/
  static public var gl_Shape:WMBase =
         new WMBase( 0.0, 0x00FF00, 0x00FF00, 1.0, 0.0, 0, 0.4, 0.5,
                     0.2, 30, "Phong" );
  /**
    Global default for OBJ3Ds

    - radius: 1.0
    - color0: 0x00FF00
    - alpha: 1.0
    - quality: 3
    - ambient: 0.4
    - diffuse: 0.5
    - specular: 0.2
    - gloss: 30
    - shader: "Phong"
  **/
  static public var gl_Object3D:WMBase =
         new WMBase( 1.0, 0x00FF00, 0x00FF00, 1.0, 0.0, 3, 0.4, 0.5,
                     0.2, 30, "Phong" );
  /**
    Global default for OBJ3D type. Default is "cone"
  **/
  static public var gl_Object3DType:String = "cone";

  // ########################################################################

  /**
    <SCENE> local default of ATOMs
  **/
  @:isVar public var Atom( get, set ):WMBase;
    /**
      getter of `Atom`
    **/
    public function get_Atom():WMBase { return( Atom ); }
    /**
      setter of `Atom`
    **/
    public function set_Atom( a:WMBase ):WMBase {
      if ( Atom == null ) Atom = new WMBase();
      Atom.copyFrom( a );
      return( Atom );
    }

  /**
    <SCENE> local default for BONDs
  **/
  @:isVar public var Bond( get, set ):WMBase;
    /**
      getter for `Bond`
    **/
    public function get_Bond():WMBase { return( Bond ); }
    /**
      setter for `Bond`
    **/
    public function set_Bond( b:WMBase ):WMBase {
      if ( Bond == null ) Bond = new WMBase();
      Bond.copyFrom( b );
      return( Bond );
    }
  /**
    <SCENE> local default for face rounding of BOND
  **/
  @:isVar public var BondRound( get, set ):Bool;
    /**
      getter of `BondRound`
    **/
    public function get_BondRound():Bool { return( BondRound ); }
    /**
      setter of `BondRound`
    **/
    public function set_BondRound( f:Bool ):Bool {
      BondRound = f;
      return( BondRound );
    }
  /**
    <SCENE> local default for face excluding of BOND
  **/
  @:isVar public var BondExclude( get, set ):Bool;
    /**
      getter of `BondExclude`
    **/
    public function get_BondExclude():Bool { return( BondExclude ); }
    /**
      setter of `BondExclude`
    **/
    public function set_BondExclude( f:Bool ):Bool {
      BondExclude = f;
      return( BondExclude );
    }
  /**
    <SCENE> local default for dashing of BONDs
  **/
  @:isVar public var BondDashed( get, set ):Int;
    /**
      getter of `BondDashed`
    **/
    public function get_BondDashed():Int { return( BondDashed ); }
    /**
      setter of `BondDashed`
    **/
    public function set_BondDashed( d:Int ):Int {
      BondDashed = d;
      return( BondDashed );
    }

  /**
    <SCENE> local default of COILs
  **/
  @:isVar public var Coil( get, set ):WMBase;
    /**
      getter of `Coil`
    **/
    public function get_Coil():WMBase { return( Coil ); }
    /**
      setter of `Coil`
    **/
    public function set_Coil( c:WMBase ):WMBase {
      if ( Coil == null ) Coil = new WMBase();
      Coil.copyFrom( c );
      return( Coil );
    }

  /**
    <SCENE> local default for `Ribbon`
  **/
  @:isVar public var Ribbon( get, set ):WMBase;
    /**
      getter of `Ribbon`
    **/
    public function get_Ribbon():WMBase { return( Ribbon ); }
    /**
      setter of `Ribbon`
    **/
    public function set_Ribbon( r:WMBase ):WMBase {
      if ( Ribbon == null ) Ribbon = new WMBase();
      Ribbon.copyFrom( r );
      return( Ribbon );
    }
  /**
    <SCENE> local default for thickness of RIBBONs
  **/
  @:isVar public var RibbonThickness( get, set ):Float;
    /**
      getter of `RibbonThickness`
    **/
    public function get_RibbonThickness():Float { return( RibbonThickness ); }
    /**
      setter of `RibbonThickness`
    **/
    public function set_RibbonThickness( t:Float ):Float {
      RibbonThickness = t;
      return( RibbonThickness );
    }
  /**
    <SCENE> local default for smoothing of RIBBONs
  **/
  @:isVar public var RibbonSmoothing( get, set ):Bool;
    /**
      getter of `RibbonSmoothing`
    **/
    public function get_RibbonSmoothing():Bool { return( RibbonSmoothing ); }
    /**
      setter of `RibbonSmoothing`
    **/
    public function set_RibbonSmoothing( b:Bool ):Bool {
      RibbonSmoothing = b;
      return( RibbonSmoothing );
    }

  /**
    <SCENE> local default of LABELs
  **/
  @:isVar public var Label( get, set ):WMBase;
    /**
      getter of `Label`
    **/
    public function get_Label():WMBase { return( Label ); }
    /**
      setter of `Label`
    **/
    public function set_Label( l:WMBase ):WMBase {
      if ( Label == null ) Label = new WMBase();
      Label.copyFrom( l );
      return( Label );
    }
  /**
    <SCENE> local default of fontname for LABELs
  **/
  @:isVar public var LabelFont( get, set ):String;
    /**
      getter of `LabelFont`
    **/
    public function get_LabelFont():String { return( LabelFont ); }
    /**
      setter of `LabelFont`
    **/
    public function set_LabelFont( f:String ):String {
      LabelFont = f;
      return( LabelFont );
    }
  /**
    <SCENE> local default of font size for LABELs
  **/
  @:isVar public var LabelSize( get, set ):Float;
    /**
      getter of `LabelSize`
    **/
    public function get_LabelSize():Float { return( LabelSize ); }
    /**
      setter of `LabelSize`
    **/
    public function set_LabelSize( s:Float ):Float {
      LabelSize = s;
      return( LabelSize );
    }

  /**
    <SCENE> local default for SHAPEs
  **/
  @:isVar public var Shape( get, set ):WMBase;
    /**
      getter of `Shape`
    **/
    public function get_Shape():WMBase { return( Shape ); }
    /**
      setter of `Shape`
    **/
    public function set_Shape( s:WMBase ):WMBase {
      if ( Shape == null ) Shape = new WMBase();
      Shape.copyFrom( s );
      return( Shape );
    }

  /**
    <SCENE> local default for OBJ3Ds
  **/
  @:isVar public var Object3D( get, set ):WMBase;
    /**
      getter of `Object3D`
    **/
    public function get_Object3D():WMBase { return( Object3D ); }
    /**
      setter of `Object3D`
    **/
    public function set_Object3D( o:WMBase ):WMBase {
      if ( Object3D == null ) Object3D = new WMBase();
      Object3D.copyFrom( o );
        return( Object3D );
    }
  /**
    <SCENE> local default type of OBJ3Ds
  **/
  @:isVar public var Object3DType( get, set ):String;
    /**
      getter of `Object3DType`
    **/
    public function get_Object3DType():String { return( Object3DType ); }
    /**
      getter of `Object3DType`
    **/
    public function set_Object3DType( t:String ):String {
      Object3DType = t;
      return( Object3DType );
    }

  // ########################################################################

  /**
    Constructor.

    Initial value of SCENE local default values are copied from global
    default values.
  **/
  public function new() {
    Atom = new WMBase();
    Atom.copyFrom( gl_Atom );
    Bond = new WMBase();
    Bond.copyFrom( gl_Bond );
    BondRound = gl_BondRound;
    BondExclude = gl_BondExclude;
    BondDashed = gl_BondDashed;
    Ribbon = new WMBase();
    Ribbon.copyFrom( gl_Ribbon );
    RibbonThickness = gl_RibbonThickness;
    RibbonSmoothing = gl_RibbonSmoothing;
    Coil = new WMBase();
    Coil.copyFrom( gl_Coil );
    Label = new WMBase();
    Label.copyFrom( gl_Label );
    LabelFont = gl_LabelFont;
    LabelSize = gl_LabelSize;
    Shape = new WMBase();
    Shape.copyFrom( gl_Shape );
    Object3D = new WMBase();
    Object3D.copyFrom( gl_Object3D );
    Object3DType = gl_Object3DType;
  }
}
