// --------------------------------------------------------------------
// wm3d - A Flash Molecular Viewer
//
// Copyright (c) 2011-2013, tamanegi (tamanegi@users.sourceforge.jp)
// All rights reserved.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

// base class for objects in Watermelon

import flash.xml.XML;
import flash.xml.XMLList;
import flash.xml.XMLParser;

import flash.display3D.Context3D;

import flash.geom.Vector3D;
import flash.geom.Matrix3D;

/**
  Base Object of wm3d.

  See also `WMBase`.
**/

class WMObjBase extends WMBase {
  /**
    polygon of this object
  **/
  @:isVar public var _polygon( get, null ):Dynamic;
    /**
      getter of `_polygon`
    **/
    public function get__polygon():Dynamic { return( _polygon ); }

  // #################################################################

  /**
    Constructor.
  **/
  public function new( ?r:Float = 0.0,
                       ?c0:Int = 0x000000,
                       ?c1:Int = 0x000000,
                       ?a:Float = 1.0,
                       ?o:Float = 0.0,
                       ?q:Int = 0,
                       ?ag:Float = 0.3,
                       ?d:Float = 0.5,
                       ?sp:Float = 0.2,
                       ?gl:Float = 20.0,
                       ?sh:String = "Phong" ) {
    super( r, c0, c1, a, o, q, ag, d, sp, gl, sh );
  }

  /**
    initialize variables.
  **/
  public override function clear( ?def:WMDefaults = null ):Void {
    if ( def != null ) {
      copyFrom( def.Atom );
    } else {
      radius = 0.0;
      color0 = 0x000000;
      color1 = 0x000000;
      alpha = 1.0;
      offset = 0.0;
      quality = 0;
      ambient = 0.3;
      diffuse = 0.5;
      specular = 0.2;
      gloss = 20.0;
      shader = "Phong";
    }
    _polygon = null;
  }

  /**
    set shader variables (ambient, diffuse, specular, gloss) of `_polygon`
  **/
  public function setShaderParams():Void {
    if ( _polygon == null ) return;
    _polygon.ambient = ambient;
    _polygon.diffuse = diffuse;
    _polygon.specular = specular;
    _polygon.gloss = gloss;
  }

  /**
    draw `_polygon` on Stage3D

    - light: direction of light
    - cpos: position of camera
    - dcActive: is depth cueing is active (false)
    - dcCoeff: depth cueing coefficient (0.0)
    - dcLength: depth cueing characteristic length (0.0)
  **/
  public function draw( c:Context3D,
                        mpos:Matrix3D,
                        proj:Matrix3D,
                        voffset:Vector3D,
                        ?light:Vector3D = null,
                        ?cpos:Vector3D = null,
                        ?dcActive:Bool = false,
                        ?dcCoeff:Float = 0.0,
                        ?dcLength:Float = 0.0 ):Bool {
    if ( _polygon == null ) return( true );
    return( _polygon.draw( c, mpos, proj, voffset, light, cpos,
                           dcActive, dcCoeff, dcLength ) );
  }

  /**
    dump xml data as a string
  **/
  public function dump():String {
    var d:Dynamic = Type.getClass( this );
    var type:String = d.id;

    var str:String = " c=" + "\"" + color0 + "\"" +
                     " c0=" + "\"" + color0 + "\"" +
                     " c1=" + "\"" + color1 + "\"" +
                     " a=" + "\"" + alpha + "\"" +
                     " o=" + "\"" + offset + "\"" +
                     " am=" + "\"" + ambient + "\"" +
                     " s=" + "\"" + specular + "\"" +
                     " g=" + "\"" + gloss + "\"" +
                     " type=" + "\"" + type + "\"" +
                     " shader="+ "\"" + shader + "\"";
    return( _polygon.dump( str ) );
  }

  /**
    dispose shader instance of this instance; used when re-creating Context3D
  **/
  public function dispose():Void {
    if ( _polygon != null ) {
      _polygon.disposeShader();
    }
  }
}
