// --------------------------------------------------------------------
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

package tinylib.shaders;

import flash.geom.Vector3D;
import flash.geom.Matrix3D;

/**
  Gouraud Shader
**/

class GouraudShader extends hxsl.Shader {
  static public var id:String = "GouraudShader";
  static var SRC = {
    include( 'tinylib/shaders/srcNoUV.hxsl' );
    var color:Float3;
    function vertex( mpos:M44,
                     mproj:M44,
                     offset:Float3,
                     light:Float3,
                     ambient:Float,
                     diffuse:Float,
                     col:Float3 ) {
      out = input.pos.xyzw * mpos * mproj + [ offset.x, offset.y, offset.z, 0 ];
      var tnorm = normalize( input.norm * mpos );
      var lpow = diffuse * max( 0, dot( light, tnorm )) + ambient;
      color = col * lpow;
    }
    function fragment( alpha:Float ) {
      out = [ color.x, color.y, color.z, alpha ];
    }
  }
  public function setShaderVariables( mp:Matrix3D,
                                      mpro:Matrix3D,
                                      vo:Vector3D,
                                      lt:Vector3D,
                                      am:Float,
                                      df:Float,
                                      cl:Vector3D,
                                      a:Float ) {
    this.mpos = mp;
    this.mproj = mpro;
    this.offset = vo;
    this.light = lt;
    this.ambient = am;
    this.diffuse = df;
    this.col = cl;
    this.alpha = a;
  }
}
