/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSData;
import org.eclipse.swt.internal.cocoa.NSKeyedUnarchiver;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSPrintInfo;
import org.eclipse.swt.internal.cocoa.NSPrintOperation;
import org.eclipse.swt.internal.cocoa.NSPrinter;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.PMResolution;
import org.eclipse.swt.internal.cocoa.SWTPrinterView;
import org.eclipse.swt.printing.PrinterData;

public final class Printer
extends Device {
    PrinterData data;
    NSPrinter printer;
    NSPrintInfo printInfo;
    NSPrintOperation operation;
    NSView view;
    NSWindow window;
    boolean isGCCreated;
    static final String DRIVER = "Mac";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrinterData[] getPrinterList() {
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSArray nSArray = NSPrinter.printerNames();
            int n = (int)nSArray.count();
            PrinterData[] printerDataArray = new PrinterData[n];
            for (int i = 0; i < n; ++i) {
                NSString nSString = new NSString(nSArray.objectAtIndex(i));
                printerDataArray[i] = new PrinterData(DRIVER, nSString.getString());
            }
            PrinterData[] printerDataArray2 = printerDataArray;
            return printerDataArray2;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrinterData getDefaultPrinterData() {
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSPrinter nSPrinter = NSPrintInfo.defaultPrinter();
            if (nSPrinter == null) {
                PrinterData printerData = null;
                return printerData;
            }
            NSString nSString = nSPrinter.name();
            PrinterData printerData = new PrinterData(DRIVER, nSString.getString());
            return printerData;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public Printer() {
        this(null);
    }

    public Printer(PrinterData printerData) {
        super(Printer.checkNull(printerData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkDevice();
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSSize nSSize = this.printInfo.paperSize();
            NSRect nSRect = this.printInfo.imageablePageBounds();
            Point point = this.getDPI();
            Point point2 = this.getIndependentDPI();
            float f = this.scalingFactor();
            n = (int)((double)n - nSRect.x * (double)point.x / (double)point2.x / (double)f);
            n2 = (int)((double)n2 - nSRect.y * (double)point.y / (double)point2.y / (double)f);
            n3 = (int)((double)n3 + (nSSize.width - nSRect.width) * (double)point.x / (double)point2.x / (double)f);
            n4 = (int)((double)n4 + (nSSize.height - nSRect.height) * (double)point.y / (double)point2.y / (double)f);
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            return rectangle;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void create(DeviceData deviceData) {
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSString nSString;
            NSObject nSObject;
            NSApplication.sharedApplication();
            this.data = (PrinterData)deviceData;
            if (this.data.otherData != null) {
                nSObject = NSData.dataWithBytes(this.data.otherData, this.data.otherData.length);
                this.printInfo = new NSPrintInfo(NSKeyedUnarchiver.unarchiveObjectWithData((NSData)nSObject).id);
            } else {
                this.printInfo = NSPrintInfo.sharedPrintInfo();
            }
            this.printInfo.retain();
            this.printer = NSPrinter.printerWithName(NSString.stringWith(this.data.name));
            if (this.printer != null) {
                this.printer.retain();
                this.printInfo.setPrinter(this.printer);
            }
            if (this.data.duplex != -1) {
                long l = this.printInfo.PMPrintSettings();
                int n = this.data.duplex == 2 ? 3 : (this.data.duplex == 1 ? 2 : 1);
                OS.PMSetDuplex(l, n);
            }
            this.printInfo.updateFromPMPrintSettings();
            nSObject = this.printInfo.dictionary();
            if (this.data.collate) {
                ((NSMutableDictionary)nSObject).setValue(NSNumber.numberWithBool(this.data.collate), OS.NSPrintMustCollate);
            }
            if (this.data.copyCount != 1) {
                ((NSMutableDictionary)nSObject).setValue(NSNumber.numberWithInt(this.data.copyCount), OS.NSPrintCopies);
            }
            ((NSMutableDictionary)nSObject).setValue(NSNumber.numberWithInt(this.data.orientation == 2 ? 1 : 0), OS.NSPrintOrientation);
            if (this.data.printToFile) {
                ((NSMutableDictionary)nSObject).setValue(OS.NSPrintSaveJob, OS.NSPrintJobDisposition);
                if (this.data.fileName != null) {
                    ((NSMutableDictionary)nSObject).setValue(NSString.stringWith(this.data.fileName), OS.NSPrintSavePath);
                }
            }
            if ((nSString = this.printInfo.jobDisposition()).isEqual(new NSString(OS.NSPrintPreviewJob()))) {
                this.printInfo.setJobDisposition(nSString);
            }
            NSRect nSRect = new NSRect();
            this.window = (NSWindow)new NSWindow().alloc();
            this.window.initWithContentRect(nSRect, 0L, 2L, false);
            String string = "SWTPrinterView";
            if (OS.objc_lookUpClass(string) == 0L) {
                long l = OS.objc_allocateClassPair(OS.class_NSView, string, 0L);
                OS.class_addMethod(l, OS.sel_isFlipped, OS.isFlipped_CALLBACK(), "@:");
                OS.objc_registerClassPair(l);
            }
            this.view = (NSView)new SWTPrinterView().alloc();
            this.view.initWithFrame(nSRect);
            this.window.setContentView(this.view);
            this.operation = NSPrintOperation.printOperationWithView(this.view, this.printInfo);
            this.operation.retain();
            this.operation.setShowsPrintPanel(false);
            this.operation.setShowsProgressPanel(false);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    @Override
    protected void destroy() {
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (this.printer != null) {
                this.printer.release();
            }
            if (this.printInfo != null) {
                this.printInfo.release();
            }
            if (this.view != null) {
                this.view.release();
            }
            if (this.window != null) {
                this.window.release();
            }
            if (this.operation != null) {
                this.operation.release();
            }
            this.printer = null;
            this.printInfo = null;
            this.view = null;
            this.window = null;
            this.operation = null;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long internal_new_GC(GCData gCData) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (gCData != null) {
                if (this.isGCCreated) {
                    SWT.error(5);
                }
                gCData.device = this;
                gCData.background = this.getSystemColor((int)1).handle;
                gCData.foreground = this.getSystemColor((int)2).handle;
                gCData.font = this.getSystemFont();
                float f = this.scalingFactor();
                Point point = this.getDPI();
                Point point2 = this.getIndependentDPI();
                NSSize nSSize = this.printInfo.paperSize();
                nSSize.width = nSSize.width * (double)(point.x / point2.x) / (double)f;
                nSSize.height = nSSize.height * (double)point.y / (double)point2.y / (double)f;
                gCData.size = nSSize;
                this.isGCCreated = true;
            }
            this.createContext();
            long l = this.operation.context().id;
            return l;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    @Override
    protected void init() {
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            super.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    @Override
    public void internal_dispose_GC(long l, GCData gCData) {
        if (gCData != null) {
            this.isGCCreated = false;
        }
    }

    @Override
    protected void release() {
        super.release();
    }

    float scalingFactor() {
        NSNumber nSNumber = new NSNumber(this.printInfo.dictionary().objectForKey(OS.NSPrintScalingFactor));
        return nSNumber.floatValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startJob(String string) {
        this.checkDevice();
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (string != null && string.length() != 0) {
                this.operation.setJobTitle(NSString.stringWith(string));
            }
            if (this.createContext()) {
                this.view.beginDocument();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    boolean createContext() {
        if (this.operation.context() != null) {
            return true;
        }
        this.printInfo.setUpPrintOperationDefaultValues();
        NSPrintOperation.setCurrentOperation(this.operation);
        return this.operation.createContext() != null;
    }

    public void endJob() {
        this.checkDevice();
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.view.endDocument();
            this.operation.deliverResult();
            this.operation.destroyContext();
            this.operation.cleanUpOperation();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public void cancelJob() {
        this.checkDevice();
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.operation.destroyContext();
            this.operation.cleanUpOperation();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    static DeviceData checkNull(PrinterData printerData) {
        if (printerData == null) {
            printerData = new PrinterData();
        }
        if (printerData.driver == null || printerData.name == null) {
            PrinterData printerData2 = Printer.getDefaultPrinterData();
            if (printerData2 == null) {
                SWT.error(2);
            }
            printerData.driver = printerData2.driver;
            printerData.name = printerData2.name;
        }
        return printerData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startPage() {
        this.checkDevice();
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            float f = this.scalingFactor();
            NSSize nSSize = this.printInfo.paperSize();
            nSSize.width /= (double)f;
            nSSize.height /= (double)f;
            NSRect nSRect = new NSRect();
            nSRect.width = nSSize.width;
            nSRect.height = nSSize.height;
            this.view.beginPageInRect(nSRect, new NSPoint());
            NSRect nSRect2 = this.printInfo.imageablePageBounds();
            nSRect2.x /= (double)f;
            nSRect2.y /= (double)f;
            nSRect2.width /= (double)f;
            nSRect2.height /= (double)f;
            NSBezierPath.bezierPathWithRect(nSRect2).setClip();
            NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
            nSAffineTransform.translateXBy(nSRect2.x, nSRect2.y);
            Point point = this.getDPI();
            Point point2 = this.getIndependentDPI();
            nSAffineTransform.scaleXBy((float)point2.x / (float)point.x, (float)point2.y / (float)point.y);
            nSAffineTransform.concat();
            this.operation.context().saveGraphicsState();
            boolean bl = true;
            return bl;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public void endPage() {
        this.checkDevice();
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.operation.context().restoreGraphicsState();
            this.view.endPage();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point getDPI() {
        this.checkDevice();
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            short[] sArray;
            long l;
            long l2 = this.printInfo.PMPrintSession();
            long[] lArray = new long[1];
            long l3 = OS.PMSessionGetCurrentPrinter(l2, lArray);
            if (l3 == 0L && OS.PMSessionGetDestinationType(l2, l = this.printInfo.PMPrintSettings(), sArray = new short[1]) == 0L && sArray[0] == 1) {
                Object object;
                PMResolution pMResolution = new PMResolution();
                if (OS.PMPrinterGetOutputResolution(lArray[0], l, pMResolution) != 0L && OS.PMPrinterGetPrinterResolutionCount(lArray[0], object = new int[1]) == 0L) {
                    PMResolution pMResolution2 = new PMResolution();
                    pMResolution2.vRes = 300.0;
                    pMResolution2.hRes = 300.0;
                    for (int i = 1; i <= object[0]; ++i) {
                        if (OS.PMPrinterGetIndexedPrinterResolution(lArray[0], i, pMResolution2) != 0L || !(pMResolution2.vRes > pMResolution.vRes) || !(pMResolution2.hRes > pMResolution.hRes)) continue;
                        pMResolution = pMResolution2;
                    }
                }
                object = new Point((int)pMResolution.hRes, (int)pMResolution.vRes);
                return object;
            }
            Point point = this.getIndependentDPI();
            return point;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    Point getIndependentDPI() {
        return super.getDPI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rectangle getBounds() {
        this.checkDevice();
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSSize nSSize = this.printInfo.paperSize();
            float f = this.scalingFactor();
            Point point = this.getDPI();
            Point point2 = this.getIndependentDPI();
            Rectangle rectangle = new Rectangle(0, 0, (int)(nSSize.width * (double)point.x / (double)point2.x / (double)f), (int)(nSSize.height * (double)point.y / (double)point2.y / (double)f));
            return rectangle;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rectangle getClientArea() {
        this.checkDevice();
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            float f = this.scalingFactor();
            NSRect nSRect = this.printInfo.imageablePageBounds();
            Point point = this.getDPI();
            Point point2 = this.getIndependentDPI();
            Rectangle rectangle = new Rectangle(0, 0, (int)(nSRect.width * (double)point.x / (double)point2.x / (double)f), (int)(nSRect.height * (double)point.y / (double)point2.y / (double)f));
            return rectangle;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public PrinterData getPrinterData() {
        this.checkDevice();
        return this.data;
    }
}

