/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSButtonCell;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public class Decorations
extends Canvas {
    Image image;
    Image[] images = new Image[0];
    Menu menuBar;
    String text = "";
    boolean minimized;
    boolean maximized;
    Control savedFocus;
    Button defaultButton;

    Decorations() {
    }

    public Decorations(Composite composite, int n) {
        super(composite, Decorations.checkStyle(n));
    }

    static int checkStyle(int n) {
        if ((n & 8) != 0) {
            n &= 0xFFFFF30F;
        } else if ((n & 0x800000) != 0) {
            n |= 0x20;
        }
        if ((n & 0x4C0) != 0) {
            n |= 0x20;
        }
        return n;
    }

    void bringToTop(boolean bl) {
        this.moveAbove(null);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    int compare(ImageData imageData, ImageData imageData2) {
        if (imageData.width == imageData2.width && imageData.height == imageData2.height) {
            int n = imageData.getTransparencyType();
            int n2 = imageData2.getTransparencyType();
            if (n == 1) {
                return -1;
            }
            if (n2 == 1) {
                return 1;
            }
            if (n == 2) {
                return -1;
            }
            if (n2 == 2) {
                return 1;
            }
            if (n == 4) {
                return -1;
            }
            if (n2 == 4) {
                return 1;
            }
            return 0;
        }
        return imageData.width > imageData2.width || imageData.height > imageData2.height ? -1 : 1;
    }

    @Override
    Widget computeTabGroup() {
        return this;
    }

    @Override
    Control computeTabRoot() {
        return this;
    }

    void fixDecorations(Decorations decorations, Control control, Menu[] menuArray) {
        if (this == decorations) {
            return;
        }
        if (control == this.savedFocus) {
            this.savedFocus = null;
        }
        if (control == this.defaultButton) {
            this.defaultButton = null;
        }
        if (menuArray == null) {
            return;
        }
        Menu menu = control.menu;
        if (menu != null) {
            for (int i = 0; i < menuArray.length; ++i) {
                if (menuArray[i] != menu) continue;
                control.setMenu(null);
                return;
            }
            menu.fixMenus(decorations);
        }
    }

    public Button getDefaultButton() {
        this.checkWidget();
        if (this.defaultButton != null && this.defaultButton.isDisposed()) {
            return null;
        }
        return this.defaultButton;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Image[] getImages() {
        this.checkWidget();
        if (this.images == null) {
            return new Image[0];
        }
        Image[] imageArray = new Image[this.images.length];
        System.arraycopy(this.images, 0, imageArray, 0, this.images.length);
        return imageArray;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return this.maximized;
    }

    public Menu getMenuBar() {
        this.checkWidget();
        return this.menuBar;
    }

    public boolean getMinimized() {
        this.checkWidget();
        return this.minimized;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    @Override
    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    @Override
    boolean isTabGroup() {
        return true;
    }

    @Override
    boolean isTabItem() {
        return false;
    }

    @Override
    Decorations menuShell() {
        return this;
    }

    @Override
    void releaseChildren(boolean bl) {
        if (this.menuBar != null) {
            this.menuBar.dispose();
            this.menuBar = null;
        }
        Display display = this.display;
        super.releaseChildren(bl);
        Menu[] menuArray = display.getMenus(this);
        if (menuArray != null) {
            for (int i = 0; i < menuArray.length; ++i) {
                Menu menu = menuArray[i];
                if (menu == null || menu.isDisposed()) continue;
                menu.dispose();
            }
            menuArray = null;
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
        this.images = null;
        this.savedFocus = null;
        this.defaultButton = null;
    }

    @Override
    void reskinChildren(int n) {
        Menu[] menuArray;
        if (this.menuBar != null) {
            this.menuBar.reskin(n);
        }
        if ((menuArray = this.display.getMenus(this)) != null) {
            for (int i = 0; i < menuArray.length; ++i) {
                Menu menu = menuArray[i];
                if (menu == null) continue;
                menu.reskin(n);
            }
        }
        super.reskinChildren(n);
    }

    boolean restoreFocus() {
        if (this.savedFocus != null && this.savedFocus.isDisposed()) {
            this.savedFocus = null;
        }
        if (this.savedFocus == null) {
            return false;
        }
        return this.savedFocus.forceFocus();
    }

    void saveFocus() {
        Control control = this.display._getFocusControl(this.view.window());
        if (control != null && control != this && this == control.menuShell()) {
            this.setSavedFocus(control);
        }
    }

    public void setDefaultButton(Button button) {
        this.checkWidget();
        if (button != null) {
            if (button.isDisposed()) {
                this.error(5);
            }
            if (button.menuShell() != this) {
                this.error(32);
            }
            if ((button.style & 8) == 0) {
                return;
            }
        }
        if (button == this.defaultButton) {
            return;
        }
        this.defaultButton = button;
        NSButtonCell nSButtonCell = null;
        if (this.defaultButton != null && (this.defaultButton.style & 8) != 0) {
            nSButtonCell = new NSButtonCell(((NSButton)this.defaultButton.view).cell());
        }
        this.view.window().setDefaultButtonCell(nSButtonCell);
        this.display.updateDefaultButton();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        if (this.parent != null) {
            return;
        }
        if (this.display.dockImage == null) {
            this.display.application.setApplicationIconImage(image != null ? image.handle : null);
        }
    }

    public void setImages(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(5);
        }
        for (int i = 0; i < imageArray.length; ++i) {
            if (imageArray[i] != null && !imageArray[i].isDisposed()) continue;
            this.error(5);
        }
        this.images = imageArray;
        if (this.parent != null) {
            return;
        }
        if (this.display.dockImage == null) {
            if (imageArray != null && imageArray.length > 1) {
                Image[] imageArray2 = new Image[imageArray.length];
                System.arraycopy(imageArray, 0, imageArray2, 0, imageArray.length);
                this.sort(imageArray2);
                imageArray = imageArray2;
            }
            if (imageArray != null && imageArray.length > 0) {
                this.display.application.setApplicationIconImage(imageArray[0].handle);
            } else {
                this.display.application.setApplicationIconImage(null);
            }
        }
    }

    public void setMaximized(boolean bl) {
        this.checkWidget();
        this.maximized = bl;
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        this.menuBar = menu;
    }

    public void setMinimized(boolean bl) {
        this.checkWidget();
        this.minimized = bl;
    }

    void setSavedFocus(Control control) {
        this.savedFocus = control;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
    }

    void sort(Image[] imageArray) {
        int n;
        int n2 = imageArray.length;
        if (n2 <= 1) {
            return;
        }
        ImageData[] imageDataArray = new ImageData[n2];
        for (n = 0; n < n2; ++n) {
            imageDataArray[n] = imageArray[n].getImageData();
        }
        for (n = n2 / 2; n > 0; n /= 2) {
            for (int i = n; i < n2; ++i) {
                for (int j = i - n; j >= 0; j -= n) {
                    if (this.compare(imageDataArray[j], imageDataArray[j + n]) < 0) continue;
                    Image image = imageArray[j];
                    imageArray[j] = imageArray[j + n];
                    imageArray[j + n] = image;
                    ImageData imageData = imageDataArray[j];
                    imageDataArray[j] = imageDataArray[j + n];
                    imageDataArray[j + n] = imageData;
                }
            }
        }
    }

    @Override
    boolean traverseItem(boolean bl) {
        return false;
    }

    @Override
    boolean traverseReturn() {
        if (this.defaultButton == null || this.defaultButton.isDisposed()) {
            return false;
        }
        if (!this.defaultButton.isVisible() || !this.defaultButton.isEnabled()) {
            return false;
        }
        this.defaultButton.click();
        return true;
    }
}

