/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.OS;

public final class Cursor
extends Resource {
    public int handle;
    boolean isIcon;
    static final byte[] HAND_SOURCE = new byte[]{-7, -1, -1, -1, -16, -1, -1, -1, -16, -1, -1, -1, -16, -1, -1, -1, -16, 63, -1, -1, -16, 7, -1, -1, -16, 3, -1, -1, -16, 0, -1, -1, 16, 0, 127, -1, 0, 0, 127, -1, -128, 0, 127, -1, -64, 0, 127, -1, -32, 0, 127, -1, -16, 0, 127, -1, -8, 0, -1, -1, -4, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    static final byte[] HAND_MASK = new byte[]{0, 0, 0, 0, 6, 0, 0, 0, 6, 0, 0, 0, 6, 0, 0, 0, 6, 0, 0, 0, 6, -64, 0, 0, 6, -40, 0, 0, 6, -40, 0, 0, 7, -37, 0, 0, 103, -5, 0, 0, 63, -1, 0, 0, 31, -1, 0, 0, 15, -1, 0, 0, 7, -1, 0, 0, 3, -2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    Cursor(Device device) {
        super(device);
    }

    public Cursor(Device device, int n) {
        super(device);
        int n2 = 0;
        switch (n) {
            case 21: {
                n2 = 32649;
                break;
            }
            case 0: {
                n2 = 32512;
                break;
            }
            case 1: {
                n2 = 32514;
                break;
            }
            case 2: {
                n2 = 32515;
                break;
            }
            case 3: {
                n2 = 32650;
                break;
            }
            case 4: {
                n2 = 32651;
                break;
            }
            case 5: {
                n2 = 32646;
                break;
            }
            case 6: {
                n2 = 32643;
                break;
            }
            case 7: {
                n2 = 32645;
                break;
            }
            case 8: {
                n2 = 32642;
                break;
            }
            case 9: {
                n2 = 32644;
                break;
            }
            case 10: {
                n2 = 32645;
                break;
            }
            case 11: {
                n2 = 32645;
                break;
            }
            case 12: {
                n2 = 32644;
                break;
            }
            case 13: {
                n2 = 32644;
                break;
            }
            case 14: {
                n2 = 32643;
                break;
            }
            case 15: {
                n2 = 32642;
                break;
            }
            case 16: {
                n2 = 32643;
                break;
            }
            case 17: {
                n2 = 32642;
                break;
            }
            case 18: {
                n2 = 32516;
                break;
            }
            case 19: {
                n2 = 32513;
                break;
            }
            case 20: {
                n2 = 32648;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.handle = OS.LoadCursor(0, n2);
        if (this.handle == 0 && n == 21) {
            int n3 = OS.GetSystemMetrics(13);
            int n4 = OS.GetSystemMetrics(14);
            if (n3 == 32 && n4 == 32) {
                int n5 = OS.GetModuleHandle(null);
                if (OS.IsWinCE) {
                    SWT.error(20);
                }
                this.handle = OS.CreateCursor(n5, 5, 0, 32, 32, HAND_SOURCE, HAND_MASK);
            }
        }
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.init();
    }

    public Cursor(Device device, ImageData imageData, ImageData imageData2, int n, int n2) {
        super(device);
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            if (imageData.getTransparencyType() != 2) {
                SWT.error(4);
            }
            imageData2 = imageData.getTransparencyMask();
        }
        if (imageData2.width != imageData.width || imageData2.height != imageData.height) {
            SWT.error(5);
        }
        if (n >= imageData.width || n < 0 || n2 >= imageData.height || n2 < 0) {
            SWT.error(5);
        }
        imageData2 = ImageData.convertMask(imageData2);
        imageData = ImageData.convertMask(imageData);
        byte[] byArray = ImageData.convertPad(imageData.data, imageData.width, imageData.height, imageData.depth, imageData.scanlinePad, 2);
        byte[] byArray2 = ImageData.convertPad(imageData2.data, imageData2.width, imageData2.height, imageData2.depth, imageData2.scanlinePad, 2);
        int n3 = OS.GetModuleHandle(null);
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        this.handle = OS.CreateCursor(n3, n, n2, imageData.width, imageData.height, byArray, byArray2);
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.init();
    }

    public Cursor(Device device, ImageData imageData, int n, int n2) {
        super(device);
        Object object;
        if (imageData == null) {
            SWT.error(4);
        }
        if (n >= imageData.width || n < 0 || n2 >= imageData.height || n2 < 0) {
            SWT.error(5);
        }
        int n3 = 0;
        int n4 = 0;
        if (imageData.maskData == null && imageData.transparentPixel == -1 && (imageData.alpha != -1 || imageData.alphaData != null)) {
            Object object2;
            object = imageData.palette;
            PaletteData paletteData = new PaletteData(65280, 0xFF0000, -16777216);
            ImageData imageData2 = new ImageData(imageData.width, imageData.height, 32, paletteData);
            if (((PaletteData)object).isDirect) {
                ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, imageData.width, imageData.height, ((PaletteData)object).redMask, ((PaletteData)object).greenMask, ((PaletteData)object).blueMask, 255, null, 0, 0, 0, imageData2.data, imageData2.depth, imageData2.bytesPerLine, imageData2.getByteOrder(), 0, 0, imageData2.width, imageData2.height, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, false, false);
            } else {
                object2 = ((PaletteData)object).getRGBs();
                int n5 = ((RGB[])object2).length;
                byte[] byArray = new byte[n5];
                byte[] byArray2 = new byte[n5];
                byte[] byArray3 = new byte[n5];
                for (int i = 0; i < ((RGB[])object2).length; ++i) {
                    RGB rGB = object2[i];
                    if (rGB == null) continue;
                    byArray[i] = (byte)rGB.red;
                    byArray2[i] = (byte)rGB.green;
                    byArray3[i] = (byte)rGB.blue;
                }
                ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, imageData.width, imageData.height, byArray, byArray2, byArray3, 255, null, 0, 0, 0, imageData2.data, imageData2.depth, imageData2.bytesPerLine, imageData2.getByteOrder(), 0, 0, imageData2.width, imageData2.height, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, false, false);
            }
            n3 = Image.createDIB(imageData.width, imageData.height, 32);
            if (n3 == 0) {
                SWT.error(2);
            }
            object2 = new BITMAP();
            OS.GetObject(n3, BITMAP.sizeof, (BITMAP)object2);
            byte[] byArray = imageData2.data;
            if (imageData.alpha != -1) {
                for (int i = 3; i < byArray.length; i += 4) {
                    byArray[i] = (byte)imageData.alpha;
                }
            } else if (imageData.alphaData != null) {
                int n6 = 3;
                int n7 = 0;
                while (n6 < byArray.length) {
                    byArray[n6] = imageData.alphaData[n7];
                    n6 += 4;
                    ++n7;
                }
            }
            OS.MoveMemory(object2.bmBits, byArray, byArray.length);
            n4 = OS.CreateBitmap(imageData.width, imageData.height, 1, 1, new byte[((imageData.width + 7) / 8 + 3) / 4 * 4 * imageData.height]);
            if (n4 == 0) {
                SWT.error(2);
            }
        } else {
            object = imageData.getTransparencyMask();
            int[] nArray = Image.init(this.device, null, imageData, (ImageData)object);
            n3 = nArray[0];
            n4 = nArray[1];
        }
        object = new ICONINFO();
        ((ICONINFO)object).fIcon = false;
        ((ICONINFO)object).hbmColor = n3;
        ((ICONINFO)object).hbmMask = n4;
        ((ICONINFO)object).xHotspot = n;
        ((ICONINFO)object).yHotspot = n2;
        this.handle = OS.CreateIconIndirect((ICONINFO)object);
        OS.DeleteObject(n3);
        OS.DeleteObject(n4);
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.isIcon = true;
        this.init();
    }

    @Override
    void destroy() {
        if (this.isIcon) {
            OS.DestroyIcon(this.handle);
        } else if (!OS.IsWinCE) {
            OS.DestroyCursor(this.handle);
        }
        this.handle = 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cursor)) {
            return false;
        }
        Cursor cursor = (Cursor)object;
        return this.device == cursor.device && this.handle == cursor.handle;
    }

    public int hashCode() {
        return this.handle;
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Cursor {*DISPOSED*}";
        }
        return "Cursor {" + this.handle + "}";
    }

    public static Cursor win32_new(Device device, int n) {
        Cursor cursor = new Cursor(device);
        cursor.handle = n;
        return cursor;
    }
}

