/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.DRAWITEMSTRUCT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class Label
extends Control {
    String text = "";
    Image image;
    static final int MARGIN = 4;
    static boolean IMAGE_AND_TEXT = false;
    static final int LabelProc;
    static final TCHAR LabelClass;

    public Label(Composite composite, int n) {
        super(composite, Label.checkStyle(n));
    }

    @Override
    int callWindowProc(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            return 0;
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 1)) {
            switch (n2) {
                case 515: {
                    return OS.DefWindowProc(n, n2, n3, n4);
                }
            }
        }
        return OS.CallWindowProc(LabelProc, n, n2, n3, n4);
    }

    static int checkStyle(int n) {
        if (((n |= 0x80000) & 2) != 0) {
            n = Label.checkBits(n, 512, 256, 0, 0, 0, 0);
            return Label.checkBits(n, 8, 4, 32, 0, 0, 0);
        }
        return Label.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        boolean bl2;
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getBorderWidthInPixels();
        if ((this.style & 2) != 0) {
            int n6 = OS.GetSystemMetrics(5);
            if ((this.style & 0x100) != 0) {
                n3 = 64;
                n4 = n6 * 2;
            } else {
                n3 = n6 * 2;
                n4 = 64;
            }
            if (n != -1) {
                n3 = n;
            }
            if (n2 != -1) {
                n4 = n2;
            }
            return new Point(n3 += n5 * 2, n4 += n5 * 2);
        }
        int n7 = OS.GetWindowLong(this.handle, -16);
        boolean bl3 = true;
        boolean bl4 = bl2 = (n7 & 0xD) == 13;
        if (bl2 && this.image != null) {
            Rectangle rectangle = this.image.getBoundsInPixels();
            n3 += rectangle.width;
            n4 += rectangle.height;
            if (IMAGE_AND_TEXT) {
                if (this.text.length() != 0) {
                    n3 += 4;
                }
            } else {
                bl3 = false;
            }
        }
        if (bl3) {
            int n8 = OS.GetDC(this.handle);
            int n9 = OS.SendMessage(this.handle, 49, 0, 0);
            int n10 = OS.SelectObject(n8, n9);
            int n11 = OS.GetWindowTextLength(this.handle);
            if (n11 == 0) {
                TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                OS.GetTextMetrics(n8, tEXTMETRIC);
                n4 = Math.max(n4, tEXTMETRIC.tmHeight);
            } else {
                RECT rECT = new RECT();
                int n12 = 9280;
                if ((this.style & 0x40) != 0 && n != -1) {
                    n12 |= 0x10;
                    rECT.right = Math.max(0, n - n3);
                }
                TCHAR tCHAR = new TCHAR(this.getCodePage(), n11 + 1);
                OS.GetWindowText(this.handle, tCHAR, n11 + 1);
                OS.DrawText(n8, tCHAR, n11, rECT, n12);
                n3 += rECT.right - rECT.left;
                n4 = Math.max(n4, rECT.bottom - rECT.top);
            }
            if (n9 != 0) {
                OS.SelectObject(n8, n10);
            }
            OS.ReleaseDC(this.handle, n8);
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        n3 += n5 * 2;
        n4 += n5 * 2;
        if (OS.IsWinCE && !bl2) {
            n3 += 2;
        }
        return new Point(n3, n4);
    }

    @Override
    void createHandle() {
        super.createHandle();
        this.state |= 0x100;
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return 0;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return "";
        }
        return this.text;
    }

    @Override
    boolean mnemonicHit(char c) {
        Control control = this;
        while (control.parent != null) {
            int n;
            Control[] controlArray = control.parent._getChildren();
            for (n = 0; n < controlArray.length && controlArray[n] != control; ++n) {
            }
            if (++n < controlArray.length && controlArray[n].setFocus()) {
                return true;
            }
            control = control.parent;
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char c) {
        char c2 = this.findMnemonic(this.getText());
        if (c2 == '\u0000') {
            return false;
        }
        return Character.toUpperCase(c) == Character.toUpperCase(c2);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.text = null;
        this.image = null;
    }

    @Override
    int resolveTextDirection() {
        return (this.style & 2) != 0 ? 0 : BidiUtil.resolveTextDirection(this.text);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if ((n & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        int n2 = OS.GetWindowLong(this.handle, -16);
        if ((n2 & 0xD) != 13) {
            n2 &= 0xFFFFFFF0;
            if ((this.style & 0x4000) != 0) {
                n2 = (this.style & 0x40) != 0 ? (n2 |= 0) : (n2 |= 0xC);
            }
            if ((this.style & 0x1000000) != 0) {
                n2 |= 1;
            }
            if ((this.style & 0x20000) != 0) {
                n2 |= 2;
            }
            OS.SetWindowLong(this.handle, -16, n2);
        }
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        int n = OS.GetWindowLong(this.handle, -16);
        if ((n & 0xD) != 13) {
            n &= 0xFFFFFFF0;
            OS.SetWindowLong(this.handle, -16, n |= 0xD);
        }
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        if (this.image == null || !IMAGE_AND_TEXT) {
            int n;
            int n2 = n = OS.GetWindowLong(this.handle, -16);
            n2 &= 0xFFFFFFF2;
            if ((this.style & 0x4000) != 0) {
                n2 = (this.style & 0x40) != 0 ? (n2 |= 0) : (n2 |= 0xC);
            }
            if ((this.style & 0x1000000) != 0) {
                n2 |= 1;
            }
            if ((this.style & 0x20000) != 0) {
                n2 |= 2;
            }
            if (n != n2) {
                OS.SetWindowLong(this.handle, -16, n2);
            }
        }
        string = Display.withCrLf(string);
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
        OS.SetWindowText(this.handle, tCHAR);
        if ((this.state & 0x400000) != 0) {
            this.updateTextDirection(0x6000000);
        }
        if (OS.COMCTL32_MAJOR < 6 && this.findImageControl() != null) {
            OS.InvalidateRect(this.handle, null, true);
        }
    }

    @Override
    int widgetExtStyle() {
        int n = super.widgetExtStyle() & 0xFFFFFDFF;
        if ((this.style & 0x800) != 0) {
            return n | 0x20000;
        }
        return n;
    }

    @Override
    int widgetStyle() {
        int n = super.widgetStyle() | 0x100;
        if ((this.style & 2) != 0) {
            return n | 0xD;
        }
        if (OS.WIN32_VERSION >= OS.VERSION(5, 0) && (this.style & 0x40) != 0) {
            n |= 0x2000;
        }
        if ((this.style & 0x1000000) != 0) {
            return n | 1;
        }
        if ((this.style & 0x20000) != 0) {
            return n | 2;
        }
        if ((this.style & 0x40) != 0) {
            return n | 0;
        }
        return n | 0xC;
    }

    @Override
    TCHAR windowClass() {
        return LabelClass;
    }

    @Override
    int windowProc() {
        return LabelProc;
    }

    @Override
    LRESULT WM_ERASEBKGND(int n, int n2) {
        LRESULT lRESULT = super.WM_ERASEBKGND(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n3 = OS.GetWindowLong(this.handle, -16);
        if ((n3 & 0xD) == 13) {
            return LRESULT.ONE;
        }
        if (OS.COMCTL32_MAJOR < 6 && this.findImageControl() != null) {
            this.drawBackground(n);
            return LRESULT.ONE;
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SIZE(int n, int n2) {
        LRESULT lRESULT = super.WM_SIZE(n, n2);
        if (this.isDisposed()) {
            return lRESULT;
        }
        if ((this.style & 2) != 0) {
            OS.InvalidateRect(this.handle, null, true);
            return lRESULT;
        }
        int n3 = OS.GetWindowLong(this.handle, -16);
        if ((n3 & 0xD) == 13) {
            OS.InvalidateRect(this.handle, null, true);
            return lRESULT;
        }
        if ((n3 & 0xC) != 12) {
            OS.InvalidateRect(this.handle, null, true);
            return lRESULT;
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_UPDATEUISTATE(int n, int n2) {
        boolean bl;
        LRESULT lRESULT = super.WM_UPDATEUISTATE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        boolean bl2 = bl = this.findImageControl() != null;
        if (!bl && (this.state & 0x100) != 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            boolean bl3 = bl = this.findThemeControl() != null;
        }
        if (bl) {
            OS.InvalidateRect(this.handle, null, false);
            int n3 = OS.DefWindowProc(this.handle, 296, n, n2);
            return new LRESULT(n3);
        }
        return lRESULT;
    }

    @Override
    LRESULT wmColorChild(int n, int n2) {
        int n3;
        LRESULT lRESULT = super.wmColorChild(n, n2);
        if (OS.COMCTL32_MAJOR < 6 && ((n3 = OS.GetWindowLong(this.handle, -16)) & 0xD) != 13 && this.findImageControl() != null) {
            OS.SetBkMode(n, 1);
            return new LRESULT(OS.GetStockObject(5));
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_PAINT(int n, int n2) {
        if ((this.state & 0x1000) != 0) {
            return LRESULT.ZERO;
        }
        if (OS.IsWinCE) {
            boolean bl;
            boolean bl2 = this.image != null;
            boolean bl3 = bl = (this.style & 2) != 0 && (this.style & 0x20) == 0;
            if (bl2 || bl) {
                LRESULT lRESULT = null;
                PAINTSTRUCT pAINTSTRUCT = new PAINTSTRUCT();
                GCData gCData = new GCData();
                gCData.ps = pAINTSTRUCT;
                gCData.hwnd = this.handle;
                GC gC = this.new_GC(gCData);
                if (gC != null) {
                    int n3;
                    Object object;
                    this.drawBackground(gC.handle);
                    RECT rECT = new RECT();
                    OS.GetClientRect(this.handle, rECT);
                    if (bl) {
                        int n4;
                        object = new RECT();
                        n3 = OS.GetSystemMetrics(5);
                        int n5 = n4 = (this.style & 4) != 0 ? 10 : 6;
                        if ((this.style & 0x100) != 0) {
                            int n6 = rECT.top + Math.max(n3 * 2, (rECT.bottom - rECT.top) / 2);
                            OS.SetRect((RECT)object, rECT.left, rECT.top, rECT.right, n6);
                            OS.DrawEdge(gC.handle, (RECT)object, n4, 8);
                        } else {
                            int n7 = rECT.left + Math.max(n3 * 2, (rECT.right - rECT.left) / 2);
                            OS.SetRect((RECT)object, rECT.left, rECT.top, n7, rECT.bottom);
                            OS.DrawEdge(gC.handle, (RECT)object, n4, 4);
                        }
                        lRESULT = LRESULT.ONE;
                    }
                    if (bl2) {
                        object = this.image.getBoundsInPixels();
                        n3 = 0;
                        if ((this.style & 0x1000000) != 0) {
                            n3 = Math.max(0, (rECT.right - ((Rectangle)object).width) / 2);
                        } else if ((this.style & 0x20000) != 0) {
                            n3 = Math.max(0, rECT.right - ((Rectangle)object).width);
                        }
                        gC.drawImage(this.image, DPIUtil.autoScaleDown(n3), DPIUtil.autoScaleDown(Math.max(0, (rECT.bottom - ((Rectangle)object).height) / 2)));
                        lRESULT = LRESULT.ONE;
                    }
                    int n8 = pAINTSTRUCT.right - pAINTSTRUCT.left;
                    n3 = pAINTSTRUCT.bottom - pAINTSTRUCT.top;
                    if (n8 != 0 && n3 != 0) {
                        Event event = new Event();
                        event.gc = gC;
                        event.setBoundsInPixels(new Rectangle(pAINTSTRUCT.left, pAINTSTRUCT.top, n8, n3));
                        this.sendEvent(9, event);
                        event.gc = null;
                    }
                    gC.dispose();
                }
                return lRESULT;
            }
        }
        return super.WM_PAINT(n, n2);
    }

    @Override
    LRESULT wmDrawChild(int n, int n2) {
        DRAWITEMSTRUCT dRAWITEMSTRUCT = new DRAWITEMSTRUCT();
        OS.MoveMemory(dRAWITEMSTRUCT, n2, DRAWITEMSTRUCT.sizeof);
        this.drawBackground(dRAWITEMSTRUCT.hDC);
        if ((this.style & 2) != 0) {
            int n3;
            if ((this.style & 0x20) != 0) {
                return null;
            }
            RECT rECT = new RECT();
            int n4 = OS.GetSystemMetrics(5);
            int n5 = n3 = (this.style & 4) != 0 ? 10 : 6;
            if ((this.style & 0x100) != 0) {
                int n6 = dRAWITEMSTRUCT.top + Math.max(n4 * 2, (dRAWITEMSTRUCT.bottom - dRAWITEMSTRUCT.top) / 2);
                OS.SetRect(rECT, dRAWITEMSTRUCT.left, dRAWITEMSTRUCT.top, dRAWITEMSTRUCT.right, n6);
                OS.DrawEdge(dRAWITEMSTRUCT.hDC, rECT, n3, 8);
            } else {
                int n7 = dRAWITEMSTRUCT.left + Math.max(n4 * 2, (dRAWITEMSTRUCT.right - dRAWITEMSTRUCT.left) / 2);
                OS.SetRect(rECT, dRAWITEMSTRUCT.left, dRAWITEMSTRUCT.top, n7, dRAWITEMSTRUCT.bottom);
                OS.DrawEdge(dRAWITEMSTRUCT.hDC, rECT, n3, 4);
            }
        } else {
            int n8 = dRAWITEMSTRUCT.right - dRAWITEMSTRUCT.left;
            int n9 = dRAWITEMSTRUCT.bottom - dRAWITEMSTRUCT.top;
            if (n8 != 0 && n9 != 0) {
                Object object;
                boolean bl = this.image != null;
                boolean bl2 = IMAGE_AND_TEXT && this.text.length() != 0;
                int n10 = bl2 && bl ? 4 : 0;
                int n11 = 0;
                int n12 = 0;
                if (bl) {
                    object = this.image.getBoundsInPixels();
                    n11 = ((Rectangle)object).width;
                    n12 = ((Rectangle)object).height;
                }
                object = null;
                TCHAR tCHAR = null;
                int n13 = 0;
                int n14 = 0;
                int n15 = 0;
                if (bl2) {
                    object = new RECT();
                    n15 = 9280;
                    if ((this.style & 0x4000) != 0) {
                        n15 |= 0;
                    }
                    if ((this.style & 0x1000000) != 0) {
                        n15 |= 1;
                    }
                    if ((this.style & 0x20000) != 0) {
                        n15 |= 2;
                    }
                    if ((this.style & 0x40) != 0) {
                        n15 |= 0x10;
                        ((RECT)object).right = Math.max(0, n8 - n11 - n10);
                    }
                    tCHAR = new TCHAR(this.getCodePage(), this.text, true);
                    OS.DrawText(dRAWITEMSTRUCT.hDC, tCHAR, -1, (RECT)object, n15);
                    n13 = ((RECT)object).right - ((RECT)object).left;
                    n14 = ((RECT)object).bottom - ((RECT)object).top;
                }
                int n16 = 0;
                if ((this.style & 0x1000000) != 0) {
                    n16 = Math.max(0, (n8 - n11 - n13 - n10) / 2);
                } else if ((this.style & 0x20000) != 0) {
                    n16 = n8 - n11 - n13 - n10;
                }
                if (bl) {
                    GCData gCData = new GCData();
                    gCData.device = this.display;
                    GC gC = GC.win32_new(dRAWITEMSTRUCT.hDC, gCData);
                    Image image = this.getEnabled() ? this.image : new Image((Device)this.display, this.image, 1);
                    gC.drawImage(image, DPIUtil.autoScaleDown(n16), DPIUtil.autoScaleDown(Math.max(0, (n9 - n12) / 2)));
                    if (image != this.image) {
                        image.dispose();
                    }
                    gC.dispose();
                    n16 += n11 + n10;
                }
                if (bl2) {
                    ((RECT)object).left = n16;
                    ((RECT)object).right += ((RECT)object).left;
                    ((RECT)object).top = Math.max(0, (n9 - n14) / 2);
                    ((RECT)object).bottom += ((RECT)object).top;
                    OS.DrawText(dRAWITEMSTRUCT.hDC, tCHAR, -1, (RECT)object, n15 &= 0xFFFFFBFF);
                }
            }
        }
        return null;
    }

    static {
        LabelClass = new TCHAR(0, "STATIC", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, LabelClass, wNDCLASS);
        LabelProc = wNDCLASS.lpfnWndProc;
    }
}

