/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.stylist.tag;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.util.ServletTagUtil;
import org.itscool.stylist.tag.ElementList;

public class LayoutRegex {
    private ServletContext context;
    private HttpServletRequest req;

    public LayoutRegex(ServletContext context, HttpServletRequest req) {
        this.context = context;
        this.req = req;
    }

    public String replacePath(String dstStr) {
        String replace = "\"" + this.req.getContextPath() + "/";
        StringBuffer criteria = new StringBuffer();
        criteria.append("<a.*href\\s*=\\s*\".*\"");
        criteria.append("|<img.*src\\s*=\\s*\".*\"");
        criteria.append("|<link.*src\\s*=\\s*\".*\"");
        criteria.append("|<link.*href\\s*=\\s*\".*\"");
        criteria.append("|<script.*src\\s*=\\s*\".*\"");
        criteria.append("|<.*background\\s*=\\s*\".*\"");
        criteria.append("|<form.*action\\s*=\\s*\".*\"");
        Pattern pattern = Pattern.compile(criteria.toString());
        Matcher matcher = pattern.matcher(dstStr);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            StringBuffer sb2 = new StringBuffer();
            String element = matcher.group();
            boolean flg = false;
            Pattern pattern2 = Pattern.compile("\"\\./");
            Matcher matcher2 = pattern2.matcher(element);
            while (matcher2.find()) {
                String path = matcher2.group();
                matcher2.appendReplacement(sb2, replace);
                flg = true;
            }
            matcher2.appendTail(sb2);
            String tag = sb2.toString();
            if (flg) {
                tag = LayoutRegex.supressPath(tag);
            }
            matcher.appendReplacement(sb, tag);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String supressPath(String tag) {
        Pattern pattern = Pattern.compile("\\.\\./");
        Matcher matcher = pattern.matcher(tag);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public String replaceEl(String dstStr) {
        Pattern pattern = Pattern.compile("\\$\\{\\s*\\b([A-Za-z_0-9|.|\\(|\\)]*)\\s*\\}");
        Matcher matcher = pattern.matcher(dstStr);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String el = matcher.group();
            String value = this.parseObj(el);
            matcher.appendReplacement(sb, value);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public String parseObj(String dstStr) {
        StringBuffer sb2 = new StringBuffer();
        Pattern pattern2 = Pattern.compile("\\s*\\b([A-Za-z_0-9|.]*)\\s*");
        Matcher matcher2 = pattern2.matcher(dstStr);
        if (!matcher2.find()) {
            return null;
        }
        String tag = matcher2.group();
        ElementList elems = this.createElementList(tag);
        int size = elems.size();
        String name = elems.getElement(0);
        if (size > 1) {
            String property = elems.getElement(1);
            Object obj = ServletTagUtil.findProperty((ServletContext)this.context, (HttpServletRequest)this.req, (String)name, (String)property, null);
            if (size > 2) {
                int i = 2;
                while (i < size) {
                    property = elems.getElement(i);
                    obj = BeanUtil.getProperty((Object)obj, (String)property);
                    ++i;
                }
            }
            return obj.toString();
        }
        Object obj = ServletTagUtil.findObject((ServletContext)this.context, (HttpServletRequest)this.req, (String)name, null);
        return obj.toString();
    }

    protected ElementList createElementList(String property) {
        ElementList elems = new ElementList();
        StringTokenizer propertySt = new StringTokenizer(property, ".");
        while (propertySt.hasMoreTokens()) {
            property = propertySt.nextToken().trim();
            property = property.substring(0, property.length());
            elems.add(property);
        }
        return elems;
    }
}

