package org.itscool.webersample.action.schedule;


import java.util.Calendar;
import java.util.List;

import org.itscool.commons.util.DateFormatUtil;
import org.itscool.weber.action.Action;
import org.itscool.weber.action.ActionBucket;
import org.itscool.weber.action.Globals;
import org.itscool.weber.user.User;
import org.itscool.webersample.bean.OfficeWorker;
import org.itscool.webersample.beanex.ScheduleEx;
import org.itscool.webersample.dao.OfficeWorkerDao;
import org.itscool.webersample.dao.ScheduleDao;
import org.itscool.webersample.tag.ScheduleCalendarDrawComponent;

/**
 * XPW[o^ANV<BR>
 * ̃NX̓XPW[̐VKǉAXVA폜
 * s܂B
 * @author Kano
 */
public class ScheduleRegistAction extends Action{
	/**
	 * XPW[̓͏܂
	 * @param bucket ActionBucketCX^X
	 */
	public void doValidate(ActionBucket bucket){
		User user = (User)bucket.getAttributeFromSession(Globals.REQ_PARAM_USER);
		String workerId = (String)getParameter("workerId");
		OfficeWorkerDao dao = new OfficeWorkerDao();
		
		if(workerId != null){
			OfficeWorker worker = dao.getWorker(Integer.parseInt(workerId));
			if(worker == null || !user.getName().equals(worker.getWorkerId())){
	    		putMessage("aa", "l̃XPW[ҏW邱Ƃ͂ł܂");
			}
		}
    	if(user == null || workerId == null){
    		putMessage("I9003");
    	}
	}
	/**
	 * doPostM <BR>
	 * sԂXVAT[ubgReLXgɌʂԂB
	 * @param mapping ActionMapping ANV}bsO
	 * @param form ActionForm ANVtH[
	 * @param req HttpServletRequest NCAg̃NGXg
	 * @param res HttpServletResponse NCAgɕԂX|X
	 * @return ActionForward ANVtH[h
	 */
	public String doExecute( ActionBucket bucket )
	{
	    //T[ubgReLXg̎擾
		ScheduleRegistForm registForm = (ScheduleRegistForm)bucket.getForm();
		ScheduleDao scheduleDao = new ScheduleDao();
        int scheduleID = registForm.getScheduleID();
        int workerId = registForm.getWorkerId();
        int year = registForm.getYear();
        int month = registForm.getMonth();
        
        // XPW[̓o^^ҏW
		if (this.getParameter("submit") != null) {
			ScheduleEx schedule = ScheduleUtil.createSchedule(registForm);
			if( scheduleDao.findById( scheduleID ) == null ){
				scheduleDao.save(schedule);
				
			}else{
				schedule.setScheduleID(scheduleID);
				scheduleDao.update(schedule);
			}
			if( registForm.getLoopFlg() != null && registForm.getLoopFlg().equals(ScheduleRegistForm.LOOP_FLG_ON)){
				loopRegistSchedule(registForm);
			}
			
		//XPW[̍폜
		}else if( this.getParameter("delete") != null ){
			ScheduleEx schedule = scheduleDao.findById( scheduleID );
			if( schedule != null){
				scheduleDao.delete(schedule);
			}
		}
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.YEAR, year);
        cal.set(Calendar.MONTH, month-1);
        bucket.setAttribute("calendar", cal);
        bucket.setAttribute("workerId", String.valueOf(workerId));
        bucket.setAttribute("year", new Integer(year));
        bucket.setAttribute("month", new Integer(month));
        
        //ԃJ_[\̗\\JڂĂꍇ
        if(registForm.getMode() == ScheduleRegistForm.MODE_CALENDAR){
        	//List schedules = scheduleDao.findByMonth(workerId, year, month, null);
        	//bucket.setAttribute("schedules", schedules);
        	bucket.setAttribute("workerId", String.valueOf(workerId));
    		bucket.setAttribute("calendar", cal);
        	bucket.setAttribute("year", String.valueOf(cal.get(Calendar.YEAR)));
    		bucket.setAttribute("month", String.valueOf(cal.get(Calendar.MONTH)+1));
    		bucket.setAttribute(ScheduleCalendarDrawComponent.WORKER_ID_PARAM_NAME, String.valueOf(workerId));
            return "success";
            
        //\\ꗗ\JڂĂꍇ
        }else if(registForm.getMode() == ScheduleRegistForm.MODE_LIST){
        	OfficeWorkerDao workerDao = new OfficeWorkerDao();
        	List schedules;
    		if(year != -1 && month != -1 ){
    			schedules = scheduleDao.findByMonth(workerId, year, month, null);
    		}else if(year != -1 ){
    			schedules = scheduleDao.findByYear(workerId, year, null);
    		}else{
    			schedules = scheduleDao.getAllData(workerId);
    		}
    		bucket.setAttribute("schedules", schedules);
            
            bucket.setAttribute("days", ScheduleUtil.getDays());
            bucket.setAttribute("months", ScheduleUtil.getMonths());
            bucket.setAttribute("years", ScheduleUtil.getYears());
            bucket.setAttribute("schedule", registForm);
    		bucket.setAttribute("workers", workerDao.getAllData());
    		return "success_list";
    	
    	//O[vʗ\\ꗗJڂĂꍇ
        }else{
        	bucket.setAttribute("workerId", String.valueOf(workerId));
    		bucket.setAttribute("calendar", cal);
    		bucket.setAttribute("year", String.valueOf(cal.get(Calendar.YEAR)));
    		bucket.setAttribute("month", String.valueOf(cal.get(Calendar.MONTH)+1));
    		bucket.setAttribute("day", String.valueOf(cal.get(Calendar.DAY_OF_MONTH)));
    		bucket.setAttribute(ScheduleCalendarDrawComponent.WORKER_ID_PARAM_NAME, String.valueOf(workerId));
            return "success_group";
        }
		
	}
	
	/**
	 * XPW[̌JԂo^s܂
	 * @param form XPW[
	 */
	private void loopRegistSchedule(ScheduleRegistForm form){
		switch(form.getLoopKind()){
		case ScheduleRegistForm.LOOP_KIND_DAYS:
			daysRegistSchedule(form);
			break;
		case ScheduleRegistForm.LOOP_KIND_WEEKS:
			weeksRegistSchedule(form);
			break;
		case ScheduleRegistForm.LOOP_KIND_MONTHS:
			monthsRegistSchedule(form);
			break;
		}
	}
	
	/**
	 * ũXPW[JԂo^܂
	 * @param form XPW[
	 */
	private void daysRegistSchedule(ScheduleRegistForm form){
		int startYear = form.getYear();
		int startMonth = form.getMonth();
		int startDay = form.getDay();
		
		Calendar startCal = ScheduleUtil.createCalendar(startYear, startMonth-1, startDay);
		Calendar endCal = DateFormatUtil.decodeYYYYMMDDString(form.getLoopDate());
		
		ScheduleDao dao = new ScheduleDao();
		
		while(startCal.getTimeInMillis()<endCal.getTimeInMillis()){
			startCal.add(Calendar.DAY_OF_MONTH, 1);
			form.setYear(startCal.get(Calendar.YEAR));
			form.setMonth(startCal.get(Calendar.MONTH)+1);
			form.setDay(startCal.get(Calendar.DAY_OF_MONTH));
			ScheduleEx schedule = ScheduleUtil.createSchedule(form);
			dao.save(schedule);
		}
	}
	
	/**
	 * uT̃XPW[JԂo^܂
	 * @param form XPW[
	 */
	private void weeksRegistSchedule(ScheduleRegistForm form){
		int startYear = form.getYear();
		int startMonth = form.getMonth();
		int startDay = form.getDay();
		
		Calendar startCal = ScheduleUtil.createCalendar(startYear, startMonth-1, startDay);
		Calendar endCal = DateFormatUtil.decodeYYYYMMDDString(form.getLoopDate());
		
		ScheduleDao dao = new ScheduleDao();
		
		while(startCal.getTimeInMillis()<endCal.getTimeInMillis()){
			startCal.add(Calendar.WEEK_OF_MONTH, 1);
			form.setYear(startCal.get(Calendar.YEAR));
			form.setMonth(startCal.get(Calendar.MONTH)+1);
			form.setDay(startCal.get(Calendar.DAY_OF_MONTH));
			ScheduleEx schedule = ScheduleUtil.createSchedule(form);
			dao.save(schedule);
		}
	}
	
	/**
	 * ũXPW[JԂo^܂
	 * @param form XPW[
	 */
	private void monthsRegistSchedule(ScheduleRegistForm form){
		int startYear = form.getYear();
		int startMonth = form.getMonth();
		int startDay = form.getDay();
		
		Calendar startCal = ScheduleUtil.createCalendar(startYear, startMonth-1, startDay);
		Calendar endCal = DateFormatUtil.decodeYYYYMMDDString(form.getLoopDate());
		
		ScheduleDao dao = new ScheduleDao();
		while(startCal.getTimeInMillis()<endCal.getTimeInMillis()){
			startCal.add(Calendar.MONTH, 1);
			form.setYear(startCal.get(Calendar.YEAR));
			form.setMonth(startCal.get(Calendar.MONTH)+1);
			form.setDay(startCal.get(Calendar.DAY_OF_MONTH));
			ScheduleEx schedule = ScheduleUtil.createSchedule(form);
			dao.save(schedule);
		}
	}
}
