package org.itscool.webersample.action.schedule;
import java.util.Calendar;
import java.util.List;

import org.itscool.weber.action.Action;
import org.itscool.weber.action.ActionBucket;
import org.itscool.weber.action.Globals;
import org.itscool.weber.user.User;
import org.itscool.webersample.bean.OfficeWorker;
import org.itscool.webersample.dao.OfficeWorkerDao;
import org.itscool.webersample.tag.ScheduleCalendarDrawComponent;

/**
 * XPW[Ǘ ЈIANV
 * file name : ScheduleSelectWorkerAction.java <BR>
 * @version 1.00A 2003/10/16
 * @author kano
*/
public class ScheduleSelectCalendarAction extends Action{
	public void doValidate(ActionBucket bucket){
		User user = (User)bucket.getAttributeFromSession(Globals.REQ_PARAM_USER);
		if( !isNotNull("workerId") && 
			( user != null && user.getRole().getName().equals("admin") )){
			this.putMessage("aa", "Ǘ҃[U͌l̃XPW[ĂȂ<BR>XPW[{邱Ƃ͂ł܂B");
		}
	}
	
	/**
	 * doPostM <BR>
	 * IꂽЈ擾AZbVɓo^܂B
	 * @param mapping ActionMapping ANV}bsO
	 * @param form ActionForm ANVtH[
	 * @param req HttpServletRequest NCAg̃NGXg
	 * @param res HttpServletResponse NCAgɕԂX|X
	 * @return ActionForward ANVtH[h
	 */
	public String doExecute( ActionBucket bucket ){   
        
		ScheduleSearchForm form = (ScheduleSearchForm)bucket.getForm();
		int workerId = form.getWorkerId();
		if( workerId == -1 ){
			String str = (String)bucket.getAttribute("workerId");
			if( str != null && str.length() > 0){
				workerId = Integer.parseInt(str); 
			}
		}
        OfficeWorkerDao workerDAO = new OfficeWorkerDao();
		List list = workerDAO.find(OfficeWorker.PK_COLUM_id, String.valueOf(workerId));
		
        int year = form.getYear();
        int month = form.getMonth();
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(Calendar.YEAR, year);
        cal.set(Calendar.MONTH, (month-1));
        if (this.getParameter("submit_month_before") != null) {
            cal.add(Calendar.MONTH, -1);
        }else if (this.getParameter("submit_month_next") != null) {
            cal.add(Calendar.MONTH, +1);
        }
        if(list.size() > 0){
        	OfficeWorker worker = (OfficeWorker)list.get(0);
        	bucket.setAttribute("personName", worker.getFirstName() + " " + worker.getSecondName());
        }
        bucket.setAttribute("workerId", String.valueOf(workerId));
		bucket.setAttribute("calendar", cal);
		bucket.setAttribute("year", String.valueOf(cal.get(Calendar.YEAR)));
		bucket.setAttribute("month", String.valueOf(cal.get(Calendar.MONTH)+1));
		bucket.setAttribute(ScheduleCalendarDrawComponent.WORKER_ID_PARAM_NAME, String.valueOf(workerId));
        
        return "success";
	}
}
