package org.itscool.webersample.action.schedule;

import java.util.List;

import org.itscool.weber.action.Action;
import org.itscool.weber.action.ActionBucket;
import org.itscool.webersample.bean.Schedule;
import org.itscool.webersample.dao.ScheduleDao;

/**
 * @author kano
*/
public class ScheduleShowRegistAction extends Action{
    public String doExecute( ActionBucket bucket ){
        ScheduleRegistForm form = (ScheduleRegistForm)bucket.getForm();
        ScheduleDao dao = new ScheduleDao();
        List lst = dao.find(Schedule.PK_COLUM_scheduleID, new Integer(form.getScheduleID()));
        
        if( lst.size() > 0){
            Schedule schedule = (Schedule)lst.get(0);
            form.setContents(schedule.getContents());
            form.setYear(schedule.getYear());
            form.setMonth(schedule.getMonth());
            form.setDay(schedule.getDay());
            form.setNote(schedule.getNote());
            form.setScheduleID(schedule.getScheduleID());
            form.setStartTime(schedule.getStartTime());
            form.setStartMinute(schedule.getStartMinute());
            form.setEndTime(schedule.getEndTime());
            form.setEndMinute(schedule.getEndMinute());
            bucket.setAttribute("schedule", form);
        }else{
            bucket.setAttribute("schedule", form);
        }
        
        bucket.setAttribute("days", ScheduleUtil.getDays());
        bucket.setAttribute("months", ScheduleUtil.getMonths());
        bucket.setAttribute("years", ScheduleUtil.getYears());
        bucket.setAttribute("hours", ScheduleUtil.getHours());
        bucket.setAttribute("minutes", ScheduleUtil.getMinutes());
        return "success";
    }
    
	
}
