package org.itscool.webersample.action.schedule;

import java.util.ArrayList;
import java.util.Calendar;

import org.itscool.webersample.bean.OfficeWorker;
import org.itscool.webersample.beanex.ScheduleEx;
import org.itscool.webersample.dao.OfficeWorkerDao;

public class ScheduleUtil {
	/** CZp[^ */
	private static final String LINE = 
		System.getProperty("line.separator");
	/** CZp[^ gslk@*/
	private static final String BR = "<br>";
	
	public static ScheduleEx createSchedule(ScheduleRegistForm registForm){
		int year = registForm.getYear();
        int month = registForm.getMonth();
        int day = registForm.getDay();
        int startTime = registForm.getStartTime();
        int startMinute = registForm.getStartMinute();
        int endTime = registForm.getEndTime();
        int endMinute = registForm.getEndMinute();
        int workerId = registForm.getWorkerId();
        String contents = registForm.getContents();
        String note = registForm.getNote();
        
        OfficeWorkerDao dao = new OfficeWorkerDao();
        OfficeWorker worker = dao.getWorker(OfficeWorker.PK_COLUM_id, String.valueOf(workerId));
        
        //s<br>ɕϊ
        if(contents != null )
        	contents = contents.replaceAll(LINE, BR);
		if(note != null)
			note = note.replaceAll(LINE, BR);
		
		ScheduleEx schedule = new ScheduleEx();
		schedule.setWorkerId(worker.getId());
		schedule.setYear(year);
		schedule.setMonth(month);
		schedule.setDay(day);
		schedule.setStartTime(startTime);
		schedule.setStartMinute(startMinute);
		schedule.setEndTime(endTime);
		schedule.setEndMinute(endMinute);
		schedule.setContents(contents);
		schedule.setNote(note);
		
		return schedule;
	}
	
	public static Calendar createCalendar(int year, int month, int day){
		Calendar cal = Calendar.getInstance();
		cal.clear();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, month);
		cal.set(Calendar.DAY_OF_MONTH, day);
		return cal;
	}
	
	public static ArrayList getDays(){
		ArrayList days = new ArrayList();
		for(int i=0; i<31; i++ ){
			days.add(new Integer(i+1));
		}
		return days;
	}
	
	public static ArrayList getMonths(){
		ArrayList days = new ArrayList();
		for(int i=0; i<12; i++ ){
			days.add(new Integer(i+1));
		}
		return days;
	}
	
	public static ArrayList getYears(){
		ArrayList days = new ArrayList();
		Calendar cal = Calendar.getInstance();
		int year = cal.get(Calendar.YEAR);
		
		days.add(new Integer(year-1));
		days.add(new Integer(year));
		days.add(new Integer(year+1));
		return days;
	}
	
	public static ArrayList getHours(){
		ArrayList days = new ArrayList();
		for(int i=0; i<25; i++ ){
			days.add(new Integer(i));
		}
		return days;
	}
	
	public static ArrayList getMinutes(){
		ArrayList days = new ArrayList();
		days.add(new String("00"));
		days.add(new String("10"));
		days.add(new String("20"));
		days.add(new String("30"));
		days.add(new String("40"));
		days.add(new String("50"));
		return days;
	}
}
