package org.itscool.webersample.dao;

import java.util.Calendar;
import java.util.List;

import org.itscool.commons.dao.BaseDao;
import org.itscool.commons.dao.Criteria;
import org.itscool.webersample.bean.Sisetu;
import org.itscool.webersample.bean.SisetuYoyaku;

/**
 * {ݗ\f[^ANZXNX 
 */
public class SisetuYoyakuDao extends BaseDao{
	/**
	 * {ݗ\S擾܂
	 * @return {ݗ\XgŎ擾܂
	 */
	public List getAllData(){
		Criteria crt = new Criteria(SisetuYoyaku.class);
		List list = this.select(crt);
		
		return list;
	}
	
	/**
	 * w肳ꂽIDɍv{ݗ\擾܂<BR>
	 * Y񂪑݂ȂꍇnullԂ܂
	 * @param id ID
	 * @return IDɍv{ݗ\
	 */
	public SisetuYoyaku getSisetuYoyaku(int id){
		Criteria crt = new Criteria(SisetuYoyaku.class);
		crt.eq(SisetuYoyaku.TABLE+"."+SisetuYoyaku.PK_COLUM_id, id);
		
		List list = this.select(crt);
		if( list.size() == 0){
			return null;
		}else{
			return (SisetuYoyaku)list.get(0);
		}
	}
	
	/**
	 * w肳ꂽ{ݏyѓtɍv{ݗ\
	 * 擾܂
	 * @param sisetuId {ID
	 * @param cal t
	 * @return ɍv{ݗ\̃Xg
	 */
	public List findByDate(int sisetuId, Calendar cal){
		int year = cal.get(Calendar.YEAR);
		int month = cal.get(Calendar.MONTH) + 1;
		int day = cal.get(Calendar.DAY_OF_MONTH);
		
		Criteria crt = new Criteria(SisetuYoyaku.class);
		crt.eq(Sisetu.TABLE+"."+Sisetu.PK_COLUM_id, sisetuId);
		crt.and();
		crt.eq(SisetuYoyaku.TABLE+"."+SisetuYoyaku.COLUM_year, year);
		crt.and();
		crt.eq(SisetuYoyaku.TABLE+"."+SisetuYoyaku.COLUM_month, month);
		crt.and();
		crt.eq(SisetuYoyaku.TABLE+"."+SisetuYoyaku.COLUM_day, day);
		
		return this.select(crt);
	}
	
	/**
	 * {ݗ\o^܂
	 * @param yoyaku SisetuYoyakuCX^X
	 * @return o^IDԂ܂
	 */
	public int save(SisetuYoyaku yoyaku){
		int id = this.getNewIdFromAutoNumber(SisetuYoyaku.TABLE);
		yoyaku.setId(id);
		Criteria crt = new Criteria(SisetuYoyaku.class);
		this.insert(crt, yoyaku);
		return id;
	}
	
	/**
	 * {ݗ\XV܂
	 * @param yoyaku SisetuYoyakuCX^X
	 */
	public void update(SisetuYoyaku yoyaku){
		Criteria crt = new Criteria(SisetuYoyaku.class);
		crt.eq(SisetuYoyaku.TABLE+"."+SisetuYoyaku.PK_COLUM_id, yoyaku.getId());
		this.update(crt, yoyaku);
	}
	
	/**
	 * {ݗ\폜܂
	 * @param yoyaku SisetuYoyakuCX^X
	 */
	public void delete(SisetuYoyaku yoyaku){
		Criteria crt = new Criteria(SisetuYoyaku.class);
		crt.eq(SisetuYoyaku.TABLE+"."+SisetuYoyaku.PK_COLUM_id, yoyaku.getId());
		this.delete(crt);
	}
}
