package org.itscool.webersample.tag;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

import org.itscool.commons.util.NumberFormatUtil;
import org.itscool.weber.tagex.DateElement;
import org.itscool.weber.tagex.DrawComponent;
import org.itscool.webersample.beanex.ScheduleEx;
import org.itscool.webersample.dao.ScheduleDao;

public class ScheduleCalendarDrawComponent extends DrawComponent{
	public final static String WORKER_ID_PARAM_NAME = "WORKER_ID_PARAM_NAME";
	private int workerId;
	
	/**
	 * [U`֐
	 */
	protected void doInit(){
		String str = (String)getAttribute(WORKER_ID_PARAM_NAME);
		if( str != null ){
			try{
				workerId = Integer.parseInt(str);
			}catch(NumberFormatException e){
				
			}
		}
	}
	
	/**
	 * [U`f[^̎擾iTuNXŎꍇɎgpĂj
	 * 1R[h̃XPW[쐬
	 * @return [U`f[^
	 */
	protected String doPaint(DateElement date){
		int year = date.getYear();
		int month = date.getMonth();
		int day = date.getDay();
		String path = this.getServletPath();
		
		if( path.indexOf("/") != 0 ){
			path += "/";
		}
        String contextPath = getContextPath();
		
		String tag1="<BR><A HREF='" + contextPath + path +"?mode=1"+
			"&year="+year+
			"&month="+month+
			"&day="+ day +
			"&workerId=" + workerId;
		String tag2 = "' >";
		String tag3="</A>";
		StringBuffer sb = new StringBuffer();
		
		ScheduleDao scheduleDAO = new ScheduleDao();
		List scheduleList =
			scheduleDAO.findByDate(workerId, year, month, day, null );
		if( scheduleList == null || scheduleList.size() == 0){
			return sb.toString();
		}
		
		for( int i=0; i<scheduleList.size(); i++ ){
			ScheduleEx schedule = (ScheduleEx)scheduleList.get(i);
			Date start = schedule.getPlanStart();
			
			Calendar calendar = new GregorianCalendar();
			calendar.clear();
			calendar.set(Calendar.YEAR, year);//]\NZbg
			calendar.set(Calendar.MONTH, (month));//]\Zbg
			calendar.set(Calendar.DATE, day);
			calendar.setTime( start );
			
			sb.append(LINE).append(TAB).append(TAB);
			sb.append("<font size=\"2\">");
			sb.append(tag1 );
			sb.append("&scheduleID=" + schedule.getScheduleID());
			sb.append(tag2 );
			sb.append(NumberFormatUtil.convZeroPadding(calendar.get(Calendar.HOUR_OF_DAY), 2) + ":" );
			sb.append(NumberFormatUtil.convZeroPadding(calendar.get(Calendar.MINUTE), 2));
			sb.append("  ");
			sb.append(schedule.getContents());
			sb.append(tag3 );
			sb.append("</font>");
		}
		return sb.toString();
	}
	
}
