package org.itscool.webersample.tag;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

import org.itscool.commons.util.NumberFormatUtil;
import org.itscool.weber.tagex.DateElement;
import org.itscool.weber.tagex.DrawComponent;
import org.itscool.weber.tagex.MonthTable;
import org.itscool.webersample.bean.OfficeWorker;
import org.itscool.webersample.bean.Schedule;
import org.itscool.webersample.dao.OfficeWorkerDao;
import org.itscool.webersample.dao.ScheduleDao;


public class ScheduleWeeklyDrawComponent extends DrawComponent {
	public void doInit(){}
	
	public String doPaint(MonthTable mTable, int firstYear, int firstMonth, int firstDay){
		StringBuffer sb = new StringBuffer();
		int height = Integer.parseInt(celHeight);
		int width = Integer.parseInt(celWidth);
		String contextPath = getContextPath();
        String path = getServletPath();
		
		OfficeWorkerDao workerDao = new OfficeWorkerDao();
		ScheduleDao scheduleDAO = new ScheduleDao();
		
		List workers = workerDao.getAllData();
		for(int i=0; i<workers.size(); i++ ){
			OfficeWorker worker = (OfficeWorker)workers.get(i);
			int workerId = worker.getId();
			sb.append("<TR>");
			sb.append(LINE);
			sb.append(TAB);
			sb.append("<TD");
			sb.append(" HEIGHT=").append(height);
			sb.append(" WIDTH=").append(width);
			sb.append(" ALIGN=").append("\"center\"");
			sb.append(" STYLE=\"").append(dataStyle).append("\"");
			sb.append(" >");
			sb.append(LINE);
			sb.append(TAB);
			sb.append(TAB);
			sb.append(worker.getFirstName()).append(" ").append(worker.getSecondName());
			sb.append("");
			sb.append("<BR>̗\");
			sb.append(LINE);
			sb.append(TAB);
			sb.append("</TD>");
			sb.append(LINE);
			
			Calendar cal = new GregorianCalendar();
			cal.set(Calendar.YEAR, firstYear);
			cal.set(Calendar.MONTH, firstMonth-1);
			cal.set(Calendar.DAY_OF_MONTH, firstDay);
			
			for(int j=0; j<7; j++, cal.add(Calendar.DAY_OF_MONTH, 1)){
				List scheduleList =
					scheduleDAO.findByDate(workerId, cal );
				sb.append(TAB);
				sb.append("<TD align=\"left\" valign=\"top\" ");
				sb.append(" HEIGHT=").append(height);
				sb.append(" WIDTH=").append(width);
				DateElement date = mTable.getDay(cal);
				if( date.isToday() ){
					sb.append(" STYLE=\"").append(todayStyle).append("\"");
				}else if( date.isHoliday() ){
					sb.append(" STYLE=\"").append(holidayStyle).append("\"");
				}else if( date.getYobi() == Calendar.SUNDAY || date.getYobi() == Calendar.SATURDAY ){
					sb.append(" STYLE=\"").append(donichiStyle).append("\"");
				}else{
					sb.append(" STYLE=\"").append(dataStyle).append("\"");
				}
				sb.append(" >");
				sb.append(LINE);
				int year = cal.get(Calendar.YEAR);
				int month = cal.get(Calendar.MONTH)+1;
				int day = cal.get(Calendar.DAY_OF_MONTH);
				sb.append(TAB);
				sb.append(TAB);
				sb.append("<A HREF='" + contextPath + path +"?mode=3");
				sb.append("&year=").append(year);
				sb.append("&month=").append(month);
				sb.append("&day=").append(day);
				sb.append("&workerId=").append(workerId);
				sb.append("'>");
				sb.append("[ǉ]");
				sb.append("</A>");
				sb.append("<BR>");
				sb.append(LINE);
				for(int k=0; k<scheduleList.size(); k++){
					Schedule schedule = (Schedule)scheduleList.get(k);
					
					String tag1="<A HREF='" + contextPath + path +"?mode=3"+
					"&year="+year+
					"&month="+month+
					"&day="+ day +
					"&workerId=" + workerId;
					String tag2 = "' >";
					String tag3="</A>";
					sb.append(TAB);
					sb.append(TAB);
					sb.append(tag1 );
					sb.append("&scheduleID=" + schedule.getScheduleID());
					sb.append(tag2 );
					sb.append(NumberFormatUtil.convZeroPadding(schedule.getStartTime(), 2) + ":" );
					sb.append(NumberFormatUtil.convZeroPadding(schedule.getStartMinute(), 2));
					sb.append(" ").append(schedule.getContents());
					sb.append(tag3 );
					sb.append("<BR>");
					sb.append(LINE);
					
				}
				sb.append(TAB);
				sb.append("</TD>");
				sb.append(LINE);
			}
			sb.append("</TR>");
			sb.append(LINE);
		}

		return sb.toString();
	}
	
	
}
