package org.itscool.webersample.tag;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

import org.itscool.commons.util.NumberFormatUtil;
import org.itscool.weber.tagex.DateElement;
import org.itscool.weber.tagex.DrawComponent;
import org.itscool.weber.tagex.MonthTable;
import org.itscool.webersample.bean.Sisetu;
import org.itscool.webersample.bean.SisetuYoyaku;
import org.itscool.webersample.dao.SisetuDao;
import org.itscool.webersample.dao.SisetuYoyakuDao;


public class SisetuYoyakuDrawComponent extends DrawComponent {
	
	public String doPaint(MonthTable mTable, int firstYear, int firstMonth, int firstDay){
		StringBuffer sb = new StringBuffer();
		int height = Integer.parseInt(celHeight);
		int width = Integer.parseInt(celWidth);
		String contextPath = getContextPath();
		String path = getServletPath();
		
        SisetuDao sisetuDao = new SisetuDao();
        SisetuYoyakuDao yoyakuDao = new SisetuYoyakuDao();
        
		List sisetuList = sisetuDao.getAllData();
		for(int i=0; i<sisetuList.size(); i++ ){
			Sisetu sisetu = (Sisetu)sisetuList.get(i);
			int sisetuId = sisetu.getId();
			sb.append("<TR>");
			sb.append(LINE);
			sb.append(TAB);
			sb.append("<TD");
			sb.append(" HEIGHT=").append(height);
			sb.append(" WIDTH=").append(width);
			sb.append(" ALIGN=").append("\"center\"");
			sb.append(" STYLE=\"").append(dataStyle).append("\"");
			sb.append(" >");
			sb.append(LINE);
			sb.append(TAB);
			sb.append(TAB);
			sb.append(sisetu.getName());
			sb.append(LINE);
			sb.append(TAB);
			sb.append("</TD>");
			sb.append(LINE);
			
			Calendar cal = new GregorianCalendar();
			cal.set(Calendar.YEAR, firstYear);
			cal.set(Calendar.MONTH, firstMonth-1);
			cal.set(Calendar.DAY_OF_MONTH, firstDay);
			
			for(int j=0; j<7; j++, cal.add(Calendar.DAY_OF_MONTH, 1)){
				List yoyakuList = yoyakuDao.findByDate(sisetuId, cal);
				
				sb.append(TAB);
				sb.append("<TD align=\"left\" valign=\"top\" ");
				sb.append(" HEIGHT=").append(height);
				sb.append(" WIDTH=").append(width);
				DateElement date = mTable.getDay(cal);
				if( date.isToday() ){
					sb.append(" STYLE=\"").append(todayStyle).append("\"");
				}else if( date.isHoliday() ){
					sb.append(" STYLE=\"").append(holidayStyle).append("\"");
				}else if( date.getYobi() == Calendar.SUNDAY || date.getYobi() == Calendar.SATURDAY ){
					sb.append(" STYLE=\"").append(donichiStyle).append("\"");
				}else{
					sb.append(" STYLE=\"").append(dataStyle).append("\"");
				}
				sb.append(" >");
				sb.append(LINE);
				int year = cal.get(Calendar.YEAR);
				int month = cal.get(Calendar.MONTH)+1;
				int day = cal.get(Calendar.DAY_OF_MONTH);
				sb.append(TAB);
				sb.append(TAB);
				sb.append("<A HREF='" + contextPath + path +"?mode=1");
				sb.append("&year=").append(year);
				sb.append("&month=").append(month);
				sb.append("&day=").append(day);
				sb.append("&sisetuId=").append(sisetuId);
				sb.append("'>");
				sb.append("[\]");
				sb.append("</A>");
				sb.append("<BR>");
				sb.append(LINE);
				for(int k=0; k<yoyakuList.size(); k++){
					SisetuYoyaku yoyaku = (SisetuYoyaku)yoyakuList.get(k);
					
					String tag1="<A HREF='" + contextPath + path +"?"+
					"year="+year+
					"&month="+month+
					"&day="+ day +
					"&sisetuId=" + sisetuId;
					String tag2 = "' >";
					String tag3="</A>";
					sb.append(TAB);
					sb.append(TAB);
					sb.append(tag1 );
					sb.append("&id=" + yoyaku.getId());
					sb.append(tag2 );
					sb.append(NumberFormatUtil.convZeroPadding(yoyaku.getStartHour(), 2) + ":" );
					sb.append(NumberFormatUtil.convZeroPadding(yoyaku.getStartMinute(),2));
					sb.append("-");
					sb.append(NumberFormatUtil.convZeroPadding(yoyaku.getEndHour(),2) + ":" );
					sb.append(NumberFormatUtil.convZeroPadding(yoyaku.getEndMinute(),2));
					sb.append(" ").append(yoyaku.getWorker().getFirstName());
					sb.append(tag3 );
					sb.append("<BR>");
					sb.append(LINE);
					
				}
				sb.append(TAB);
				sb.append("</TD>");
				sb.append(LINE);
			}
			sb.append("</TR>");
			sb.append(LINE);
		}

		return sb.toString();
	}
	
	
}
