package test.org.itscool.commons.bean;

import java.util.Calendar;
import java.util.Date;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.bean.BeanUtilRuntimeException;

/*
胁\bhꗗ 
肷@                       gp郁\bh             bZ[WĎgp郁\bh 
^UŔ蒍3                      assert(boolean)              assert(String, boolean) 
2̐            assertEquals(long, long)     assertEquals(String, long, long) 
2̕        assertEquals(double, double) assertEquals(String, double, double) 
2̃IuWFNg1 assertEquals(Object, Object) assertEquals(String, Object, Object) 
2̃IuWFNg꒍2   assertSame(Object, Object)   assertSame(String, Object, Object) 
IuWFNgnullłȂƂ𔻒 assertNotNull(Object)        assertNotNull(String, Object) 
IuWFNgnullł邱Ƃ𔻒 assertNull(Object)           assertNull(String, Object) 
eXg̔茋ʂۂɂ         fail()                       fail(String) 

P 
Object.equals()\bhŔ肵܂B 
2 
==Ŕ肵܂B 
3 
JDK1.4assert\ɂȂ߁AJUnit3.7assertTrueɉꂽB 
*/

// 1. junit.framework.TestCasep
public class TestBean extends TestCase {
    
    // 2. StringRXgN^`
    public TestBean(String name) {
        super(name);
    }

    // 3. eXgssetUp\bhLq
    protected void setUp(){
    }
    
    public void testCreateInstance() {
        SampleBean bean = 
            (SampleBean)BeanUtil.createInstance("test.org.itscool.commons.bean.SampleBean");
        
        if( bean == null ){
            fail("SampleBean is null.");
        }
        if( !(bean instanceof SampleBean) ){
            fail("bean is not SampleBean instance.");
        } 
    }
    
    public void testCreateInstanceNG() {
        
        try{
        	SampleBean bean = 
                (SampleBean)BeanUtil.createInstance("NgSampleBean");
            fail("Ă͂ȂBeanCX^Xꂽ.");
        }catch(BeanUtilRuntimeException bre){
            System.out.println("njFӐ}Om");
        }
    }
    
    public void testSetShort() {
        SampleBean bean = new SampleBean();
        
        try{
            BeanUtil.setProperty(bean, "shortVal", "100");
            assertEquals("shortVal(String)sv", 100, bean.getShortVal());
        }catch( BeanUtilRuntimeException bre ){
            fail("shortValsetProperty()ŗOF" + bre.getMessage());
        }
        try{
            BeanUtil.setProperty(bean, "shortVal", new Long("100"));
            assertEquals("shortVal(Short)sv", 100, bean.getShortVal());
        }catch( BeanUtilRuntimeException bre ){
            fail("shortValsetProperty()ŗOF" + bre.getMessage());
        }
    }
    
    public void testSetInteger() {
        SampleBean bean = new SampleBean();
        
        try{
            BeanUtil.setProperty(bean, "integerId", "1");
            assertEquals("integerId(String)sv", "1", bean.getIntegerId().toString());
        }catch( BeanUtilRuntimeException bre ){
            fail("idsetProperty()ŗOF" + bre.getMessage());
        }
        try{
            BeanUtil.setProperty(bean, "integerId", new Integer("10000"));
            assertEquals("integerId(Integer)sv", "10000", bean.getIntegerId().toString());
        }catch( BeanUtilRuntimeException bre ){
            fail("integerIdsetProperty()ŗOF" + bre.getMessage());
        }
    }
    
    public void testSetInt() {
        SampleBean bean = new SampleBean();
        
        try{
            BeanUtil.setProperty(bean, "id", "1");
            assertEquals("id(String)sv", 1, bean.getId());
        }catch( BeanUtilRuntimeException bre ){
            fail("idsetProperty()ŗOF" + bre.getMessage());
        }
        try{
            BeanUtil.setProperty(bean, "id", new Integer("10000"));
            assertEquals("id(Integer)sv", 10000, bean.getId());
        }catch( BeanUtilRuntimeException bre ){
            fail("idsetProperty()ŗOF" + bre.getMessage());
        }
    }
    
    public void testSetLong() {
        SampleBean bean = new SampleBean();
        
        try{
            BeanUtil.setProperty(bean, "longVal", "10000000");
            assertEquals("longVal(String)sv", 10000000, bean.getLongVal());
        }catch( BeanUtilRuntimeException bre ){
            fail("longValsetProperty()ŗOF" + bre.getMessage());
        }
        try{
            BeanUtil.setProperty(bean, "longVal", new Long("10000000"));
            assertEquals("longVal(Long)sv", 10000000, bean.getLongVal());
        }catch( BeanUtilRuntimeException bre ){
            fail("longValsetProperty()ŗOF" + bre.getMessage());
        }
    }
    
    public void testSetDouble() {
        SampleBean bean = new SampleBean();
        
        try{
            BeanUtil.setProperty(bean, "doubleVal", "1.2345");
            if( 1.2345 != bean.getDoubleVal() ){
				fail("doubleValsv bean["+bean.getDoubleVal()+
				"], 1.2345");
            }
            //assertEquals("doubleValsv", 1.2345, bean.getDoubleVal());
        }catch( BeanUtilRuntimeException bre ){
            fail("doublValsetProperty()ŗOF" + bre.getMessage());
        }
        
        try{
            BeanUtil.setProperty(bean, "doubleVal", new Double("99.99999"));
            if( 99.99999 != bean.getDoubleVal() ){
				fail("doubleValsv bean["+bean.getDoubleVal()+
				"], 99.99999");
            }
            //assertEquals("doubleValsv", 1.2345, bean.getDoubleVal());
        }catch( BeanUtilRuntimeException bre ){
            fail("doublValsetProperty()ŗOF" + bre.getMessage());
        }
    }
    
    public void testSetBoolean() {
        SampleBean bean = new SampleBean();
        
        try{
            BeanUtil.setProperty(bean, "boolVal", "true");
            if( bean.getBoolVal() != true){
                fail("boolValsv bean["+bean.getBoolVal()+
				"], true");
            }
        }catch( BeanUtilRuntimeException bre ){
            fail("boolValsetProperty()ŗOF" + bre.getMessage());
        }
        
        try{
            BeanUtil.setProperty(bean, "boolVal", new Boolean("false"));
            if( bean.getBoolVal() != false ){
				fail("boolValsv bean["+bean.getBoolVal()+
				"], false");
            }
        }catch( BeanUtilRuntimeException bre ){
            fail("boolValsetProperty()ŗOF" + bre.getMessage());
        }
    }
    
    public void testSetString() {
        SampleBean bean = new SampleBean();
    
        try{
            BeanUtil.setProperty(bean, "name", "̌q");
            assertEquals("namesv", "̌q", bean.getName());
        }catch( BeanUtilRuntimeException bre ){
            fail("namesetProperty()ŗOF" + bre.getMessage());
        }
    }
    
    public void testSetDate() {
        SampleBean bean = new SampleBean();
    
        Calendar cal = Calendar.getInstance();
        Date date = cal.getTime();
        try{
            BeanUtil.setProperty(bean, "date", date);
            assertEquals("datesv", date, bean.getDate());
        }catch( BeanUtilRuntimeException bre ){
            fail("datesetProperty()ŗOF" + bre.getMessage());
        }
    }
    
    public void testGetShort(){
        SampleBean bean = new SampleBean();
        bean.setShortVal((short)123);
        
        try{
            short shortVal = ((Short)BeanUtil.getProperty(bean, "shortVal")).shortValue();
            assertEquals("shortValsv", shortVal, bean.getShortVal());
        }catch( BeanUtilRuntimeException bre ){
            fail("SampleBeangetProperty()ŗOF" + bre.getMessage());
        }
    }
    
    public void testGetShort2(){
        SampleBean bean = new SampleBean();
        bean.setShortVal((short)123);
        
        try{
            short shortVal = BeanUtil.getShortValue(bean, "shortVal");
            assertEquals("shortValsv", shortVal, bean.getShortVal());
        }catch( BeanUtilRuntimeException bre ){
            fail("SampleBeangetShortValue()ŗOF" + bre.getMessage());
        }
    }
    
    public void testGetInt(){
        SampleBean bean = new SampleBean();
        bean.setId(12345);
        
        try{
            int id = ((Integer)BeanUtil.getProperty(bean, "id")).intValue();
            assertEquals("idsv", id, bean.getId());
        }catch( BeanUtilRuntimeException bre ){
            fail("SampleBeangetProperty()ŗOF" + bre.getMessage());
        }
    }
    
    public void testGetInt2(){
        SampleBean bean = new SampleBean();
        bean.setId(12345);
        
        try{
            int id = BeanUtil.getIntValue(bean, "id");
            assertEquals("idsv", id, bean.getId());
        }catch( BeanUtilRuntimeException bre ){
            fail("SampleBeangetIntValue()ŗOF" + bre.getMessage());
        }
    }
    
    public void testGetLong(){
        SampleBean bean = new SampleBean();
        bean.setLongVal((long)999999999);
        
        try{
            long longVal = ((Long)BeanUtil.getProperty(bean, "longVal")).longValue();
            assertEquals("longValsv", longVal, bean.getLongVal());
        }catch( BeanUtilRuntimeException bre ){
            fail("SampleBeangetProperty()ŗOF" + bre.getMessage());
        }
    }
    
    public void testGetLong2(){
        SampleBean bean = new SampleBean();
        bean.setLongVal((long)999999999);
        
        try{
            long longVal = BeanUtil.getLongValue(bean, "longVal");
            assertEquals("longValsv", longVal, bean.getLongVal());
        }catch( BeanUtilRuntimeException bre ){
            fail("SampleBeangetLongValue()ŗOF" + bre.getMessage());
        }
    }
        
    public void testGetDouble(){
        SampleBean bean = new SampleBean();
        bean.setDoubleVal((long)99.9999999);
        
        try{
            double doubleVal = ((Double)BeanUtil.getProperty(bean, "doubleVal")).doubleValue();
            if( doubleVal != bean.getDoubleVal() ){
                fail("doubleValsv");
            }
        }catch( BeanUtilRuntimeException bre ){
            fail("SampleBeangetProperty()ŗOF" + bre.getMessage());
        }
    }
    
    public void testGetDouble2(){
        SampleBean bean = new SampleBean();
        bean.setDoubleVal((long)99.9999999);
        
        try{
            double doubleVal = BeanUtil.getDoubleValue(bean, "doubleVal");
            if( doubleVal != bean.getDoubleVal() ){
                fail("doubleValsv");
            }
        }catch( BeanUtilRuntimeException bre ){
            fail("SampleBeangetDoubleValue()ŗOF" + bre.getMessage());
        }
    }
    
    public void testGetFloat(){
        SampleBean bean = new SampleBean();
        bean.setFloatVal((long)99.999);
        
        try{
            float floatVal = ((Float)BeanUtil.getProperty(bean, "floatVal")).floatValue();
            if( floatVal != bean.getFloatVal() ){
                fail("floatValsv");
            }
        }catch( BeanUtilRuntimeException bre ){
            fail("SampleBeangetProperty()ŗOF" + bre.getMessage());
        }
    }
    
    public void testGetFloat2(){
        SampleBean bean = new SampleBean();
        bean.setFloatVal((long)99.999);
        
        try{
            float floatVal = BeanUtil.getFloatValue(bean, "floatVal");
            if( floatVal != bean.getFloatVal() ){
                fail("floatValsv");
            }
        }catch( BeanUtilRuntimeException bre ){
            fail("SampleBeangetFloatValue()ŗOF" + bre.getMessage());
        }
    }
    
    public void testGetBoolean(){
        SampleBean bean = new SampleBean();
        bean.setBoolVal(true);
        
        try{
            boolean boolVal = ((Boolean)BeanUtil.getProperty(bean, "boolVal")).booleanValue();
            if( boolVal != bean.getBoolVal() ){
                fail("boolValsv");
            }
        }catch( BeanUtilRuntimeException bre ){
            fail("SampleBeangetProperty()ŗOF" + bre.getMessage());
        }
    }
    
    public void testGetBoolean2(){
        SampleBean bean = new SampleBean();
        bean.setBoolVal(true);
        
        try{
            boolean boolVal = BeanUtil.getBooleanValue(bean, "boolVal");
            if( boolVal != bean.getBoolVal() ){
                fail("boolValsv");
            }
        }catch( BeanUtilRuntimeException bre ){
            fail("SampleBeangetProperty()ŗOF" + bre.getMessage());
        }
    }
        
    public void testSetIntNG() {
        SampleBean bean = new SampleBean();
        
        try{
            BeanUtil.setProperty(bean, "ngId", "1");
            fail("ZbgĂ͂ȂvpeBZbgꂽ.");
        }catch( BeanUtilRuntimeException bre ){
            //System.out.println("njFӐ}Om");
        }
    }
    
    public void testGetIntNG() {
        SampleBean bean = new SampleBean();
        bean.setId(1);
        
        try{
            int id = ((Integer)BeanUtil.getProperty(bean, "ngId")).intValue();
            fail("ZbgĂ͂ȂvpeBZbgꂽ.");
        }catch( BeanUtilRuntimeException bre ){
            //System.out.println("njFӐ}Om");
        }
    }
    
    public void tearDown() {
        // ͂̃eXgvȌIΏ܂B
    }
	public static Test suite() {
		return new TestSuite(TestBean.class);
	}

}

