package test.org.itscool.commons.dao;

import junit.framework.TestCase;

import org.itscool.commons.dao.Criteria;

/**
 * 쐬: 2005/06/22
 * @author kanoum
 */
public class TestCriteria2 extends TestCase{
    public TestCriteria2(String name){
        super(name);
    }
    
    public void testSelect1(){
        Criteria crt = new Criteria(BookBean1.class);
//        System.out.println("------------------------------");
//        System.out.println(crt.toSelectString());
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
	    sb.append("SELECT").append(line);
	    sb.append("    BOOK.AUTOR_ID as BOOK_AUTOR_ID,").append(line);
	    sb.append("    BOOK.ID as BOOK_ID,").append(line);
	    sb.append("    BOOK.NAME as BOOK_NAME").append(line);
	    sb.append("FROM").append(line);
	    sb.append("    BOOK");
	    assertEquals(sb.toString(), crt.toSelectString());
    }
    
    public void testSelect2(){
        Criteria crt = new Criteria(AutorBean1.class);
//        System.out.println("------------------------------");
//        System.out.println(crt.toSelectString());
        
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
	    sb.append("SELECT").append(line);
	    sb.append("    AUTOR.NAME as AUTOR_NAME,").append(line);
	    sb.append("    AUTOR.ID as AUTOR_ID").append(line);
	    sb.append("FROM").append(line);
	    sb.append("    AUTOR");
	    assertEquals(sb.toString(), crt.toSelectString());
    }
    
    public void testSelect3(){
        Criteria crt = new Criteria(BookBean1.class);
        crt.eq(BookBean1.TABLE+"."+BookBean1.COLUM_autorId, 1);
        crt.or();
        crt.eq(BookBean1.TABLE+"."+BookBean1.COLUM_name, "䂵");
        crt.orderby(BookBean1.TABLE+"."+BookBean1.COLUM_id, true);
        crt.orderby(BookBean1.TABLE+"."+BookBean1.COLUM_name, false);
//        System.out.println("------------------------------");
//        System.out.println(crt.toSelectString());
        
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
	    sb.append("SELECT").append(line);
	    sb.append("    BOOK.AUTOR_ID as BOOK_AUTOR_ID,").append(line);
	    sb.append("    BOOK.ID as BOOK_ID,").append(line);
	    sb.append("    BOOK.NAME as BOOK_NAME").append(line);
	    sb.append("FROM").append(line);
	    sb.append("    BOOK").append(line);
	    sb.append("WHERE").append(line);
        sb.append("    BOOK.AUTOR_ID = 1").append(line);
        sb.append("    OR BOOK.NAME = '䂵'").append(line);
        sb.append("ORDER BY").append(line);
        sb.append("    BOOK.ID ASC,").append(line);
        sb.append("    BOOK.NAME DESC");
        
        assertEquals(sb.toString(), crt.toSelectString());
    }
    
    public void testInsert1(){
        Criteria crt = new Criteria(BookBean1.class);
        BookBean1 book = new BookBean1();
//        System.out.println("------------------------------");
//        System.out.println(crt.toInsertString(book));
        
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
	    sb.append("INSERT INTO BOOK(AUTOR_ID,ID,NAME) VALUES(0,0,null)");
        
        assertEquals(sb.toString(), crt.toInsertString(book));
        
        
    }
    
    public void testInsert2(){
        Criteria crt = new Criteria(AutorBean1.class);
        AutorBean1 autor = new AutorBean1();
//        System.out.println("------------------------------");
//        System.out.println(crt.toInsertString(autor));
    }
    
    public void testInsert(){
        BookBean1 book = new BookBean1();
        book.setName("䂵");
        book.setId(1);
        book.setAutorId(2);
        Criteria crt = new Criteria(BookBean1.class);
        crt.eq(BookBean1.TABLE+"."+BookBean1.COLUM_autorId, 1);
        crt.or();
        crt.eq(BookBean1.TABLE+"."+BookBean1.COLUM_name, "䂵");
        crt.orderby(BookBean1.TABLE+"."+BookBean1.COLUM_id, true);
        crt.orderby(BookBean1.TABLE+"."+BookBean1.COLUM_name, false);
//        System.out.println("------------------------------");
//        System.out.println(crt.toInsertString( book));
    }

}
