package test.org.itscool.commons.dao;

import junit.framework.TestCase;

import org.itscool.commons.dao.Criteria;
import org.itscool.commons.dao.FieldMap;

/**
 * 쐬: 2005/06/22
 * @author kanoum
 */
public class TestCriteria3 extends TestCase{
    public TestCriteria3(String name){
        super(name);
    }
    
    public void testSelect1(){
        Criteria crt = new Criteria(Customer1.class);
        //System.out.println("------------------------------");
        //System.out.println(crt.toSelectString());
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
	    sb.append("SELECT").append(line);
	    sb.append("    CUSTOMER.COMPANY_ID as CUSTOMER_COMPANY_ID,").append(line);
	    sb.append("    CUSTOMER.POST_ID as CUSTOMER_POST_ID,").append(line);
	    sb.append("    CUSTOMER.NAME as CUSTOMER_NAME,").append(line);
	    sb.append("    CUSTOMER.ID as CUSTOMER_ID,").append(line);
	    sb.append("    POST.NAME as POST_NAME,").append(line);
	    sb.append("    POST.ID as POST_ID,").append(line);
	    sb.append("    COMPANY.ID as COMPANY_ID,").append(line);
	    sb.append("    COMPANY.NAME as COMPANY_NAME").append(line);
	    sb.append("FROM").append(line);
	    sb.append("    CUSTOMER,").append(line);
	    sb.append("    POST,").append(line);
	    sb.append("    COMPANY").append(line);
	    sb.append("WHERE").append(line);
	    sb.append("    POST.ID = CUSTOMER.POST_ID").append(line);
	    sb.append("    AND COMPANY.ID = CUSTOMER.COMPANY_ID");
	    assertEquals(sb.toString(), crt.toSelectString());
    }
    
    public void testSelectOverBig(){
        Criteria crt = new Criteria(Customer1.class);
        String columName = FieldMap.convColumWithTableName(Customer1.TABLE, Customer1.COLUM_companyId);
        crt.overbig(columName, "123");
        //System.out.println("------------------------------");
        //System.out.println(crt.toSelectString());
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT").append(line);
        sb.append("    CUSTOMER.COMPANY_ID as CUSTOMER_COMPANY_ID,").append(line);
        sb.append("    CUSTOMER.POST_ID as CUSTOMER_POST_ID,").append(line);
        sb.append("    CUSTOMER.NAME as CUSTOMER_NAME,").append(line);
        sb.append("    CUSTOMER.ID as CUSTOMER_ID,").append(line);
        sb.append("    POST.NAME as POST_NAME,").append(line);
        sb.append("    POST.ID as POST_ID,").append(line);
        sb.append("    COMPANY.ID as COMPANY_ID,").append(line);
        sb.append("    COMPANY.NAME as COMPANY_NAME").append(line);
        sb.append("FROM").append(line);
        sb.append("    CUSTOMER,").append(line);
        sb.append("    POST,").append(line);
        sb.append("    COMPANY").append(line);
        sb.append("WHERE").append(line);
        sb.append("    CUSTOMER.COMPANY_ID >= 123").append(line);
        sb.append("    AND POST.ID = CUSTOMER.POST_ID").append(line);
        sb.append("    AND COMPANY.ID = CUSTOMER.COMPANY_ID");

	    assertEquals(sb.toString(), crt.toSelectString());
    }
    
    public void testSelectOverSmall(){
        Criteria crt = new Criteria(Customer1.class);
        String columName = FieldMap.convColumWithTableName(Customer1.TABLE, Customer1.COLUM_companyId);
        crt.oversmall(columName, "123");
        //System.out.println("------------------------------");
        //System.out.println(crt.toSelectString());
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT").append(line);
        sb.append("    CUSTOMER.COMPANY_ID as CUSTOMER_COMPANY_ID,").append(line);
        sb.append("    CUSTOMER.POST_ID as CUSTOMER_POST_ID,").append(line);
        sb.append("    CUSTOMER.NAME as CUSTOMER_NAME,").append(line);
        sb.append("    CUSTOMER.ID as CUSTOMER_ID,").append(line);
        sb.append("    POST.NAME as POST_NAME,").append(line);
        sb.append("    POST.ID as POST_ID,").append(line);
        sb.append("    COMPANY.ID as COMPANY_ID,").append(line);
        sb.append("    COMPANY.NAME as COMPANY_NAME").append(line);
        sb.append("FROM").append(line);
        sb.append("    CUSTOMER,").append(line);
        sb.append("    POST,").append(line);
        sb.append("    COMPANY").append(line);
        sb.append("WHERE").append(line);
        sb.append("    CUSTOMER.COMPANY_ID <= 123").append(line);
        sb.append("    AND POST.ID = CUSTOMER.POST_ID").append(line);
        sb.append("    AND COMPANY.ID = CUSTOMER.COMPANY_ID");

	    assertEquals(sb.toString(), crt.toSelectString());
    }
    
    public void testSelectMoreSmall(){
        Criteria crt = new Criteria(Customer1.class);
        crt.moresmall(Customer1.TABLE+"."+Customer1.COLUM_id, "123");
        crt.and();
        crt.eq(Customer1.TABLE+"."+Customer1.COLUM_name, "Y");
        //System.out.println("------------------------------");
        //System.out.println(crt.toSelectString());
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT").append(line);
        sb.append("    CUSTOMER.COMPANY_ID as CUSTOMER_COMPANY_ID,").append(line);
        sb.append("    CUSTOMER.POST_ID as CUSTOMER_POST_ID,").append(line);
        sb.append("    CUSTOMER.NAME as CUSTOMER_NAME,").append(line);
        sb.append("    CUSTOMER.ID as CUSTOMER_ID,").append(line);
        sb.append("    POST.NAME as POST_NAME,").append(line);
        sb.append("    POST.ID as POST_ID,").append(line);
        sb.append("    COMPANY.ID as COMPANY_ID,").append(line);
        sb.append("    COMPANY.NAME as COMPANY_NAME").append(line);
        sb.append("FROM").append(line);
        sb.append("    CUSTOMER,").append(line);
        sb.append("    POST,").append(line);
        sb.append("    COMPANY").append(line);
        sb.append("WHERE").append(line);
        sb.append("    CUSTOMER.ID < 123").append(line);
        sb.append("    AND CUSTOMER.NAME = 'Y'").append(line);
        sb.append("    AND POST.ID = CUSTOMER.POST_ID").append(line);
        sb.append("    AND COMPANY.ID = CUSTOMER.COMPANY_ID");

	    assertEquals(sb.toString(), crt.toSelectString());
    }
    
    public void testSelectOr(){
        Criteria crt = new Criteria(Customer1.class);
        crt.eq(Customer1.TABLE+"."+Customer1.COLUM_id, "123");
        crt.or();
        crt.eq("CUSTOMER.NAME", "'Y'");
//        System.out.println("------------------------------");
//        System.out.println(crt.toSelectString());
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT").append(line);
        sb.append("    CUSTOMER.COMPANY_ID as CUSTOMER_COMPANY_ID,").append(line);
        sb.append("    CUSTOMER.POST_ID as CUSTOMER_POST_ID,").append(line);
        sb.append("    CUSTOMER.NAME as CUSTOMER_NAME,").append(line);
        sb.append("    CUSTOMER.ID as CUSTOMER_ID,").append(line);
        sb.append("    POST.NAME as POST_NAME,").append(line);
        sb.append("    POST.ID as POST_ID,").append(line);
        sb.append("    COMPANY.ID as COMPANY_ID,").append(line);
        sb.append("    COMPANY.NAME as COMPANY_NAME").append(line);
        sb.append("FROM").append(line);
        sb.append("    CUSTOMER,").append(line);
        sb.append("    POST,").append(line);
        sb.append("    COMPANY").append(line);
        sb.append("WHERE").append(line);
        sb.append("    CUSTOMER.ID = 123").append(line);
        sb.append("    OR CUSTOMER.NAME = 'Y'").append(line);
        sb.append("    AND POST.ID = CUSTOMER.POST_ID").append(line);
        sb.append("    AND COMPANY.ID = CUSTOMER.COMPANY_ID");

	    assertEquals(sb.toString(), crt.toSelectString());
    }

    public void testSelectNeq(){
        Criteria crt = new Criteria(Customer1.class);
        crt.neq(Customer1.TABLE+"."+Customer1.COLUM_id, "123");
        crt.or();
        crt.neq(Customer1.TABLE+"."+Customer1.COLUM_name, "Y");
//        System.out.println("------------------------------");
//        System.out.println(crt.toSelectString());
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT").append(line);
        sb.append("    CUSTOMER.COMPANY_ID as CUSTOMER_COMPANY_ID,").append(line);
        sb.append("    CUSTOMER.POST_ID as CUSTOMER_POST_ID,").append(line);
        sb.append("    CUSTOMER.NAME as CUSTOMER_NAME,").append(line);
        sb.append("    CUSTOMER.ID as CUSTOMER_ID,").append(line);
        sb.append("    POST.NAME as POST_NAME,").append(line);
        sb.append("    POST.ID as POST_ID,").append(line);
        sb.append("    COMPANY.ID as COMPANY_ID,").append(line);
        sb.append("    COMPANY.NAME as COMPANY_NAME").append(line);
        sb.append("FROM").append(line);
        sb.append("    CUSTOMER,").append(line);
        sb.append("    POST,").append(line);
        sb.append("    COMPANY").append(line);
        sb.append("WHERE").append(line);
        sb.append("    CUSTOMER.ID != 123").append(line);
        sb.append("    OR CUSTOMER.NAME != 'Y'").append(line);
        sb.append("    AND POST.ID = CUSTOMER.POST_ID").append(line);
        sb.append("    AND COMPANY.ID = CUSTOMER.COMPANY_ID");

	    assertEquals(sb.toString(), crt.toSelectString());
    }
    
    public void testSelectMoreBig(){
        Customer1 c = new Customer1();
        Criteria crt = new Criteria(Customer1.class);
        crt.morebig(Customer1.TABLE+"."+Customer1.COLUM_id, "123");
        crt.and();
        crt.eq(Customer1.TABLE+"."+Customer1.COLUM_name, "Y");
//        System.out.println("------------------------------");
//        System.out.println(crt.toUpdateString(c));
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT").append(line);
        sb.append("    CUSTOMER.COMPANY_ID as CUSTOMER_COMPANY_ID,").append(line);
        sb.append("    CUSTOMER.POST_ID as CUSTOMER_POST_ID,").append(line);
        sb.append("    CUSTOMER.NAME as CUSTOMER_NAME,").append(line);
        sb.append("    CUSTOMER.ID as CUSTOMER_ID,").append(line);
        sb.append("    POST.NAME as POST_NAME,").append(line);
        sb.append("    POST.ID as POST_ID,").append(line);
        sb.append("    COMPANY.ID as COMPANY_ID,").append(line);
        sb.append("    COMPANY.NAME as COMPANY_NAME").append(line);
        sb.append("FROM").append(line);
        sb.append("    CUSTOMER,").append(line);
        sb.append("    POST,").append(line);
        sb.append("    COMPANY").append(line);
        sb.append("WHERE").append(line);
        sb.append("    CUSTOMER.ID > 123").append(line);
        sb.append("    AND CUSTOMER.NAME = 'Y'").append(line);
        sb.append("    AND POST.ID = CUSTOMER.POST_ID").append(line);
        sb.append("    AND COMPANY.ID = CUSTOMER.COMPANY_ID");

	    assertEquals(sb.toString(), crt.toSelectString());
    }
}
