package test.org.itscool.commons.file;

import java.io.IOException;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.itscool.commons.property.HexPropertyFile;

/**
 * @author kano
 *
 * 쐬F 2005/01/12
 */
public class TestHexPropertyFile extends TestCase{
    private HexPropertyFile file;
    
//     2. StringRXgN^`
    public TestHexPropertyFile(String name) {
        super(name);
    }
    
//  3. eXgssetUp\bhLq
    protected void setUp() throws Exception {
        file = new HexPropertyFile("testBinaryFile.dat");
    }
    
    /**
     * f[^o^eXg
    */
    public void testWriteHex(){
        String data = "Ղf[^";
        
        try{
            file.removeAll();
            boolean ret = file.writeHex("key", data.getBytes() ,false);
            assertEquals("df[^݂܂", ret, true);
            assertEquals("f[^ǉfĂ܂", file.size(), 1);
        }catch(IOException ioe){
            fail(ioe.getMessage());
        }
    }
    
    /**
     * f[^deXg
    */
    public void testWriteHex2(){
        String data = "Ղf[^";
        
        try{
            file.removeAll();
            boolean ret = file.writeHex("key", data.getBytes() ,false);
            ret = file.writeHex("key", data.getBytes() ,true);
            assertEquals("write()̌ʂtrueŕԂ܂", ret, false);
            if( file.size() == 2 ){
                fail("df[^ǉĂ܂");
            }
        }catch(IOException ioe){
            fail(ioe.getMessage());
        }
    }
    
    /**
     * f[^ǂݍ݃eXgi݂f[^[hj
    */
    public void testReadHex(){
        String data = "ՂŁ[";
        try{
            file.removeAll();
            boolean ret = file.writeHex("key", data.getBytes() ,false);
            assertEquals("df[^݂܂", ret, true);
            byte[] readData = file.readHex("key");
        
            assertNotNull("readBytes()NULLԂ", readData);
            assertEquals("f[^ǉfĂ܂", file.size(), 1);
            assertEquals("擾f[^Ⴂ܂", new String(readData), data);
        }catch(IOException ioe){
            fail(ioe.getMessage());
        }
    }
    
    /**
     * f[^ǂݍ݃eXgi݂Ȃf[^[hj
    */
    public void testReadHex2(){
        String data = "ՂŁ[";
        try{
            file.removeAll();
            boolean ret = file.writeHex("key", data.getBytes() ,false);
            assertEquals("df[^݂܂", ret, true);
            byte[] readData = file.readHex("");
            
            assertNull("readBytes()NULLȊO̒lԂ", readData);
            
        }catch(IOException ioe){
            fail(ioe.getMessage());
        }
    }
    
    /**
     * ̃f[^o^/ǂݍ
    */
    public void testMore(){
        String data = "data";
        //String key = "key";
        boolean append = true;
        int max = 30;
        file.removeAll();
        
        for(int i=0; i<max; i++ ){
            try{
                String buf = data + i;
                boolean ret = file.writeHex("key"+i, buf.getBytes(), append);
                assertEquals("o^sFdf[^݂܂", ret, true);
                append = true;
            }catch(IOException ioe){
                fail("o^sF"+ioe.getMessage());
            }
        }
        
        assertEquals("f[^̓o^sv", file.size(), max);
        
        for(int i=0; i<max; i++ ){
            byte[] readData = file.readHex("key"+i);
            
            assertNotNull("readBytes()NULLԂ", readData);
            assertEquals("擾f[^Ⴂ܂", new String(readData), (data+i));
            
        }
    }

    /**
     * write\bhɂHexȊO̒lރeXg
     */
    public void testWrite(){
        String data = "Ղf[^";
        
        try{
            file.removeAll();
            boolean ret = file.write("key", data ,false);
            assertEquals("write()̌ʂfalseŕԂ܂", ret, true);
        }catch(IOException ioe){
            fail(ioe.getMessage());
        }
    }
    
    /**
     * HexȊÕvpeBreadHex()œǂݍރeXg
     */
    public void testReadHexNotHex(){
        String data = "sampledata";
        
        try{
            file.removeAll();
            //HexɂÂ܂܂̃f[^
            boolean ret = file.write("key", data ,false);
            assertEquals("write()̌ʂfalseŕԂ܂", ret, true);
        }catch(IOException ioe){
            fail("write()ŃG[܂" + ioe.getMessage());
        }
        
        //HexŃf[^擾
        byte[] readData = file.readHex("key");
        String readStr = "";
        readStr = new String(readData);
        
        //System.out.println("readHex()̌ʁF" + readData);
        //System.out.println("readHex()StringF" + readStr);
        assertEquals("readHex()̌ʂႢ܂", data, readStr);
        
    }
    
    public void tearDown() {
        // ͂̃eXgvȌIΏ܂B
        file.removeAll();
        file = null;
    }
	public static Test suite() {
		return new TestSuite(TestHexPropertyFile.class);
	}

}
