package test.org.itscool.commons.request;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.net.URL;

import junit.framework.TestCase;

import org.itscool.commons.request.MultiHttpGeneralForm;

public class TestMultiHttpGeneralForm extends TestCase{

    public void testParse() throws Exception{
		MultiHttpGeneralForm instance = new MultiHttpGeneralForm();
		
		ClassLoader parent = ClassLoader.getSystemClassLoader();
		URL txt = parent.getResource("test/org/itscool/commons/request/testdata-multi.txt");
		
		byte[] buffer2 = readFile(txt.getPath());
		instance.doParseData(buffer2, "Shift_JIS");
		
	}
	
	/**
     * fobOpɎgp܂<br>
     * w肳ꂽt@C[hAoCgzɓWJ܂
     * @param filePath t@C̃pX
     * @return [ht@C̃oCgzԂ܂
     * @throws Exception
     */
	public static byte[] readFile(String path) throws Exception{
		FileInputStream fin = new FileInputStream(path);
		ByteArrayOutputStream bo = new ByteArrayOutputStream();
		
		int byteData;
		while((byteData=fin.read())!=-1){
			bo.write(byteData);
		}
		byte[] byteArray = bo.toByteArray();
		
		fin.close();
		bo.close();
		
		return byteArray;
	}

}
